/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;

public class OggPageHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg.atom");
    public static final byte[] CAPTURE_PATTERN = new byte[]{79, 103, 103, 83};
    public static final int OGG_PAGE_HEADER_FIXED_LENGTH = 27;
    public static final int MAXIMUM_NO_OF_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_PAGE_HEADER_SIZE = 282;
    public static final int MAXIMUM_PAGE_DATA_SIZE = 65025;
    public static final int MAXIMUM_PAGE_SIZE = 65307;
    public static final int FIELD_CAPTURE_PATTERN_POS = 0;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_POS = 4;
    public static final int FIELD_HEADER_TYPE_FLAG_POS = 5;
    public static final int FIELD_ABSOLUTE_GRANULE_POS = 6;
    public static final int FIELD_STREAM_SERIAL_NO_POS = 14;
    public static final int FIELD_PAGE_SEQUENCE_NO_POS = 18;
    public static final int FIELD_PAGE_CHECKSUM_POS = 22;
    public static final int FIELD_PAGE_SEGMENTS_POS = 26;
    public static final int FIELD_SEGMENT_TABLE_POS = 27;
    public static final int FIELD_CAPTURE_PATTERN_LENGTH = 4;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_LENGTH = 1;
    public static final int FIELD_HEADER_TYPE_FLAG_LENGTH = 1;
    public static final int FIELD_ABSOLUTE_GRANULE_LENGTH = 8;
    public static final int FIELD_STREAM_SERIAL_NO_LENGTH = 4;
    public static final int FIELD_PAGE_SEQUENCE_NO_LENGTH = 4;
    public static final int FIELD_PAGE_CHECKSUM_LENGTH = 4;
    public static final int FIELD_PAGE_SEGMENTS_LENGTH = 1;
    private byte[] rawHeaderData;
    private double absoluteGranulePosition;
    private int checksum;
    private byte headerTypeFlag;
    private boolean isValid = false;
    private int pageLength = 0;
    private int pageSequenceNumber;
    private int streamSerialNumber;
    private byte[] segmentTable;
    private List<PacketStartAndLength> packetList = new ArrayList<PacketStartAndLength>();
    private boolean lastPacketIncomplete = false;
    private long startByte = 0L;

    public static OggPageHeader read(ByteBuffer byteBuffer) throws IOException, CannotReadException {
        int n = byteBuffer.position();
        logger.fine("Trying to read OggPage at:" + n);
        byte[] byArray = new byte[CAPTURE_PATTERN.length];
        byteBuffer.get(byArray);
        if (!Arrays.equals(byArray, CAPTURE_PATTERN)) {
            throw new CannotReadException(ErrorMessage.OGG_HEADER_CANNOT_BE_FOUND.getMsg(new String(byArray)));
        }
        byteBuffer.position(n + 26);
        int n2 = byteBuffer.get() & 0xFF;
        byteBuffer.position(n);
        byArray = new byte[27 + n2];
        byteBuffer.get(byArray);
        OggPageHeader oggPageHeader = new OggPageHeader(byArray);
        return oggPageHeader;
    }

    public static OggPageHeader read(RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        long l = randomAccessFile.getFilePointer();
        logger.fine("Trying to read OggPage at:" + l);
        byte[] byArray = new byte[CAPTURE_PATTERN.length];
        randomAccessFile.read(byArray);
        if (!Arrays.equals(byArray, CAPTURE_PATTERN)) {
            randomAccessFile.seek(l);
            if (AbstractID3v2Tag.isId3Tag(randomAccessFile)) {
                logger.warning(ErrorMessage.OGG_CONTAINS_ID3TAG.getMsg(randomAccessFile.getFilePointer() - l));
                randomAccessFile.read(byArray);
                if (Arrays.equals(byArray, CAPTURE_PATTERN)) {
                    l = randomAccessFile.getFilePointer() - (long)CAPTURE_PATTERN.length;
                }
            } else {
                throw new CannotReadException(ErrorMessage.OGG_HEADER_CANNOT_BE_FOUND.getMsg(new String(byArray)));
            }
        }
        randomAccessFile.seek(l + 26L);
        int n = randomAccessFile.readByte() & 0xFF;
        randomAccessFile.seek(l);
        byArray = new byte[27 + n];
        randomAccessFile.read(byArray);
        OggPageHeader oggPageHeader = new OggPageHeader(byArray);
        oggPageHeader.setStartByte(l);
        return oggPageHeader;
    }

    public OggPageHeader(byte[] byArray) {
        this.rawHeaderData = byArray;
        byte by = byArray[4];
        this.headerTypeFlag = byArray[5];
        if (by == 0) {
            int n;
            this.absoluteGranulePosition = 0.0;
            for (n = 0; n < 8; ++n) {
                this.absoluteGranulePosition += (double)this.u(byArray[n + 6]) * Math.pow(2.0, 8 * n);
            }
            this.streamSerialNumber = Utils.getIntLE(byArray, 14, 17);
            this.pageSequenceNumber = Utils.getIntLE(byArray, 18, 21);
            this.checksum = Utils.getIntLE(byArray, 22, 25);
            n = this.u(byArray[26]);
            this.segmentTable = new byte[byArray.length - 27];
            int n2 = 0;
            Integer n3 = null;
            for (int i = 0; i < this.segmentTable.length; ++i) {
                this.segmentTable[i] = byArray[27 + i];
                n3 = this.u(this.segmentTable[i]);
                this.pageLength += n3.intValue();
                n2 += n3.intValue();
                if (n3 >= 255) continue;
                this.packetList.add(new PacketStartAndLength(this.pageLength - n2, n2));
                n2 = 0;
            }
            if (n3 != null && n3 == 255) {
                this.packetList.add(new PacketStartAndLength(this.pageLength - n2, n2));
                this.lastPacketIncomplete = true;
            }
            this.isValid = true;
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Constructed OggPage:" + this.toString());
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public boolean isLastPacketIncomplete() {
        return this.lastPacketIncomplete;
    }

    public double getAbsoluteGranulePosition() {
        logger.fine("Number Of Samples: " + this.absoluteGranulePosition);
        return this.absoluteGranulePosition;
    }

    public int getCheckSum() {
        return this.checksum;
    }

    public byte getHeaderType() {
        return this.headerTypeFlag;
    }

    public int getPageLength() {
        logger.fine("This page length: " + this.pageLength);
        return this.pageLength;
    }

    public int getPageSequence() {
        return this.pageSequenceNumber;
    }

    public int getSerialNumber() {
        return this.streamSerialNumber;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<PacketStartAndLength> getPacketList() {
        return this.packetList;
    }

    public byte[] getRawHeaderData() {
        return this.rawHeaderData;
    }

    public String toString() {
        String string = "Ogg Page Header:isValid:" + this.isValid + ":type:" + this.headerTypeFlag + ":oggPageHeaderLength:" + this.rawHeaderData.length + ":length:" + this.pageLength + ":seqNo:" + this.getPageSequence() + ":packetIncomplete:" + this.isLastPacketIncomplete() + ":serNum:" + this.getSerialNumber();
        for (PacketStartAndLength packetStartAndLength : this.getPacketList()) {
            string = string + packetStartAndLength.toString();
        }
        return string;
    }

    public long getStartByte() {
        return this.startByte;
    }

    public void setStartByte(long l) {
        this.startByte = l;
    }

    public static enum HeaderTypeFlag {
        FRESH_PACKET(0),
        CONTINUED_PACKET(1),
        START_OF_BITSTREAM(2),
        END_OF_BITSTREAM(4);

        byte fileValue;

        private HeaderTypeFlag(byte by) {
            this.fileValue = by;
        }

        public byte getFileValue() {
            return this.fileValue;
        }
    }

    public static class PacketStartAndLength {
        private Integer startPosition = 0;
        private Integer length = 0;

        public PacketStartAndLength(int n, int n2) {
            this.startPosition = n;
            this.length = n2;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int n) {
            this.startPosition = n;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public String toString() {
            return "NextPkt(start:" + this.startPosition + ":length:" + this.length + "),";
        }
    }
}

