/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MvhdBox;

public class Mp4StcoBox
extends AbstractMp4Box {
    public static final int VERSION_FLAG_POS = 0;
    public static final int OTHER_FLAG_POS = 1;
    public static final int NO_OF_OFFSETS_POS = 4;
    public static final int VERSION_FLAG_LENGTH = 1;
    public static final int OTHER_FLAG_LENGTH = 3;
    public static final int NO_OF_OFFSETS_LENGTH = 4;
    public static final int OFFSET_LENGTH = 4;
    private int noOfOffSets = 0;
    private int firstOffSet;

    public Mp4StcoBox(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) {
        this.header = mp4BoxHeader;
        this.dataBuffer = byteBuffer.slice();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3);
        this.noOfOffSets = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        this.firstOffSet = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
    }

    public void printTotalOffset() {
        int n = 0;
        this.dataBuffer.rewind();
        this.dataBuffer.position(8);
        for (int i = 0; i < this.noOfOffSets - 1; ++i) {
            n += Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.position(this.dataBuffer.position() + 4);
        }
        System.out.println("Print Offset Total:" + (n += Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1)));
    }

    public void printAlloffsets() {
        int n;
        System.out.println("Print Offsets:start");
        this.dataBuffer.rewind();
        this.dataBuffer.position(8);
        for (n = 0; n < this.noOfOffSets - 1; ++n) {
            int n2 = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            System.out.println("offset into audio data is:" + n2);
            this.dataBuffer.position(this.dataBuffer.position() + 4);
        }
        n = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        System.out.println("offset into audio data is:" + n);
        System.out.println("Print Offsets:end");
    }

    public void adjustOffsets(int n) {
        this.dataBuffer.rewind();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3 + 4);
        for (int i = 0; i < this.noOfOffSets; ++i) {
            int n2 = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.put(Utils.getSizeBEInt32(n2 += n));
        }
    }

    public Mp4StcoBox(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer, int n) {
        this.header = mp4BoxHeader;
        this.dataBuffer = byteBuffer.slice();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3);
        this.noOfOffSets = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        for (int i = 0; i < this.noOfOffSets; ++i) {
            int n2 = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.put(Utils.getSizeBEInt32(n2 += n));
        }
    }

    public int getNoOfOffSets() {
        return this.noOfOffSets;
    }

    public int getFirstOffSet() {
        return this.firstOffSet;
    }

    public static void debugShowStcoInfo(RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        Mp4BoxHeader mp4BoxHeader = Mp4BoxHeader.seekWithinLevel(randomAccessFile, Mp4AtomIdentifier.MOOV.getFieldName());
        if (mp4BoxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(mp4BoxHeader.getLength() - 8);
        randomAccessFile.getChannel().read(byteBuffer);
        byteBuffer.rewind();
        Mp4BoxHeader mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer, Mp4AtomIdentifier.MVHD.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        Mp4MvhdBox mp4MvhdBox = new Mp4MvhdBox(mp4BoxHeader2, byteBuffer2);
        byteBuffer2.position(byteBuffer2.position() + mp4BoxHeader2.getDataLength());
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.TRAK.getFieldName());
        int n = byteBuffer2.position() + mp4BoxHeader2.getDataLength();
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.MDIA.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.MDHD.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        byteBuffer2.position(byteBuffer2.position() + mp4BoxHeader2.getDataLength());
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.MINF.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.SMHD.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        byteBuffer2.position(byteBuffer2.position() + mp4BoxHeader2.getDataLength());
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.STBL.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mp4BoxHeader2 = Mp4BoxHeader.seekWithinLevel(byteBuffer2, Mp4AtomIdentifier.STCO.getFieldName());
        if (mp4BoxHeader2 == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        Mp4StcoBox mp4StcoBox = new Mp4StcoBox(mp4BoxHeader2, byteBuffer2);
        mp4StcoBox.printAlloffsets();
    }
}

