/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.InvalidBoxHeaderException;
import org.jaudiotagger.audio.exceptions.NullBoxIdException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public class Mp4BoxHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp4.atom");
    public static final int OFFSET_POS = 0;
    public static final int IDENTIFIER_POS = 4;
    public static final int OFFSET_LENGTH = 4;
    public static final int IDENTIFIER_LENGTH = 4;
    public static final int HEADER_LENGTH = 8;
    private String id;
    protected int length;
    private long filePos;
    protected ByteBuffer dataBuffer;
    public static final String CHARSET_UTF_8 = "UTF-8";

    public Mp4BoxHeader() {
    }

    public Mp4BoxHeader(String string) {
        if (string.length() != 4) {
            throw new RuntimeException("Invalid length:atom idenifier should always be 4 characters long");
        }
        this.dataBuffer = ByteBuffer.allocate(8);
        try {
            this.id = string;
            this.dataBuffer.put(4, string.getBytes("ISO-8859-1")[0]);
            this.dataBuffer.put(5, string.getBytes("ISO-8859-1")[1]);
            this.dataBuffer.put(6, string.getBytes("ISO-8859-1")[2]);
            this.dataBuffer.put(7, string.getBytes("ISO-8859-1")[3]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public Mp4BoxHeader(ByteBuffer byteBuffer) {
        this.update(byteBuffer);
    }

    public void update(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        this.dataBuffer = ByteBuffer.wrap(byArray);
        this.length = Utils.getIntBE(byArray, 0, 3);
        this.id = Utils.getString(byArray, 4, 4, "ISO-8859-1");
        logger.finest("Mp4BoxHeader id:" + this.id + ":length:" + this.length);
        if (this.id.equals("\u0000\u0000\u0000\u0000")) {
            throw new NullBoxIdException(ErrorMessage.MP4_UNABLE_TO_FIND_NEXT_ATOM_BECAUSE_IDENTIFIER_IS_INVALID.getMsg(this.id));
        }
        if (this.length < 8) {
            throw new InvalidBoxHeaderException(ErrorMessage.MP4_UNABLE_TO_FIND_NEXT_ATOM_BECAUSE_IDENTIFIER_IS_INVALID.getMsg(this.id, this.length));
        }
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        byte[] byArray = Utils.getSizeBEInt32(n);
        this.dataBuffer.put(0, byArray[0]);
        this.dataBuffer.put(1, byArray[1]);
        this.dataBuffer.put(2, byArray[2]);
        this.dataBuffer.put(3, byArray[3]);
        this.length = n;
    }

    public void setId(int n) {
        byte[] byArray = Utils.getSizeBEInt32(n);
        this.dataBuffer.put(5, byArray[0]);
        this.dataBuffer.put(6, byArray[1]);
        this.dataBuffer.put(7, byArray[2]);
        this.dataBuffer.put(8, byArray[3]);
        this.length = n;
    }

    public ByteBuffer getHeaderData() {
        this.dataBuffer.rewind();
        return this.dataBuffer;
    }

    public int getDataLength() {
        return this.length - 8;
    }

    public String toString() {
        return "Box " + this.id + ":length" + this.length + ":filepos:" + this.filePos;
    }

    public String getEncoding() {
        return CHARSET_UTF_8;
    }

    public static Mp4BoxHeader seekWithinLevel(RandomAccessFile randomAccessFile, String string) throws IOException {
        logger.finer("Started searching for:" + string + " in file at:" + randomAccessFile.getChannel().position());
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        int n = randomAccessFile.getChannel().read(byteBuffer);
        if (n != 8) {
            return null;
        }
        byteBuffer.rewind();
        mp4BoxHeader.update(byteBuffer);
        while (!mp4BoxHeader.getId().equals(string)) {
            logger.finer("Found:" + mp4BoxHeader.getId() + " Still searching for:" + string + " in file at:" + randomAccessFile.getChannel().position());
            if (mp4BoxHeader.getLength() < 8) {
                return null;
            }
            int n2 = randomAccessFile.skipBytes(mp4BoxHeader.getDataLength());
            logger.finer("Skipped:" + n2);
            if (n2 < mp4BoxHeader.getDataLength()) {
                return null;
            }
            byteBuffer.rewind();
            n = randomAccessFile.getChannel().read(byteBuffer);
            logger.finer("Header Bytes Read:" + n);
            byteBuffer.rewind();
            if (n == 8) {
                mp4BoxHeader.update(byteBuffer);
                continue;
            }
            return null;
        }
        return mp4BoxHeader;
    }

    public static Mp4BoxHeader seekWithinLevel(ByteBuffer byteBuffer, String string) throws IOException {
        logger.finer("Started searching for:" + string + " in bytebuffer at" + byteBuffer.position());
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader();
        if (byteBuffer.remaining() >= 8) {
            mp4BoxHeader.update(byteBuffer);
        } else {
            return null;
        }
        while (!mp4BoxHeader.getId().equals(string)) {
            logger.finer("Found:" + mp4BoxHeader.getId() + " Still searching for:" + string + " in bytebuffer at" + byteBuffer.position());
            if (mp4BoxHeader.getLength() < 8) {
                return null;
            }
            if (byteBuffer.remaining() < mp4BoxHeader.getLength() - 8) {
                return null;
            }
            byteBuffer.position(byteBuffer.position() + (mp4BoxHeader.getLength() - 8));
            if (byteBuffer.remaining() >= 8) {
                mp4BoxHeader.update(byteBuffer);
                continue;
            }
            return null;
        }
        logger.finer("Found:" + string + " in bytebuffer at" + byteBuffer.position());
        return mp4BoxHeader;
    }

    public long getFilePos() {
        return this.filePos;
    }

    public void setFilePos(long l) {
        this.filePos = l;
    }
}

