/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

public class Mp4AlacBox
extends AbstractMp4Box {
    public static final int OTHER_FLAG_LENGTH = 4;
    private int maxSamplePerFrame;
    private int unknown1;
    private int sampleSize;
    private int historyMult;
    private int initialHistory;
    private int kModifier;
    private int channels;
    private int unknown2;
    private int maxCodedFrameSize;
    private int bitRate;
    private int sampleRate;

    public Mp4AlacBox(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) {
        this.header = mp4BoxHeader;
        this.dataBuffer = byteBuffer;
    }

    public void processData() throws CannotReadException {
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        this.maxSamplePerFrame = Utils.readUBEInt32(this.dataBuffer);
        this.unknown1 = Utils.readUInt8(this.dataBuffer);
        this.sampleSize = Utils.readUInt8(this.dataBuffer);
        this.historyMult = Utils.readUInt8(this.dataBuffer);
        this.initialHistory = Utils.readUInt8(this.dataBuffer);
        this.kModifier = Utils.readUInt8(this.dataBuffer);
        this.channels = Utils.readUInt8(this.dataBuffer);
        this.unknown2 = Utils.readUBEInt16(this.dataBuffer);
        this.maxCodedFrameSize = Utils.readUBEInt32(this.dataBuffer);
        this.bitRate = Utils.readUBEInt32(this.dataBuffer);
        this.sampleRate = Utils.readUBEInt32(this.dataBuffer);
    }

    public int getMaxSamplePerFrame() {
        return this.maxSamplePerFrame;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getHistoryMult() {
        return this.historyMult;
    }

    public int getInitialHistory() {
        return this.initialHistory;
    }

    public int getKModifier() {
        return this.kModifier;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getMaxCodedFrameSize() {
        return this.maxCodedFrameSize;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String toString() {
        String string = "maxSamplePerFrame:" + this.maxSamplePerFrame + "unknown1:" + this.unknown1 + "sampleSize:" + this.sampleSize + "historyMult:" + this.historyMult + "initialHistory:" + this.initialHistory + "kModifier:" + this.kModifier + "channels:" + this.channels + "unknown2 :" + this.unknown2 + "maxCodedFrameSize:" + this.maxCodedFrameSize + "bitRate:" + this.bitRate + "sampleRate:" + this.sampleRate;
        return string;
    }
}

