/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.NullBoxIdException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.audio.mp4.atom.NullPadding;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;
import org.jaudiotagger.utils.tree.DefaultTreeModel;

public class Mp4AtomTree {
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel dataTree;
    private DefaultMutableTreeNode moovNode;
    private DefaultMutableTreeNode mdatNode;
    private DefaultMutableTreeNode stcoNode;
    private DefaultMutableTreeNode ilstNode;
    private DefaultMutableTreeNode metaNode;
    private DefaultMutableTreeNode tagsNode;
    private DefaultMutableTreeNode udtaNode;
    private DefaultMutableTreeNode hdlrWithinMdiaNode;
    private DefaultMutableTreeNode hdlrWithinMetaNode;
    private List<DefaultMutableTreeNode> freeNodes = new ArrayList<DefaultMutableTreeNode>();
    private List<DefaultMutableTreeNode> mdatNodes = new ArrayList<DefaultMutableTreeNode>();
    private List<DefaultMutableTreeNode> trakNodes = new ArrayList<DefaultMutableTreeNode>();
    private Mp4StcoBox stco;
    private ByteBuffer moovBuffer;
    private Mp4BoxHeader moovHeader;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp4");

    public Mp4AtomTree(RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        this.buildTree(randomAccessFile, true);
    }

    public Mp4AtomTree(RandomAccessFile randomAccessFile, boolean bl) throws IOException, CannotReadException {
        this.buildTree(randomAccessFile, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTreeModel buildTree(RandomAccessFile randomAccessFile, boolean bl) throws IOException, CannotReadException {
        FileChannel fileChannel = null;
        try {
            Object object;
            fileChannel = randomAccessFile.getChannel();
            fileChannel.position(0L);
            this.rootNode = new DefaultMutableTreeNode();
            this.dataTree = new DefaultTreeModel(this.rootNode);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            while (fileChannel.position() < fileChannel.size()) {
                object = new Mp4BoxHeader();
                byteBuffer.clear();
                fileChannel.read(byteBuffer);
                byteBuffer.rewind();
                try {
                    ((Mp4BoxHeader)object).update(byteBuffer);
                }
                catch (NullBoxIdException nullBoxIdException) {
                    if (this.moovNode != null & this.mdatNode != null) {
                        NullPadding nullPadding = new NullPadding(fileChannel.position() - 8L, fileChannel.size());
                        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nullPadding);
                        this.rootNode.add(defaultMutableTreeNode);
                        logger.warning(ErrorMessage.NULL_PADDING_FOUND_AT_END_OF_MP4.getMsg(nullPadding.getFilePos()));
                        break;
                    }
                    throw nullBoxIdException;
                }
                ((Mp4BoxHeader)object).setFilePos(fileChannel.position() - 8L);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                if (((Mp4BoxHeader)object).getId().equals(Mp4AtomIdentifier.MOOV.getFieldName())) {
                    if (this.moovNode != null & this.mdatNode != null) {
                        logger.warning(ErrorMessage.ADDITIONAL_MOOV_ATOM_AT_END_OF_MP4.getMsg(fileChannel.position() - 8L));
                        break;
                    }
                    this.moovNode = defaultMutableTreeNode;
                    this.moovHeader = object;
                    long l = fileChannel.position();
                    this.moovBuffer = ByteBuffer.allocate(((Mp4BoxHeader)object).getDataLength());
                    int n = fileChannel.read(this.moovBuffer);
                    if (n < ((Mp4BoxHeader)object).getDataLength()) {
                        String string = ErrorMessage.ATOM_LENGTH_LARGER_THAN_DATA.getMsg(((Mp4BoxHeader)object).getId(), ((Mp4BoxHeader)object).getDataLength(), n);
                        throw new CannotReadException(string);
                    }
                    this.moovBuffer.rewind();
                    this.buildChildrenOfNode(this.moovBuffer, defaultMutableTreeNode);
                    fileChannel.position(l);
                } else if (((Mp4BoxHeader)object).getId().equals(Mp4AtomIdentifier.FREE.getFieldName())) {
                    this.freeNodes.add(defaultMutableTreeNode);
                } else if (((Mp4BoxHeader)object).getId().equals(Mp4AtomIdentifier.MDAT.getFieldName())) {
                    this.mdatNode = defaultMutableTreeNode;
                    this.mdatNodes.add(defaultMutableTreeNode);
                }
                this.rootNode.add(defaultMutableTreeNode);
                fileChannel.position(fileChannel.position() + (long)((Mp4BoxHeader)object).getDataLength());
            }
            object = this.dataTree;
            return object;
        }
        finally {
            if (this.mdatNode == null) {
                throw new CannotReadException(ErrorMessage.MP4_CANNOT_FIND_AUDIO.getMsg());
            }
            if (bl) {
                fileChannel.close();
            }
        }
    }

    public void printAtomTree() {
        Enumeration enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Mp4BoxHeader mp4BoxHeader = (Mp4BoxHeader)defaultMutableTreeNode.getUserObject();
            if (mp4BoxHeader == null) continue;
            String string = "";
            for (int i = 1; i < defaultMutableTreeNode.getLevel(); ++i) {
                string = string + "\t";
            }
            if (mp4BoxHeader instanceof NullPadding) {
                System.out.println(string + "Null pad " + " @ " + mp4BoxHeader.getFilePos() + " of size:" + mp4BoxHeader.getLength() + " ,ends @ " + (mp4BoxHeader.getFilePos() + (long)mp4BoxHeader.getLength()));
                continue;
            }
            System.out.println(string + "Atom " + mp4BoxHeader.getId() + " @ " + mp4BoxHeader.getFilePos() + " of size:" + mp4BoxHeader.getLength() + " ,ends @ " + (mp4BoxHeader.getFilePos() + (long)mp4BoxHeader.getLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildChildrenOfNode(ByteBuffer byteBuffer, DefaultMutableTreeNode defaultMutableTreeNode) throws IOException, CannotReadException {
        Mp4BoxHeader mp4BoxHeader;
        Mp4BoxHeader mp4BoxHeader2 = (Mp4BoxHeader)defaultMutableTreeNode.getUserObject();
        int n = byteBuffer.position();
        if (mp4BoxHeader2.getId().equals(Mp4AtomIdentifier.META.getFieldName())) {
            Mp4MetaBox mp4MetaBox = new Mp4MetaBox(mp4BoxHeader2, byteBuffer);
            mp4MetaBox.processData();
            try {
                mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
            }
            catch (NullBoxIdException nullBoxIdException) {
                byteBuffer.position(byteBuffer.position() - 4);
            }
            finally {
                byteBuffer.position(byteBuffer.position() - 8);
            }
        }
        int n2 = byteBuffer.position();
        while (byteBuffer.position() < n2 + mp4BoxHeader2.getDataLength() - 8) {
            mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
            if (mp4BoxHeader == null) continue;
            mp4BoxHeader.setFilePos(this.moovHeader.getFilePos() + (long)byteBuffer.position());
            logger.finest("Atom " + mp4BoxHeader.getId() + " @ " + mp4BoxHeader.getFilePos() + " of size:" + mp4BoxHeader.getLength() + " ,ends @ " + (mp4BoxHeader.getFilePos() + (long)mp4BoxHeader.getLength()));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(mp4BoxHeader);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                this.udtaNode = defaultMutableTreeNode2;
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) && mp4BoxHeader2.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                this.metaNode = defaultMutableTreeNode2;
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.HDLR.getFieldName()) && mp4BoxHeader2.getId().equals(Mp4AtomIdentifier.META.getFieldName())) {
                this.hdlrWithinMetaNode = defaultMutableTreeNode2;
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.HDLR.getFieldName())) {
                this.hdlrWithinMdiaNode = defaultMutableTreeNode2;
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.TAGS.getFieldName())) {
                this.tagsNode = defaultMutableTreeNode2;
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.STCO.getFieldName())) {
                if (this.stco == null) {
                    this.stco = new Mp4StcoBox(mp4BoxHeader, byteBuffer);
                    this.stcoNode = defaultMutableTreeNode2;
                }
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) {
                Mp4BoxHeader mp4BoxHeader3;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (defaultMutableTreeNode3 != null && (mp4BoxHeader3 = (Mp4BoxHeader)defaultMutableTreeNode3.getUserObject()) != null && mp4BoxHeader2.getId().equals(Mp4AtomIdentifier.META.getFieldName()) && mp4BoxHeader3.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                    this.ilstNode = defaultMutableTreeNode2;
                }
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.FREE.getFieldName())) {
                this.freeNodes.add(defaultMutableTreeNode2);
            } else if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.TRAK.getFieldName())) {
                this.trakNodes.add(defaultMutableTreeNode2);
            }
            if (mp4BoxHeader.getId().equals(Mp4AtomIdentifier.TRAK.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.MDIA.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.MINF.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.STBL.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || mp4BoxHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) {
                this.buildChildrenOfNode(byteBuffer, defaultMutableTreeNode2);
            }
            byteBuffer.position(byteBuffer.position() + mp4BoxHeader.getDataLength());
        }
        byteBuffer.position(n);
    }

    public DefaultTreeModel getDataTree() {
        return this.dataTree;
    }

    public DefaultMutableTreeNode getMoovNode() {
        return this.moovNode;
    }

    public DefaultMutableTreeNode getStcoNode() {
        return this.stcoNode;
    }

    public DefaultMutableTreeNode getIlstNode() {
        return this.ilstNode;
    }

    public Mp4BoxHeader getBoxHeader(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return (Mp4BoxHeader)defaultMutableTreeNode.getUserObject();
    }

    public DefaultMutableTreeNode getMdatNode() {
        return this.mdatNode;
    }

    public DefaultMutableTreeNode getUdtaNode() {
        return this.udtaNode;
    }

    public DefaultMutableTreeNode getMetaNode() {
        return this.metaNode;
    }

    public DefaultMutableTreeNode getHdlrWithinMetaNode() {
        return this.hdlrWithinMetaNode;
    }

    public DefaultMutableTreeNode getHdlrWithinMdiaNode() {
        return this.hdlrWithinMdiaNode;
    }

    public DefaultMutableTreeNode getTagsNode() {
        return this.tagsNode;
    }

    public List<DefaultMutableTreeNode> getFreeNodes() {
        return this.freeNodes;
    }

    public List<DefaultMutableTreeNode> getTrakNodes() {
        return this.trakNodes;
    }

    public Mp4StcoBox getStco() {
        return this.stco;
    }

    public ByteBuffer getMoovBuffer() {
        return this.moovBuffer;
    }

    public Mp4BoxHeader getMoovHeader() {
        return this.moovHeader;
    }
}

