/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import org.jaudiotagger.audio.mp3.XingFrame;

public class ByteArrayMP3AudioHeader
extends MP3AudioHeader {
    public ByteArrayMP3AudioHeader(byte[] byArray) {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        boolean bl = false;
        do {
            if (MPEGFrameHeader.isMPEGFrame(byteBuffer)) {
                try {
                    this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(byteBuffer);
                    bl = true;
                    ByteBuffer byteBuffer2 = XingFrame.isXingFrame(byteBuffer, this.mp3FrameHeader);
                    if (byteBuffer2 != null) {
                        try {
                            this.mp3XingFrame = XingFrame.parseXingFrame(byteBuffer2);
                        }
                        catch (InvalidAudioFrameException invalidAudioFrameException) {}
                        break;
                    }
                    bl = this.isNextFrameValid(byteBuffer);
                    if (bl) {
                        break;
                    }
                }
                catch (InvalidAudioFrameException invalidAudioFrameException) {
                    // empty catch block
                }
            }
            byteBuffer.position(byteBuffer.position() + 1);
            ++l;
        } while (!bl);
        this.setFileSize(byArray.length);
        this.setMp3StartByte(l);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
    }

    private boolean isNextFrameValid(ByteBuffer byteBuffer) {
        boolean bl = false;
        int n = byteBuffer.position();
        byteBuffer.position(byteBuffer.position() + this.mp3FrameHeader.getFrameLength());
        if (MPEGFrameHeader.isMPEGFrame(byteBuffer)) {
            try {
                MPEGFrameHeader.parseMPEGHeader(byteBuffer);
                MP3AudioHeader.logger.finer("Check next frame confirms is an audio header ");
                bl = true;
            }
            catch (InvalidAudioFrameException invalidAudioFrameException) {
                MP3AudioHeader.logger.finer("Check next frame has identified this is not an audio header");
                bl = false;
            }
        }
        byteBuffer.position(n);
        return bl;
    }
}

