/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;

public class MetadataBlockHeader {
    public static final int BLOCK_TYPE_LENGTH = 1;
    public static final int BLOCK_LENGTH = 3;
    public static final int HEADER_LENGTH = 4;
    private boolean isLastBlock;
    private int dataLength;
    private byte[] bytes;
    private BlockType blockType;

    public static MetadataBlockHeader readHeader(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        int n = randomAccessFile.getChannel().read(byteBuffer);
        if (n < 4) {
            throw new IOException("Unable to read required number of databytes read:" + n + ":required:" + 4);
        }
        byteBuffer.rewind();
        return new MetadataBlockHeader(byteBuffer);
    }

    public String toString() {
        return "BlockType:" + (Object)((Object)this.blockType) + " DataLength:" + this.dataLength + " isLastBlock:" + this.isLastBlock;
    }

    public MetadataBlockHeader(ByteBuffer byteBuffer) {
        this.isLastBlock = (byteBuffer.get(0) & 0x80) >>> 7 == 1;
        int n = byteBuffer.get(0) & 0x7F;
        if (n < BlockType.values().length) {
            this.blockType = BlockType.values()[n];
        }
        this.dataLength = (this.u(byteBuffer.get(1)) << 16) + (this.u(byteBuffer.get(2)) << 8) + this.u(byteBuffer.get(3));
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = byteBuffer.get(i);
        }
    }

    public MetadataBlockHeader(boolean bl, BlockType blockType, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.blockType = blockType;
        this.isLastBlock = bl;
        this.dataLength = n;
        byte by = bl ? (byte)(0x80 | blockType.getId()) : (byte)blockType.getId();
        byteBuffer.put(by);
        byteBuffer.put((byte)((n & 0xFF0000) >>> 16));
        byteBuffer.put((byte)((n & 0xFF00) >>> 8));
        byteBuffer.put((byte)(n & 0xFF));
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = byteBuffer.get(i);
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public boolean isLastBlock() {
        return this.isLastBlock;
    }

    public byte[] getBytesWithoutIsLastBlockFlag() {
        this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
        return this.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

