/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;

public class MetadataBlockDataStreamInfo
implements MetadataBlockData {
    public static final int STREAM_INFO_DATA_LENGTH = 34;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataStreamInfo");
    private int minBlockSize;
    private int maxBlockSize;
    private int minFrameSize;
    private int maxFrameSize;
    private int samplingRate;
    private int samplingRatePerChannel;
    private int bitsPerSample;
    private int channelNumber;
    private int totalNumberOfSamples;
    private float songLength;
    private String md5;
    private boolean isValid = true;
    private ByteBuffer rawdata;

    public MetadataBlockDataStreamInfo(MetadataBlockHeader metadataBlockHeader, RandomAccessFile randomAccessFile) throws IOException {
        this.rawdata = ByteBuffer.allocate(metadataBlockHeader.getDataLength());
        int n = randomAccessFile.getChannel().read(this.rawdata);
        if (n < metadataBlockHeader.getDataLength()) {
            throw new IOException("Unable to read required number of databytes read:" + n + ":required:" + metadataBlockHeader.getDataLength());
        }
        this.rawdata.rewind();
        this.minBlockSize = this.rawdata.getShort();
        this.maxBlockSize = this.rawdata.getShort();
        this.minFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.maxFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.samplingRate = this.readSamplingRate(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.channelNumber = ((this.u(this.rawdata.get(12)) & 0xE) >>> 1) + 1;
        this.samplingRatePerChannel = this.samplingRate / this.channelNumber;
        this.bitsPerSample = ((this.u(this.rawdata.get(12)) & 1) << 4) + ((this.u(this.rawdata.get(13)) & 0xF0) >>> 4) + 1;
        this.totalNumberOfSamples = this.readTotalNumberOfSamples(this.rawdata.get(13), this.rawdata.get(14), this.rawdata.get(15), this.rawdata.get(16), this.rawdata.get(17));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 18; i < 34; ++i) {
            byte by = this.rawdata.get(i);
            stringBuilder.append(String.format("%x", by));
        }
        this.md5 = stringBuilder.toString();
        this.songLength = (float)((double)this.totalNumberOfSamples / (double)this.samplingRate);
        logger.config(this.toString());
    }

    @Override
    public byte[] getBytes() {
        return this.rawdata.array();
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    public String toString() {
        return "MinBlockSize:" + this.minBlockSize + "MaxBlockSize:" + this.maxBlockSize + "MinFrameSize:" + this.minFrameSize + "MaxFrameSize:" + this.maxFrameSize + "SampleRateTotal:" + this.samplingRate + "SampleRatePerChannel:" + this.samplingRatePerChannel + ":Channel number:" + this.channelNumber + ":Bits per sample: " + this.bitsPerSample + ":TotalNumberOfSamples: " + this.totalNumberOfSamples + ":Length: " + this.songLength;
    }

    public int getSongLength() {
        return (int)this.songLength;
    }

    public float getPreciseLength() {
        return this.songLength;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getSamplingRatePerChannel() {
        return this.samplingRatePerChannel;
    }

    public String getEncodingType() {
        return "FLAC " + this.bitsPerSample + " bits";
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public String getMD5Signature() {
        return this.md5;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int readThreeByteInteger(byte by, byte by2, byte by3) {
        int n = (this.u(by) << 16) + (this.u(by2) << 8) + this.u(by3);
        return n;
    }

    private int readSamplingRate(byte by, byte by2, byte by3) {
        int n = (this.u(by) << 12) + (this.u(by2) << 4) + ((this.u(by3) & 0xF0) >>> 4);
        return n;
    }

    private int readTotalNumberOfSamples(byte by, byte by2, byte by3, byte by4, byte by5) {
        int n = this.u(by5);
        n += this.u(by4) << 8;
        n += this.u(by3) << 16;
        n += this.u(by2) << 24;
        return n += (this.u(by) & 0xF) << 32;
    }

    private int u(int n) {
        return n & 0xFF;
    }
}

