/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.FlacTagCreator;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlock;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataApplication;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataCueSheet;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.flac.FlacTag;

public class FlacTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private FlacTagCreator tc = new FlacTagCreator();

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException, CannotWriteException {
        FlacTag flacTag = new FlacTag(null, new ArrayList<MetadataBlockDataPicture>());
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        this.write(flacTag, randomAccessFile, randomAccessFile2);
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        logger.config("Writing tag");
        MetadataBlockInfo metadataBlockInfo = new MetadataBlockInfo();
        FlacStreamReader flacStreamReader = new FlacStreamReader(randomAccessFile);
        try {
            flacStreamReader.findStream();
        }
        catch (CannotReadException cannotReadException) {
            throw new CannotWriteException(cannotReadException.getMessage());
        }
        boolean bl = false;
        while (!bl) {
            MetadataBlockHeader metadataBlockHeader = MetadataBlockHeader.readHeader(randomAccessFile);
            switch (metadataBlockHeader.getBlockType()) {
                case STREAMINFO: {
                    metadataBlockInfo.streamInfoBlock = new MetadataBlock(metadataBlockHeader, new MetadataBlockDataStreamInfo(metadataBlockHeader, randomAccessFile));
                    break;
                }
                case VORBIS_COMMENT: 
                case PADDING: 
                case PICTURE: {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
                    MetadataBlockData metadataBlockData = new MetadataBlockDataPadding(metadataBlockHeader.getDataLength());
                    metadataBlockInfo.metadataBlockPadding.add(new MetadataBlock(metadataBlockHeader, metadataBlockData));
                    break;
                }
                case APPLICATION: {
                    MetadataBlockData metadataBlockData = new MetadataBlockDataApplication(metadataBlockHeader, randomAccessFile);
                    metadataBlockInfo.metadataBlockApplication.add(new MetadataBlock(metadataBlockHeader, metadataBlockData));
                    break;
                }
                case SEEKTABLE: {
                    MetadataBlockData metadataBlockData = new MetadataBlockDataSeekTable(metadataBlockHeader, randomAccessFile);
                    metadataBlockInfo.metadataBlockSeekTable.add(new MetadataBlock(metadataBlockHeader, metadataBlockData));
                    break;
                }
                case CUESHEET: {
                    MetadataBlockData metadataBlockData = new MetadataBlockDataCueSheet(metadataBlockHeader, randomAccessFile);
                    metadataBlockInfo.metadataBlockCueSheet.add(new MetadataBlock(metadataBlockHeader, metadataBlockData));
                    break;
                }
                default: {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)metadataBlockHeader.getDataLength());
                }
            }
            bl = metadataBlockHeader.isLastBlock();
        }
        int n = this.computeAvailableRoom(metadataBlockInfo);
        int n2 = this.tc.convert(tag).limit();
        int n3 = n2 + this.computeNeededRoom(metadataBlockInfo);
        randomAccessFile.seek(flacStreamReader.getStartOfFlacInFile());
        logger.config("Writing tag available bytes:" + n + ":needed bytes:" + n3);
        if (n == n3 || n > n3 + 4) {
            randomAccessFile.seek(flacStreamReader.getStartOfFlacInFile() + 4);
            randomAccessFile.write(metadataBlockInfo.streamInfoBlock.getHeader().getBytesWithoutIsLastBlockFlag());
            randomAccessFile.write(metadataBlockInfo.streamInfoBlock.getData().getBytes());
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockApplication) {
                randomAccessFile.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile.write(metadataBlock.getData().getBytes());
            }
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockSeekTable) {
                randomAccessFile.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile.write(metadataBlock.getData().getBytes());
            }
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockCueSheet) {
                randomAccessFile.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile.write(metadataBlock.getData().getBytes());
            }
            randomAccessFile.getChannel().write(this.tc.convert(tag, n - n3));
        } else {
            if (flacStreamReader.getStartOfFlacInFile() > 0) {
                randomAccessFile.seek(0L);
                randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), 0L, flacStreamReader.getStartOfFlacInFile());
                randomAccessFile2.seek(flacStreamReader.getStartOfFlacInFile());
            }
            randomAccessFile2.writeBytes("fLaC");
            randomAccessFile2.writeByte(0);
            int n4 = flacStreamReader.getStartOfFlacInFile() + 4 + 1;
            randomAccessFile2.seek(n4);
            randomAccessFile.seek(n4);
            randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), n4, 37L);
            int n5 = flacStreamReader.getStartOfFlacInFile() + 4 + 4 + 34;
            randomAccessFile2.seek(n5);
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockApplication) {
                randomAccessFile2.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile2.write(metadataBlock.getData().getBytes());
            }
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockSeekTable) {
                randomAccessFile2.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile2.write(metadataBlock.getData().getBytes());
            }
            for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockCueSheet) {
                randomAccessFile2.write(metadataBlock.getHeader().getBytesWithoutIsLastBlockFlag());
                randomAccessFile2.write(metadataBlock.getData().getBytes());
            }
            randomAccessFile2.write(this.tc.convert(tag, 4000).array());
            randomAccessFile.seek(n5 + n);
            long l = randomAccessFile.getChannel().size() - randomAccessFile.getChannel().position();
            long l2 = 0L;
            long l3 = TagOptionSingleton.getInstance().getWriteChunkSize();
            long l4 = l / l3;
            long l5 = l % l3;
            int n6 = 0;
            while ((long)n6 < l4) {
                l2 += randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), randomAccessFile2.getChannel().position(), l3);
                randomAccessFile2.getChannel().position(randomAccessFile2.getChannel().position() + l3);
                ++n6;
            }
            if ((l2 += randomAccessFile2.getChannel().transferFrom(randomAccessFile.getChannel(), randomAccessFile2.getChannel().position(), l5)) != l) {
                throw new CannotWriteException("Was meant to write " + l + " bytes but only written " + l2 + " bytes");
            }
        }
    }

    private int computeAvailableRoom(MetadataBlockInfo metadataBlockInfo) {
        int n = 0;
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockApplication) {
            n += metadataBlock.getLength();
        }
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockSeekTable) {
            n += metadataBlock.getLength();
        }
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockCueSheet) {
            n += metadataBlock.getLength();
        }
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockPadding) {
            n += metadataBlock.getLength();
        }
        return n;
    }

    private int computeNeededRoom(MetadataBlockInfo metadataBlockInfo) {
        int n = 0;
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockApplication) {
            n += metadataBlock.getLength();
        }
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockSeekTable) {
            n += metadataBlock.getLength();
        }
        for (MetadataBlock metadataBlock : metadataBlockInfo.metadataBlockCueSheet) {
            n += metadataBlock.getLength();
        }
        return n;
    }

    private static class MetadataBlockInfo {
        private MetadataBlock streamInfoBlock;
        private List<MetadataBlock> metadataBlockPadding = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockApplication = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockSeekTable = new ArrayList<MetadataBlock>(1);
        private List<MetadataBlock> metadataBlockCueSheet = new ArrayList<MetadataBlock>(1);

        private MetadataBlockInfo() {
        }
    }
}

