/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.CountingOutputstream;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class WriteableChunkModifer
implements ChunkModifier {
    private final WriteableChunk writableChunk;

    public WriteableChunkModifer(WriteableChunk writeableChunk) {
        this.writableChunk = writeableChunk;
    }

    @Override
    public boolean isApplicable(GUID gUID) {
        return gUID.equals(this.writableChunk.getGuid());
    }

    @Override
    public ModificationResult modify(GUID gUID, InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        assert ((outputStream = new CountingOutputstream(outputStream)) != null);
        if (!this.writableChunk.isEmpty()) {
            l = this.writableChunk.writeInto(outputStream);
            assert (l == this.writableChunk.getCurrentAsfChunkSize());
            assert (((CountingOutputstream)outputStream).getCount() == l);
            if (gUID == null) {
                ++n;
            }
        }
        if (gUID != null) {
            assert (this.isApplicable(gUID));
            if (this.writableChunk.isEmpty()) {
                --n;
            }
            l2 = Utils.readUINT64(inputStream);
            inputStream.skip(l2 - 24L);
        }
        return new ModificationResult(n, l - l2, gUID);
    }
}

