/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_STREAM_BITRATE_PROPERTIES};

    protected StreamBitratePropertiesReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        BigInteger bigInteger = Utils.readBig64(inputStream);
        StreamBitratePropertiesChunk streamBitratePropertiesChunk = new StreamBitratePropertiesChunk(bigInteger);
        long l2 = Utils.readUINT16(inputStream);
        int n = 0;
        while ((long)n < l2) {
            int n2 = Utils.readUINT16(inputStream);
            long l3 = Utils.readUINT32(inputStream);
            streamBitratePropertiesChunk.addBitrateRecord(n2 & 0xFF, l3);
            ++n;
        }
        streamBitratePropertiesChunk.setPosition(l);
        return streamBitratePropertiesChunk;
    }
}

