/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.EncryptionChunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

class EncryptionChunkReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_CONTENT_ENCRYPTION};

    protected EncryptionChunkReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        BigInteger bigInteger = Utils.readBig64(inputStream);
        EncryptionChunk encryptionChunk = new EncryptionChunk(bigInteger);
        int n = (int)Utils.readUINT32(inputStream);
        byte[] byArray = new byte[n + 1];
        inputStream.read(byArray, 0, n);
        byArray[n] = 0;
        n = 0;
        n = (int)Utils.readUINT32(inputStream);
        byte[] byArray2 = new byte[n + 1];
        inputStream.read(byArray2, 0, n);
        byArray2[n] = 0;
        n = 0;
        n = (int)Utils.readUINT32(inputStream);
        byte[] byArray3 = new byte[n + 1];
        inputStream.read(byArray3, 0, n);
        byArray3[n] = 0;
        n = 0;
        n = (int)Utils.readUINT32(inputStream);
        byte[] byArray4 = new byte[n + 1];
        inputStream.read(byArray4, 0, n);
        byArray4[n] = 0;
        encryptionChunk.setSecretData(new String(byArray));
        encryptionChunk.setProtectionType(new String(byArray2));
        encryptionChunk.setKeyID(new String(byArray3));
        encryptionChunk.setLicenseURL(new String(byArray4));
        encryptionChunk.setPosition(l);
        return encryptionChunk;
    }
}

