/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentDescriptionReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_CONTENTDESCRIPTION};

    protected ContentDescriptionReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    private int[] getStringSizes(InputStream inputStream) throws IOException {
        int[] nArray = new int[5];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Utils.readUINT16(inputStream);
        }
        return nArray;
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        BigInteger bigInteger = Utils.readBig64(inputStream);
        int[] nArray = this.getStringSizes(inputStream);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            stringArray[i] = Utils.readFixedSizeUTF16Str(inputStream, nArray[i]);
        }
        ContentDescription contentDescription = new ContentDescription(l, bigInteger);
        if (nArray[0] > 0) {
            contentDescription.setTitle(stringArray[0]);
        }
        if (nArray[1] > 0) {
            contentDescription.setAuthor(stringArray[1]);
        }
        if (nArray[2] > 0) {
            contentDescription.setCopyright(stringArray[2]);
        }
        if (nArray[3] > 0) {
            contentDescription.setComment(stringArray[3]);
        }
        if (nArray[4] > 0) {
            contentDescription.setRating(stringArray[4]);
        }
        return contentDescription;
    }
}

