/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.CountingInputStream;
import org.jaudiotagger.audio.asf.util.Utils;

abstract class ChunkContainerReader<ChunkType extends ChunkContainer>
implements ChunkReader {
    protected static final Logger LOGGER = Logger.getLogger("org.jaudiotabgger.audio");
    public static final int READ_LIMIT = 8192;
    protected final boolean eachChunkOnce;
    protected boolean hasFailingReaders = false;
    protected final Map<GUID, ChunkReader> readerMap = new HashMap<GUID, ChunkReader>();

    protected ChunkContainerReader(List<Class<? extends ChunkReader>> list, boolean bl) {
        this.eachChunkOnce = bl;
        for (Class<? extends ChunkReader> clazz : list) {
            this.register(clazz);
        }
    }

    protected void checkStream(InputStream inputStream) throws IllegalArgumentException {
        if (this.hasFailingReaders && !inputStream.markSupported()) {
            throw new IllegalArgumentException("Stream has to support mark/reset.");
        }
    }

    protected abstract ChunkType createContainer(long var1, BigInteger var3, InputStream var4) throws IOException;

    protected ChunkReader getReader(GUID gUID) {
        return this.readerMap.get(gUID);
    }

    protected boolean isReaderAvailable(GUID gUID) {
        return this.readerMap.containsKey(gUID);
    }

    public ChunkType read(GUID gUID, InputStream inputStream, long l) throws IOException, IllegalArgumentException {
        this.checkStream(inputStream);
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        if (!Arrays.asList(this.getApplyingIds()).contains(gUID)) {
            throw new IllegalArgumentException("provided GUID is not supported by this reader.");
        }
        BigInteger bigInteger = Utils.readBig64(countingInputStream);
        ChunkType ChunkType = this.createContainer(l, bigInteger, countingInputStream);
        long l2 = l + countingInputStream.getReadCount() + 16L;
        HashSet<GUID> hashSet = new HashSet<GUID>();
        while (l2 < ((Chunk)ChunkType).getChunkEnd()) {
            Chunk chunk;
            boolean bl;
            GUID gUID2 = Utils.readGUID(countingInputStream);
            boolean bl2 = bl = this.eachChunkOnce && (!this.isReaderAvailable(gUID2) || !hashSet.add(gUID2));
            if (!bl && this.isReaderAvailable(gUID2)) {
                ChunkReader chunkReader = this.getReader(gUID2);
                if (chunkReader.canFail()) {
                    countingInputStream.mark(8192);
                }
                chunk = this.getReader(gUID2).read(gUID2, countingInputStream, l2);
            } else {
                chunk = ChunkHeaderReader.getInstance().read(gUID2, countingInputStream, l2);
            }
            if (chunk == null) {
                countingInputStream.reset();
                continue;
            }
            if (!bl) {
                ((ChunkContainer)ChunkType).addChunk(chunk);
            }
            l2 = chunk.getChunkEnd();
            assert (countingInputStream.getReadCount() + l + 16L == l2);
        }
        return ChunkType;
    }

    private <T extends ChunkReader> void register(Class<T> clazz) {
        try {
            ChunkReader chunkReader = (ChunkReader)clazz.newInstance();
            for (GUID gUID : chunkReader.getApplyingIds()) {
                this.readerMap.put(gUID, chunkReader);
            }
        }
        catch (InstantiationException instantiationException) {
            LOGGER.severe(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.severe(illegalAccessException.getMessage());
        }
    }
}

