/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class EncryptionChunk
extends Chunk {
    private String keyID = "";
    private String licenseURL = "";
    private String protectionType = "";
    private String secretData = "";
    private final ArrayList<String> strings = new ArrayList();

    public EncryptionChunk(BigInteger bigInteger) {
        super(GUID.GUID_CONTENT_ENCRYPTION, bigInteger);
    }

    public void addString(String string) {
        this.strings.add(string);
    }

    public String getKeyID() {
        return this.keyID;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public String getProtectionType() {
        return this.protectionType;
    }

    public String getSecretData() {
        return this.secretData;
    }

    public Collection<String> getStrings() {
        return new ArrayList<String>(this.strings);
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.insert(0, Utils.LINE_SEPARATOR + string + " Encryption:" + Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("\t|->keyID ").append(this.keyID).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("\t|->secretData ").append(this.secretData).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("\t|->protectionType ").append(this.protectionType).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("\t|->licenseURL ").append(this.licenseURL).append(Utils.LINE_SEPARATOR);
        this.strings.iterator();
        for (String string2 : this.strings) {
            stringBuilder.append(string).append("   |->").append(string2).append(Utils.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public void setKeyID(String string) {
        this.keyID = string;
    }

    public void setLicenseURL(String string) {
        this.licenseURL = string;
    }

    public void setProtectionType(String string) {
        this.protectionType = string;
    }

    public void setSecretData(String string) {
        this.secretData = string;
    }
}

