/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class Chunk {
    protected final BigInteger chunkLength;
    protected final GUID guid;
    protected long position;

    public Chunk(GUID gUID, BigInteger bigInteger) {
        if (gUID == null) {
            throw new IllegalArgumentException("GUID must not be null.");
        }
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = gUID;
        this.chunkLength = bigInteger;
    }

    public Chunk(GUID gUID, long l, BigInteger bigInteger) {
        if (gUID == null) {
            throw new IllegalArgumentException("GUID must not be null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Position of header can't be negative.");
        }
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = gUID;
        this.position = l;
        this.chunkLength = bigInteger;
    }

    @Deprecated
    public long getChunckEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public long getChunkEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public BigInteger getChunkLength() {
        return this.chunkLength;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public long getPosition() {
        return this.position;
    }

    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("-> GUID: ").append(GUID.getGuidDescription(this.guid)).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  | : Starts at position: ").append(this.getPosition()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  | : Last byte at: ").append(this.getChunkEnd() - 1L).append(Utils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public void setPosition(long l) {
        this.position = l;
    }

    public String toString() {
        return this.prettyPrint("");
    }
}

