/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderModifier;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.io.AsfStreamer;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.RandomAccessFileOutputStream;
import org.jaudiotagger.audio.asf.io.WriteableChunkModifer;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.asf.AsfTag;

public class AsfFileWriter
extends AudioFileWriter {
    @Override
    protected void deleteTag(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        this.writeTag(new AsfTag(true), randomAccessFile, randomAccessFile2);
    }

    private boolean[] searchExistence(ChunkContainer chunkContainer, MetadataContainer[] metadataContainerArray) {
        assert (chunkContainer != null);
        assert (metadataContainerArray != null);
        boolean[] blArray = new boolean[metadataContainerArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = chunkContainer.hasChunkByGUID(metadataContainerArray[i].getContainerType().getContainerGUID());
        }
        return blArray;
    }

    @Override
    protected void writeTag(Tag tag, RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotWriteException, IOException {
        AsfHeader asfHeader = AsfHeaderReader.readTagHeader(randomAccessFile);
        randomAccessFile.seek(0L);
        AsfTag asfTag = new AsfTag(tag, true);
        MetadataContainer[] metadataContainerArray = TagConverter.distributeMetadata(asfTag);
        boolean[] blArray = this.searchExistence(asfHeader, metadataContainerArray);
        boolean[] blArray2 = this.searchExistence(asfHeader.getExtendedHeader(), metadataContainerArray);
        ArrayList<ChunkModifier> arrayList = new ArrayList<ChunkModifier>();
        ArrayList<ChunkModifier> arrayList2 = new ArrayList<ChunkModifier>();
        for (int i = 0; i < metadataContainerArray.length; ++i) {
            WriteableChunkModifer writeableChunkModifer = new WriteableChunkModifer(metadataContainerArray[i]);
            if (blArray[i]) {
                arrayList.add(writeableChunkModifer);
                continue;
            }
            if (blArray2[i]) {
                arrayList2.add(writeableChunkModifer);
                continue;
            }
            if (i == 0 || i == 2 || i == 1) {
                arrayList.add(writeableChunkModifer);
                continue;
            }
            arrayList2.add(writeableChunkModifer);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(new AsfExtHeaderModifier(arrayList2));
        }
        new AsfStreamer().createModifiedCopy(new RandomAccessFileInputstream(randomAccessFile), new RandomAccessFileOutputStream(randomAccessFile2), arrayList);
    }
}

