/* Please keep these tables in alphabetical order, and in sync with
 * the ACT_* constants in kbdbind.h.  */

/* These two actions are common over all keymaps: */
ACTION_(MAIN, "none", NONE, N__("Do nothing"), 0),
ACTION_(MAIN, " *scripting-function*", SCRIPTING_FUNCTION, NULL, 0),

ACTION_(MAIN, "abort-connection", ABORT_CONNECTION, N__("Abort connection"), 0),
ACTION_(MAIN, "add-bookmark", ADD_BOOKMARK, N__("Add a new bookmark"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "add-bookmark-link", ADD_BOOKMARK_LINK, N__("Add a new bookmark using current link"), ACTION_RESTRICT_ANONYMOUS | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "add-bookmark-tabs", ADD_BOOKMARK_TABS, N__("Bookmark all open tabs"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "auth-manager", AUTH_MANAGER, N__("Open authentication manager"), 0),
ACTION_(MAIN, "backspace-prefix", BACKSPACE_PREFIX, N__("Backspace the last entered digit of the current prefix"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "bookmark-manager", BOOKMARK_MANAGER, N__("Open bookmark manager"), 0),
ACTION_(MAIN, "cache-manager", CACHE_MANAGER, N__("Open cache manager"), 0),
ACTION_(MAIN, "cache-minimize", CACHE_MINIMIZE, N__("Free unused cache entries"), 0),
ACTION_(MAIN, "cookie-manager", COOKIE_MANAGER, N__("Open cookie manager"), 0),
ACTION_(MAIN, "cookies-load", COOKIES_LOAD, N__("Reload cookies file"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "copy-clipboard", COPY_CLIPBOARD, N__("Copy text to clipboard"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "document-info", DOCUMENT_INFO, N__("Show information about the current page"), ACTION_JUMP_TO_LINK),
ACTION_(MAIN, "download-manager", DOWNLOAD_MANAGER, N__("Open download manager"), 0),
ACTION_(MAIN, "exmode", EXMODE, N__("Enter ex-mode (command line)"), 0),
ACTION_(MAIN, "file-menu", FILE_MENU, N__("Open the File menu"), 0),
ACTION_(MAIN, "find-next", FIND_NEXT, N__("Find the next occurrence of the current search text"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "find-next-back", FIND_NEXT_BACK, N__("Find the previous occurrence of the current search text"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "forget-credentials", FORGET_CREDENTIALS, N__("Forget authentication credentials"), 0),
ACTION_(MAIN, "formhist-manager", FORMHIST_MANAGER, N__("Open form history manager"), 0),
ACTION_(MAIN, "frame-external-command", FRAME_EXTERNAL_COMMAND, N__("Pass URI of current frame to external command"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "frame-maximize", FRAME_MAXIMIZE, N__("Maximize the current frame"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "frame-next", FRAME_NEXT, N__("Move to the next frame"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "frame-prev", FRAME_PREV, N__("Move to the previous frame"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "goto-url", GOTO_URL, N__("Open \"Go to URL\" dialog box"), 0),
ACTION_(MAIN, "goto-url-current", GOTO_URL_CURRENT, N__("Open \"Go to URL\" dialog box containing the current URL"), 0),
ACTION_(MAIN, "goto-url-current-link", GOTO_URL_CURRENT_LINK, N__("Open \"Go to URL\" dialog box containing the current link URL"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "goto-url-home", GOTO_URL_HOME, N__("Go to the homepage"), 0),
ACTION_(MAIN, "header-info", HEADER_INFO, N__("Show information about the current page protocol headers"), 0),
ACTION_(MAIN, "history-manager", HISTORY_MANAGER, N__("Open history manager"), 0),
ACTION_(MAIN, "history-move-back", HISTORY_MOVE_BACK, N__("Return to the previous document in history"), 0),
ACTION_(MAIN, "history-move-forward", HISTORY_MOVE_FORWARD, N__("Go forward in history"), 0),
ACTION_(MAIN, "jump-to-link", JUMP_TO_LINK, N__("Jump to link"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK),
ACTION_(MAIN, "keybinding-manager", KEYBINDING_MANAGER, N__("Open keybinding manager"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "kill-backgrounded-connections", KILL_BACKGROUNDED_CONNECTIONS, N__("Kill all backgrounded connections"), 0),
ACTION_(MAIN, "link-download", LINK_DOWNLOAD, N__("Download the current link"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-download-image", LINK_DOWNLOAD_IMAGE, N__("Download the current image"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-download-resume", LINK_DOWNLOAD_RESUME, N__("Attempt to resume download of the current link"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-external-command", LINK_EXTERNAL_COMMAND, N__("Pass URI of current link to external command"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-follow", LINK_FOLLOW, N__("Follow the current link"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-follow-reload", LINK_FOLLOW_RELOAD, N__("Follow the current link, forcing reload of the target"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-info", LINK_INFO, N__("Show information about current link"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-menu", LINK_MENU, N__("Open the link context menu"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "link-form-menu", LINK_FORM_MENU, N__("Open the form fields menu"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK | ACTION_REQUIRE_FORM),
ACTION_(MAIN, "lua-console", LUA_CONSOLE, N__("Open a Lua console"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "mark-goto", MARK_GOTO, N__("Go at a specified mark"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "mark-set", MARK_SET, N__("Set a mark"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "menu", MENU, N__("Activate the menu"), 0),
ACTION_(MAIN, "move-current-top", MOVE_CURRENT_TOP, N__("Move downwards to put the current line at the top"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-cursor-down", MOVE_CURSOR_DOWN, N__("Move cursor down"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-cursor-left", MOVE_CURSOR_LEFT, N__("Move cursor left"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-cursor-line-start", MOVE_CURSOR_LINE_START, N__("Move cursor to the start of the line"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-cursor-right", MOVE_CURSOR_RIGHT, N__("Move cursor right"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-cursor-up", MOVE_CURSOR_UP, N__("Move cursor up"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-document-end", MOVE_DOCUMENT_END, N__("Move to the end of the document"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-document-start", MOVE_DOCUMENT_START, N__("Move to the start of the document"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-half-page-down", MOVE_HALF_PAGE_DOWN, N__("Move downwards by half a page"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-half-page-up", MOVE_HALF_PAGE_UP, N__("Move upwards by half a page"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-down", MOVE_LINK_DOWN, N__("Move one link down"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-down-line", MOVE_LINK_DOWN_LINE, N__("Move to the next line with a link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-left", MOVE_LINK_LEFT, N__("Move one link left"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-left-line", MOVE_LINK_LEFT_LINE, N__("Move one link left or to the previous link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-next", MOVE_LINK_NEXT, N__("Move to the next link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-prev", MOVE_LINK_PREV, N__("Move to the previous link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-right", MOVE_LINK_RIGHT, N__("Move one link right"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-right-line", MOVE_LINK_RIGHT_LINE, N__("Move one link right or to the next link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-up", MOVE_LINK_UP, N__("Move one link up"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-link-up-line", MOVE_LINK_UP_LINE, N__("Move to the previous line with a link"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-page-down", MOVE_PAGE_DOWN, N__("Move downwards by a page"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "move-page-up", MOVE_PAGE_UP, N__("Move upwards by a page"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "open-link-in-new-tab", OPEN_LINK_IN_NEW_TAB, N__("Open the current link in a new tab"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "open-link-in-new-tab-in-background", OPEN_LINK_IN_NEW_TAB_IN_BACKGROUND, N__("Open the current link in a new tab in the background"), ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "open-link-in-new-window", OPEN_LINK_IN_NEW_WINDOW, N__("Open the current link in a new window"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
ACTION_(MAIN, "open-new-tab", OPEN_NEW_TAB, N__("Open a new tab"), 0),
ACTION_(MAIN, "open-new-tab-in-background", OPEN_NEW_TAB_IN_BACKGROUND, N__("Open a new tab in the background"), 0),
ACTION_(MAIN, "open-new-window", OPEN_NEW_WINDOW, N__("Open a new window"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "open-os-shell", OPEN_OS_SHELL, N__("Open an OS shell"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "options-manager", OPTIONS_MANAGER, N__("Open options manager"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "quit", QUIT, N__("Open a quit confirmation dialog box"), 0),
ACTION_(MAIN, "really-quit", REALLY_QUIT, N__("Quit without confirmation"), 0),
ACTION_(MAIN, "redraw", REDRAW, N__("Redraw the terminal"), 0),
ACTION_(MAIN, "reload", RELOAD, N__("Reload the current page"), 0),
ACTION_(MAIN, "rerender", RERENDER, N__("Re-render the current page"), 0),
ACTION_(MAIN, "reset-form", RESET_FORM, N__("Reset form items to their initial values"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "resource-info", RESOURCE_INFO, N__("Show information about the currently used resources"), 0),
ACTION_(MAIN, "save-as", SAVE_AS, N__("Save the current document in source form"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "save-formatted", SAVE_FORMATTED, N__("Save the current document in formatted form"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "save-options", SAVE_OPTIONS, N__("Save options"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "save-url-as", SAVE_URL_AS, N__("Save URL as"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(MAIN, "scroll-down", SCROLL_DOWN, N__("Scroll down"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "scroll-left", SCROLL_LEFT, N__("Scroll left"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "scroll-right", SCROLL_RIGHT, N__("Scroll right"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "scroll-up", SCROLL_UP, N__("Scroll up"), ACTION_REQUIRE_VIEW_STATE),
ACTION_(MAIN, "search", SEARCH, N__("Search for a text pattern"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "search-back", SEARCH_BACK, N__("Search backwards for a text pattern"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "search-typeahead", SEARCH_TYPEAHEAD, N__("Search link text by typing ahead"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "search-typeahead-link", SEARCH_TYPEAHEAD_LINK, N__("Search link text by typing ahead"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "search-typeahead-text", SEARCH_TYPEAHEAD_TEXT, N__("Search document text by typing ahead"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "search-typeahead-text-back", SEARCH_TYPEAHEAD_TEXT_BACK, N__("Search document text backwards by typing ahead"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "show-term-options", SHOW_TERM_OPTIONS, N__("Show terminal options dialog"), 0),
ACTION_(MAIN, "submit-form", SUBMIT_FORM, N__("Submit form"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "submit-form-reload", SUBMIT_FORM_RELOAD, N__("Submit form and reload"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "tab-close", TAB_CLOSE, N__("Close tab"), 0),
ACTION_(MAIN, "tab-close-all-but-current", TAB_CLOSE_ALL_BUT_CURRENT, N__("Close all tabs but the current one"), 0),
ACTION_(MAIN, "tab-external-command", TAB_EXTERNAL_COMMAND, N__("Pass URI of current tab to external command"), ACTION_RESTRICT_ANONYMOUS | ACTION_REQUIRE_LOCATION),
ACTION_(MAIN, "tab-menu", TAB_MENU, N__("Open the tab menu"), 0),
ACTION_(MAIN, "tab-move-left", TAB_MOVE_LEFT, N__("Move the current tab to the left"), 0),
ACTION_(MAIN, "tab-move-right", TAB_MOVE_RIGHT, N__("Move the current tab to the right"), 0),
ACTION_(MAIN, "tab-next", TAB_NEXT, N__("Next tab"), 0),
ACTION_(MAIN, "tab-prev", TAB_PREV, N__("Previous tab"), 0),
ACTION_(MAIN, "terminal-resize", TERMINAL_RESIZE, N__("Open the terminal resize dialog"), 0),
ACTION_(MAIN, "toggle-css", TOGGLE_CSS, N__("Toggle rendering of page using CSS"), 0),
ACTION_(MAIN, "toggle-display-images", TOGGLE_DISPLAY_IMAGES, N__("Toggle displaying of links to images"), 0),
ACTION_(MAIN, "toggle-display-tables", TOGGLE_DISPLAY_TABLES, N__("Toggle rendering of tables"), 0),
ACTION_(MAIN, "toggle-document-colors", TOGGLE_DOCUMENT_COLORS, N__("Toggle usage of document specific colors"), 0),
ACTION_(MAIN, "toggle-html-plain", TOGGLE_HTML_PLAIN, N__("Toggle rendering page as HTML / plain text"), 0),
ACTION_(MAIN, "toggle-mouse", TOGGLE_MOUSE, N__("Toggle mouse handling"), 0),
ACTION_(MAIN, "toggle-numbered-links", TOGGLE_NUMBERED_LINKS, N__("Toggle displaying of links numbers"), 0),
ACTION_(MAIN, "toggle-plain-compress-empty-lines", TOGGLE_PLAIN_COMPRESS_EMPTY_LINES, N__("Toggle plain renderer compression of empty lines"), 0),
ACTION_(MAIN, "toggle-wrap-text", TOGGLE_WRAP_TEXT, N__("Toggle wrapping of text"), 0),
ACTION_(MAIN, "view-image", VIEW_IMAGE, N__("View the current image"), ACTION_REQUIRE_VIEW_STATE | ACTION_REQUIRE_LOCATION | ACTION_JUMP_TO_LINK | ACTION_REQUIRE_LINK),
