Code-signing private key notes
==

The private keys for these certificates were generated on Gavin's main work machine,
following the certificate authoritys' recommendations for generating certificate
signing requests.

For OSX, the private key was generated by Keychain.app on Gavin's main work machine.
The key and certificate is in a separate, passphrase-protected keychain file that is
unlocked to sign the Dobbscoin-Qt.app bundle.

For Windows, the private key was generated by Firefox running on Gavin's main work machine.
The key and certificate were exported into a separate, passphrase-protected PKCS#12 file, and
then deleted from Firefox's keystore. The exported file is used to sign the Windows setup.exe.

Threat analysis
--

Gavin is a single point of failure. He could be coerced to divulge the secret signing keys,
allowing somebody to distribute a Dobbscoin-Qt.app or bitcoin-qt-setup.exe with a valid
signature but containing a malicious binary.

Or the machine Gavin uses to sign the binaries could be compromised, either remotely or
by breaking in to his office, allowing the attacker to get the private key files and then
install a keylogger to get the passphrase that protects them.

Threat Mitigation
--

"Air gapping" the machine used to do the signing will not work, because the signing
process needs to access a timestamp server over the network. And it would not
prevent the "rubber hose cryptography" threat (coercing Gavin to sign a bad binary
or divulge the private keys).

Windows binaries are reproducibly 'gitian-built', and the setup.exe file created
by the NSIS installer system is a 7zip archive, so you could check to make sure
that the dobbscoin-qt.exe file inside the installer had not been tampered with.
However, an attacker could modify the installer's code, so when the setup.exe
was run it compromised users' systems. A volunteer to write an auditing tool
that checks the setup.exe for tampering, and checks the files in it against
the list of gitian signatures, is needed.

The long-term solution is something like the 'gitian downloader' system, which
uses signatures from multiple developers to determine whether or not a binary
should be trusted. However, that just pushes the problem to "how will
non-technical users securely get the gitian downloader code to start?"
