/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.browser;

import davmail.BundleMessage;
import davmail.ui.AboutFrame;
import davmail.ui.browser.AwtDesktopBrowser;
import davmail.ui.browser.OSXDesktopBrowser;
import davmail.ui.browser.SwtDesktopBrowser;
import davmail.ui.tray.DavGatewayTray;
import java.net.URI;
import java.net.URISyntaxException;

public final class DesktopBrowser {
    private DesktopBrowser() {
    }

    public static void browse(URI location) {
        try {
            ClassLoader classloader = AboutFrame.class.getClassLoader();
            classloader.loadClass("java.awt.Desktop");
            AwtDesktopBrowser.browse(location);
        }
        catch (ClassNotFoundException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_JAVA6_DESKTOP_UNAVAILABLE", new Object[0]));
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                try {
                    OSXDesktopBrowser.browse(location);
                }
                catch (Exception e2) {
                    DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e2);
                }
            } else {
                try {
                    ClassLoader classloader = AboutFrame.class.getClassLoader();
                    classloader.loadClass("org.eclipse.swt.program.Program");
                    SwtDesktopBrowser.browse(location);
                }
                catch (ClassNotFoundException e2) {
                    DavGatewayTray.error(new BundleMessage("LOG_OPEN_LINK_NOT_SUPPORTED", new Object[0]));
                }
                catch (Exception e2) {
                    DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e2);
                }
            }
        }
        catch (Exception e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e);
        }
    }

    public static void browse(String location) {
        try {
            DesktopBrowser.browse(new URI(location));
        }
        catch (URISyntaxException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e);
        }
    }
}

