/*
 * Decompiled with CFR 0.152.
 */
package davmail.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.ExchangeSessionFactory;
import davmail.exchange.dav.DavExchangeSession;
import davmail.ui.tray.DavGatewayTray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;

public class LdapConnection
extends AbstractConnection {
    private static final Logger LOGGER = Logger.getLogger(LdapConnection.class);
    static final String BASE_CONTEXT = "ou=people";
    static final String OD_BASE_CONTEXT = "o=od";
    static final String OD_USER_CONTEXT = "cn=users, o=od";
    static final String OD_CONFIG_CONTEXT = "cn=config, o=od";
    static final String COMPUTER_CONTEXT = "cn=computers, o=od";
    static final String OD_GROUP_CONTEXT = "cn=groups, o=od";
    static final String COMPUTER_CONTEXT_LION = "cn=computers,o=od";
    static final String OD_USER_CONTEXT_LION = "cn=users, ou=people";
    static final List<String> NAMING_CONTEXTS = new ArrayList<String>();
    static final List<String> PERSON_OBJECT_CLASSES;
    static final HashMap<String, String> CONTACT_TO_LDAP_ATTRIBUTE_MAP;
    static final String COMPUTER_GUID = "52486C30-F0AB-48E3-9C37-37E9B28CDD7B";
    static final String VIRTUALHOST_GUID = "D6DD8A10-1098-11DE-8C30-0800200C9A66";
    static final HashMap<String, String> STATIC_ATTRIBUTE_MAP;
    static final HashMap<String, String> CRITERIA_MAP;
    static final HashMap<String, String> LDAP_TO_CONTACT_ATTRIBUTE_MAP;
    static final HashSet<String> IGNORE_MAP;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_OTHER = 80;
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_NOT = 162;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SET = 49;
    static final int LBER_SEQUENCE = 48;
    static final int SCOPE_BASE_OBJECT = 0;
    static final Method PARSE_INT_WITH_TAG_METHOD;
    protected SaslServer saslServer;
    protected BufferedInputStream is;
    protected final BerEncoder responseBer = new BerEncoder();
    int ldapVersion = 3;
    protected final HashMap<Integer, SearchRunnable> searchThreadMap = new HashMap();
    protected static final byte[] EMPTY_BYTE_ARRAY;
    protected String currentHostName;
    protected String serviceInfo;

    public LdapConnection(Socket clientSocket) {
        super(LdapConnection.class.getSimpleName(), clientSocket);
        try {
            this.is = new BufferedInputStream(this.client.getInputStream());
            this.os = new BufferedOutputStream(this.client.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            DavGatewayTray.error(new BundleMessage("LOG_EXCEPTION_GETTING_SOCKET_STREAMS", new Object[0]), e);
        }
    }

    protected boolean isLdapV3() {
        return this.ldapVersion == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] inbuf = new byte[2048];
        try {
            int offset;
            int bytesread;
            ExchangeSessionFactory.checkConfig();
            while ((bytesread = this.is.read(inbuf, offset = 0, 1)) >= 0) {
                int bytesleft;
                int seqlen;
                if (inbuf[offset++] != 48) continue;
                bytesread = this.is.read(inbuf, offset, 1);
                if (bytesread < 0) {
                    break;
                }
                if (((seqlen = inbuf[offset++]) & 0x80) == 128) {
                    int br;
                    int seqlenlen = seqlen & 0x7F;
                    boolean eos = false;
                    for (bytesread = 0; bytesread < seqlenlen; bytesread += br) {
                        br = this.is.read(inbuf, offset + bytesread, seqlenlen - bytesread);
                        if (br >= 0) continue;
                        eos = true;
                        break;
                    }
                    if (eos) {
                        break;
                    }
                    seqlen = 0;
                    for (int i = 0; i < seqlenlen; ++i) {
                        seqlen = (seqlen << 8) + (inbuf[offset + i] & 0xFF);
                    }
                    offset += bytesread;
                }
                if (offset + (bytesleft = seqlen) > inbuf.length) {
                    byte[] nbuf = new byte[offset + bytesleft];
                    System.arraycopy(inbuf, 0, nbuf, 0, offset);
                    inbuf = nbuf;
                }
                while (bytesleft > 0 && (bytesread = this.is.read(inbuf, offset, bytesleft)) >= 0) {
                    offset += bytesread;
                    bytesleft -= bytesread;
                }
                DavGatewayTray.switchIcon();
                this.handleRequest(inbuf, offset);
            }
        }
        catch (SocketException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_CLOSED", new Object[0]));
        }
        catch (SocketTimeoutException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CLOSE_CONNECTION_ON_TIMEOUT", new Object[0]));
        }
        catch (Exception e) {
            DavGatewayTray.log(e);
            try {
                this.sendErr(0, 97, e);
            }
            catch (IOException e2) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
            }
        }
        finally {
            HashMap<Integer, SearchRunnable> e = this.searchThreadMap;
            synchronized (e) {
                for (SearchRunnable searchRunnable : this.searchThreadMap.values()) {
                    searchRunnable.abandon();
                }
            }
            this.close();
        }
        DavGatewayTray.resetIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(byte[] inbuf, int offset) throws IOException {
        block33: {
            BerDecoder reqBer = new BerDecoder(inbuf, 0, offset);
            int currentMessageId = 0;
            try {
                reqBer.parseSeq(null);
                currentMessageId = reqBer.parseInt();
                int requestOperation = reqBer.peekByte();
                if (requestOperation == 96) {
                    reqBer.parseSeq(null);
                    this.ldapVersion = reqBer.parseInt();
                    this.userName = reqBer.parseString(this.isLdapV3());
                    if (reqBer.peekByte() == 163) {
                        int status;
                        byte[] serverResponse;
                        reqBer.parseSeq(null);
                        String mechanism = reqBer.parseString(this.isLdapV3());
                        CallbackHandler callbackHandler = new CallbackHandler(){

                            @Override
                            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                for (Callback callback : callbacks) {
                                    if (!(callback instanceof NameCallback)) continue;
                                    LdapConnection.this.userName = ((NameCallback)callback).getDefaultName();
                                    LdapConnection.this.password = ExchangeSessionFactory.getUserPassword(LdapConnection.this.userName);
                                }
                                for (Callback callback : callbacks) {
                                    if (callback instanceof AuthorizeCallback) {
                                        ((AuthorizeCallback)callback).setAuthorized(true);
                                        continue;
                                    }
                                    if (!(callback instanceof PasswordCallback) || LdapConnection.this.password == null) continue;
                                    ((PasswordCallback)callback).setPassword(LdapConnection.this.password.toCharArray());
                                }
                            }
                        };
                        if (reqBer.bytesLeft() > 0 && this.saslServer != null) {
                            byte[] clientResponse = reqBer.parseOctetString(4, null);
                            serverResponse = this.saslServer.evaluateResponse(clientResponse);
                            status = 0;
                            DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_USER", currentMessageId, this.userName));
                            try {
                                this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_SUCCESS", new Object[0]));
                            }
                            catch (IOException e) {
                                serverResponse = EMPTY_BYTE_ARRAY;
                                status = 49;
                                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_INVALID_CREDENTIALS", new Object[0]));
                            }
                        } else {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("javax.security.sasl.qop", "auth,auth-int");
                            this.saslServer = Sasl.createSaslServer(mechanism, "ldap", this.client.getLocalAddress().getHostAddress(), properties, callbackHandler);
                            if (this.saslServer == null) {
                                throw new IOException("Unable to create SASL server for mechanism " + mechanism);
                            }
                            serverResponse = this.saslServer.evaluateResponse(EMPTY_BYTE_ARRAY);
                            status = 14;
                        }
                        this.responseBer.beginSeq(48);
                        this.responseBer.encodeInt(currentMessageId);
                        this.responseBer.beginSeq(97);
                        this.responseBer.encodeInt(status, 10);
                        this.responseBer.encodeString("", this.isLdapV3());
                        this.responseBer.encodeString("", this.isLdapV3());
                        if (serverResponse != null) {
                            this.responseBer.encodeOctetString(serverResponse, 135);
                        }
                        this.responseBer.endSeq();
                        this.responseBer.endSeq();
                        this.sendResponse();
                    } else {
                        this.password = reqBer.parseStringWithTag(128, this.isLdapV3(), null);
                        if (this.userName.length() > 0 && this.password.length() > 0) {
                            DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_USER", currentMessageId, this.userName));
                            try {
                                this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_SUCCESS", new Object[0]));
                                this.sendClient(currentMessageId, 97, 0, "");
                            }
                            catch (IOException e) {
                                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_INVALID_CREDENTIALS", new Object[0]));
                                this.sendClient(currentMessageId, 97, 49, "");
                            }
                        } else {
                            DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_BIND_ANONYMOUS", currentMessageId));
                            this.sendClient(currentMessageId, 97, 0, "");
                        }
                    }
                    break block33;
                }
                if (requestOperation == 66) {
                    DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_UNBIND", currentMessageId));
                    if (this.session != null) {
                        this.session = null;
                    }
                    break block33;
                }
                if (requestOperation == 99) {
                    reqBer.parseSeq(null);
                    String dn = reqBer.parseString(this.isLdapV3());
                    int scope = reqBer.parseEnumeration();
                    reqBer.parseEnumeration();
                    int sizeLimit = reqBer.parseInt();
                    if (sizeLimit > 100 || sizeLimit == 0) {
                        sizeLimit = 100;
                    }
                    int timelimit = reqBer.parseInt();
                    reqBer.parseBoolean();
                    LdapFilter ldapFilter = this.parseFilter(reqBer);
                    Set<String> returningAttributes = this.parseReturningAttributes(reqBer);
                    SearchRunnable searchRunnable = new SearchRunnable(currentMessageId, dn, scope, sizeLimit, timelimit, ldapFilter, returningAttributes);
                    if (BASE_CONTEXT.equalsIgnoreCase(dn) || OD_USER_CONTEXT.equalsIgnoreCase(dn) || OD_USER_CONTEXT_LION.equalsIgnoreCase(dn)) {
                        HashMap<Integer, SearchRunnable> hashMap = this.searchThreadMap;
                        synchronized (hashMap) {
                            this.searchThreadMap.put(currentMessageId, searchRunnable);
                        }
                        Thread searchThread = new Thread(searchRunnable);
                        searchThread.setName(this.getName() + "-Search-" + currentMessageId);
                        searchThread.start();
                        break block33;
                    }
                    searchRunnable.run();
                    break block33;
                }
                if (requestOperation == 80) {
                    int abandonMessageId = 0;
                    try {
                        abandonMessageId = (Integer)PARSE_INT_WITH_TAG_METHOD.invoke((Object)reqBer, 80);
                        HashMap<Integer, SearchRunnable> scope = this.searchThreadMap;
                        synchronized (scope) {
                            SearchRunnable searchRunnable = this.searchThreadMap.get(abandonMessageId);
                            if (searchRunnable != null) {
                                searchRunnable.abandon();
                                this.searchThreadMap.remove(currentMessageId);
                            }
                        }
                    }
                    catch (IllegalAccessException e) {
                        DavGatewayTray.error(e);
                    }
                    catch (InvocationTargetException e) {
                        DavGatewayTray.error(e);
                    }
                    DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_ABANDON_SEARCH", currentMessageId, abandonMessageId));
                    break block33;
                }
                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_UNSUPPORTED_OPERATION", requestOperation));
                this.sendClient(currentMessageId, 101, 80, "Unsupported operation");
            }
            catch (IOException e) {
                this.dumpBer(inbuf, offset);
                try {
                    this.sendErr(currentMessageId, 101, e);
                }
                catch (IOException e2) {
                    DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
                }
                throw e;
            }
        }
    }

    protected void dumpBer(byte[] inbuf, int offset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Ber.dumpBER(baos, "LDAP request buffer\n", inbuf, 0, offset);
        try {
            LOGGER.debug((Object)new String(baos.toByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
    }

    protected LdapFilter parseFilter(BerDecoder reqBer) throws IOException {
        LdapFilter ldapFilter;
        if (reqBer.peekByte() == 135) {
            String attributeName = reqBer.parseStringWithTag(135, this.isLdapV3(), null).toLowerCase();
            ldapFilter = new SimpleFilter(attributeName);
        } else {
            int[] seqSize = new int[1];
            int ldapFilterType = reqBer.parseSeq(seqSize);
            int end = reqBer.getParsePosition() + seqSize[0];
            ldapFilter = this.parseNestedFilter(reqBer, ldapFilterType, end);
        }
        return ldapFilter;
    }

    protected LdapFilter parseNestedFilter(BerDecoder reqBer, int ldapFilterType, int end) throws IOException {
        LdapFilter nestedFilter;
        if (ldapFilterType == 161 || ldapFilterType == 160 || ldapFilterType == 162) {
            nestedFilter = new CompoundFilter(ldapFilterType);
            while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                if (reqBer.peekByte() == 135) {
                    String attributeName = reqBer.parseStringWithTag(135, this.isLdapV3(), null).toLowerCase();
                    nestedFilter.add(new SimpleFilter(attributeName));
                    continue;
                }
                int[] seqSize = new int[1];
                int ldapFilterOperator = reqBer.parseSeq(seqSize);
                int subEnd = reqBer.getParsePosition() + seqSize[0];
                nestedFilter.add(this.parseNestedFilter(reqBer, ldapFilterOperator, subEnd));
            }
        } else {
            nestedFilter = this.parseSimpleFilter(reqBer, ldapFilterType);
        }
        return nestedFilter;
    }

    protected LdapFilter parseSimpleFilter(BerDecoder reqBer, int ldapFilterOperator) throws IOException {
        String attributeName = reqBer.parseString(this.isLdapV3()).toLowerCase();
        int ldapFilterMode = 0;
        StringBuilder value = new StringBuilder();
        if (ldapFilterOperator == 164) {
            int[] seqSize = new int[1];
            reqBer.parseSeq(seqSize);
            int end = reqBer.getParsePosition() + seqSize[0];
            while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                ldapFilterMode = reqBer.peekByte();
                if (value.length() > 0) {
                    value.append(' ');
                }
                value.append(reqBer.parseStringWithTag(ldapFilterMode, this.isLdapV3(), null));
            }
        } else if (ldapFilterOperator == 163) {
            value.append(reqBer.parseString(this.isLdapV3()));
        } else {
            DavGatewayTray.warn(new BundleMessage("LOG_LDAP_UNSUPPORTED_FILTER_VALUE", new Object[0]));
        }
        String sValue = value.toString();
        if ("uid".equalsIgnoreCase(attributeName) && sValue.equals(this.userName) && sValue.equals(this.userName) && this.session instanceof DavExchangeSession) {
            sValue = this.session.getAlias();
            DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REPLACED_UID_FILTER", this.userName, sValue));
        }
        return new SimpleFilter(attributeName, sValue, ldapFilterOperator, ldapFilterMode);
    }

    protected Set<String> parseReturningAttributes(BerDecoder reqBer) throws IOException {
        HashSet<String> returningAttributes = new HashSet<String>();
        int[] seqSize = new int[1];
        reqBer.parseSeq(seqSize);
        int end = reqBer.getParsePosition() + seqSize[0];
        while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
            returningAttributes.add(reqBer.parseString(this.isLdapV3()).toLowerCase());
        }
        return returningAttributes;
    }

    protected void sendRootDSE(int currentMessageId) throws IOException {
        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_SEND_ROOT_DSE", new Object[0]));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("objectClass", "top");
        attributes.put("namingContexts", NAMING_CONTEXTS);
        this.sendEntry(currentMessageId, "Root DSE", attributes);
    }

    protected void addIf(Map<String, Object> attributes, Set<String> returningAttributes, String name, Object value) {
        if (returningAttributes.isEmpty() || returningAttributes.contains(name)) {
            attributes.put(name, value);
        }
    }

    protected String getCurrentHostName() throws UnknownHostException {
        if (this.currentHostName == null) {
            InetAddress clientInetAddress = this.client.getInetAddress();
            this.currentHostName = clientInetAddress != null && clientInetAddress.isLoopbackAddress() ? "localhost" : InetAddress.getLocalHost().getCanonicalHostName();
        }
        return this.currentHostName;
    }

    protected String getServiceInfo() throws UnknownHostException {
        if (this.serviceInfo == null) {
            this.serviceInfo = "<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE plist PUBLIC '-//Apple//DTD PLIST 1.0//EN' 'http://www.apple.com/DTDs/PropertyList-1.0.dtd'><plist version='1.0'><dict><key>com.apple.macosxserver.host</key><array><string>localhost</string></array><key>com.apple.macosxserver.virtualhosts</key><dict><key>D6DD8A10-1098-11DE-8C30-0800200C9A66</key><dict><key>hostDetails</key><dict><key>http</key><dict><key>enabled</key><true/><key>port</key><integer>" + Settings.getProperty("davmail.caldavPort") + "</integer>" + "</dict>" + "<key>https</key>" + "<dict>" + "<key>disabled</key>" + "<false/>" + "<key>port</key>" + "<integer>0</integer>" + "</dict>" + "</dict>" + "<key>hostname</key>" + "<string>" + this.getCurrentHostName() + "</string>" + "<key>serviceInfo</key>" + "<dict>" + "<key>calendar</key>" + "<dict>" + "<key>enabled</key>" + "<true/>" + "<key>templates</key>" + "<dict>" + "<key>calendarUserAddresses</key>" + "<array>" + "<string>%(principaluri)s</string>" + "<string>mailto:%(email)s</string>" + "<string>urn:uuid:%(guid)s</string>" + "</array>" + "<key>principalPath</key>" + "<string>/principals/__uuids__/%(guid)s/</string>" + "</dict>" + "</dict>" + "</dict>" + "<key>serviceType</key>" + "<array>" + "<string>calendar</string>" + "</array>" + "</dict>" + "</dict>" + "</dict>" + "</plist>";
        }
        return this.serviceInfo;
    }

    protected void sendComputerContext(int currentMessageId, Set<String> returningAttributes) throws IOException {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add("apple-computer");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addIf(attributes, returningAttributes, "objectClass", objectClasses);
        this.addIf(attributes, returningAttributes, "apple-generateduid", COMPUTER_GUID);
        this.addIf(attributes, returningAttributes, "apple-serviceinfo", this.getServiceInfo());
        this.addIf(attributes, returningAttributes, "apple-xmlplist", this.getServiceInfo());
        this.addIf(attributes, returningAttributes, "apple-serviceslocator", "::anyService");
        this.addIf(attributes, returningAttributes, "cn", this.getCurrentHostName());
        String dn = "cn=" + this.getCurrentHostName() + ", " + COMPUTER_CONTEXT;
        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_SEND_COMPUTER_CONTEXT", dn, attributes));
        this.sendEntry(currentMessageId, dn, attributes);
    }

    protected void sendBaseContext(int currentMessageId) throws IOException {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add("organizationalUnit");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("objectClass", objectClasses);
        attributes.put("description", "DavMail Gateway LDAP for " + Settings.getProperty("davmail.url"));
        this.sendEntry(currentMessageId, BASE_CONTEXT, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEntry(int currentMessageId, String dn, Map<String, Object> attributes) throws IOException {
        BerEncoder berEncoder = this.responseBer;
        synchronized (berEncoder) {
            this.responseBer.reset();
            this.responseBer.beginSeq(48);
            this.responseBer.encodeInt(currentMessageId);
            this.responseBer.beginSeq(100);
            this.responseBer.encodeString(dn, this.isLdapV3());
            this.responseBer.beginSeq(48);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.responseBer.beginSeq(48);
                this.responseBer.encodeString(entry.getKey(), this.isLdapV3());
                this.responseBer.beginSeq(49);
                Object values = entry.getValue();
                if (values instanceof String) {
                    this.responseBer.encodeString((String)values, this.isLdapV3());
                } else if (values instanceof List) {
                    for (Object value : (Iterable)values) {
                        this.responseBer.encodeString((String)value, this.isLdapV3());
                    }
                } else {
                    throw new DavMailException("EXCEPTION_UNSUPPORTED_VALUE", values);
                }
                this.responseBer.endSeq();
                this.responseBer.endSeq();
            }
            this.responseBer.endSeq();
            this.responseBer.endSeq();
            this.responseBer.endSeq();
            this.sendResponse();
        }
    }

    protected void sendErr(int currentMessageId, int responseOperation, Exception e) throws IOException {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        this.sendClient(currentMessageId, responseOperation, 80, message);
    }

    protected void sendClient(int currentMessageId, int responseOperation, int status, String message) throws IOException {
        this.responseBer.reset();
        this.responseBer.beginSeq(48);
        this.responseBer.encodeInt(currentMessageId);
        this.responseBer.beginSeq(responseOperation);
        this.responseBer.encodeInt(status, 10);
        this.responseBer.encodeString("", this.isLdapV3());
        this.responseBer.encodeString(message, this.isLdapV3());
        this.responseBer.endSeq();
        this.responseBer.endSeq();
        this.sendResponse();
    }

    protected void sendResponse() throws IOException {
        this.os.write(this.responseBer.getBuf(), 0, this.responseBer.getDataLen());
        this.os.flush();
    }

    protected static String getContactAttributeName(String ldapAttributeName) {
        String contactAttributeName = null;
        if (ExchangeSession.CONTACT_ATTRIBUTES.contains(ldapAttributeName)) {
            contactAttributeName = ldapAttributeName;
        } else if (LDAP_TO_CONTACT_ATTRIBUTE_MAP.containsKey(ldapAttributeName)) {
            String mappedAttribute = LDAP_TO_CONTACT_ATTRIBUTE_MAP.get(ldapAttributeName);
            if (mappedAttribute != null) {
                contactAttributeName = mappedAttribute;
            }
        } else {
            DavGatewayTray.debug(new BundleMessage("UNKNOWN_ATTRIBUTE", ldapAttributeName));
        }
        return contactAttributeName;
    }

    protected static String getLdapAttributeName(String contactAttributeName) {
        String mappedAttributeName = CONTACT_TO_LDAP_ATTRIBUTE_MAP.get(contactAttributeName);
        if (mappedAttributeName != null) {
            return mappedAttributeName;
        }
        return contactAttributeName;
    }

    protected Set<String> convertLdapToContactReturningAttributes(Set<String> returningAttributes) {
        Set<String> contactReturningAttributes;
        if (returningAttributes != null && !returningAttributes.isEmpty()) {
            contactReturningAttributes = new HashSet<String>();
            contactReturningAttributes.add("imapUid");
            for (String attribute : returningAttributes) {
                String contactAttributeName = LdapConnection.getContactAttributeName(attribute);
                if (contactAttributeName == null) continue;
                contactReturningAttributes.add(contactAttributeName);
            }
        } else {
            contactReturningAttributes = ExchangeSession.CONTACT_ATTRIBUTES;
        }
        return contactReturningAttributes;
    }

    static {
        NAMING_CONTEXTS.add(BASE_CONTEXT);
        NAMING_CONTEXTS.add(OD_BASE_CONTEXT);
        PERSON_OBJECT_CLASSES = new ArrayList<String>();
        PERSON_OBJECT_CLASSES.add("top");
        PERSON_OBJECT_CLASSES.add("person");
        PERSON_OBJECT_CLASSES.add("organizationalPerson");
        PERSON_OBJECT_CLASSES.add("inetOrgPerson");
        PERSON_OBJECT_CLASSES.add("apple-user");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP = new HashMap();
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("imapUid", "uid");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("co", "countryname");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("extensionattribute1", "custom1");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("extensionattribute2", "custom2");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("extensionattribute3", "custom3");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("extensionattribute4", "custom4");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("smtpemail1", "mail");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("smtpemail2", "xmozillasecondemail");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("homeCountry", "mozillahomecountryname");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("homeCity", "mozillahomelocalityname");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("homePostalCode", "mozillahomepostalcode");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("homeState", "mozillahomestate");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("homeStreet", "mozillahomestreet");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("businesshomepage", "mozillaworkurl");
        CONTACT_TO_LDAP_ATTRIBUTE_MAP.put("nickname", "mozillanickname");
        STATIC_ATTRIBUTE_MAP = new HashMap();
        STATIC_ATTRIBUTE_MAP.put("apple-serviceslocator", "52486C30-F0AB-48E3-9C37-37E9B28CDD7B:D6DD8A10-1098-11DE-8C30-0800200C9A66:calendar");
        CRITERIA_MAP = new HashMap();
        CRITERIA_MAP.put("uid", "AN");
        CRITERIA_MAP.put("mail", "FN");
        CRITERIA_MAP.put("displayname", "DN");
        CRITERIA_MAP.put("cn", "DN");
        CRITERIA_MAP.put("givenname", "FN");
        CRITERIA_MAP.put("sn", "LN");
        CRITERIA_MAP.put("title", "TL");
        CRITERIA_MAP.put("company", "CP");
        CRITERIA_MAP.put("o", "CP");
        CRITERIA_MAP.put("l", "OF");
        CRITERIA_MAP.put("department", "DP");
        CRITERIA_MAP.put("apple-group-realname", "DP");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP = new HashMap();
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("uid", "imapUid");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mail", "smtpemail1");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("displayname", "cn");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("commonname", "cn");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("givenname", "givenName");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("surname", "sn");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("company", "o");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-group-realname", "department");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomelocalityname", "homeCity");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("c", "co");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("countryname", "co");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("custom1", "extensionattribute1");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("custom2", "extensionattribute2");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("custom3", "extensionattribute3");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("custom4", "extensionattribute4");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillacustom1", "extensionattribute1");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillacustom2", "extensionattribute2");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillacustom3", "extensionattribute3");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillacustom4", "extensionattribute4");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("telephonenumber", "telephoneNumber");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("orgunit", "department");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("departmentnumber", "department");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("ou", "department");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillaworkstreet2", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomestreet", "homeStreet");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("xmozillanickname", "nickname");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillanickname", "nickname");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("cellphone", "mobile");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("homeurl", "personalHomePage");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomeurl", "personalHomePage");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-user-homeurl", "personalHomePage");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomepostalcode", "homePostalCode");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("fax", "facsimiletelephonenumber");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomecountryname", "homeCountry");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("streetaddress", "street");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillaworkurl", "businesshomepage");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("workurl", "businesshomepage");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("region", "st");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("birthmonth", "bday");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("birthday", "bday");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("birthyear", "bday");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("carphone", "othermobile");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("nsaimid", "im");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("nscpaimscreenname", "im");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-imhandle", "im");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("imhandle", "im");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("xmozillasecondemail", "smtpemail2");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("notes", "description");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("pagerphone", "pager");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("pager", "pager");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("locality", "l");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("homephone", "homePhone");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillasecondemail", "smtpemail2");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("zip", "postalcode");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomestate", "homeState");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("modifytimestamp", "lastmodified");
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("objectclass", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillausehtmlmail", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("xmozillausehtmlmail", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("mozillahomestreet2", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("labeleduri", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-generateduid", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("uidnumber", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("gidnumber", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("jpegphoto", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-emailcontacts", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-user-picture", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_usercertificate", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_realname", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_jpegphoto", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_guest", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_linkedidentity", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_defaultlanguage", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_hint", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers__defaultlanguage", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("_writers_picture", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-user-authenticationhint", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("external", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("userpassword", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("linkedidentity", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("homedirectory", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("authauthority", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("applefloor", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("buildingname", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("destinationindicator", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("postaladdress", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("homepostaladdress", null);
        LDAP_TO_CONTACT_ATTRIBUTE_MAP.put("apple-serviceslocator", "apple-serviceslocator");
        IGNORE_MAP = new HashSet();
        IGNORE_MAP.add("objectclass");
        IGNORE_MAP.add("apple-generateduid");
        IGNORE_MAP.add("augmentconfiguration");
        IGNORE_MAP.add("ou");
        IGNORE_MAP.add("apple-realname");
        IGNORE_MAP.add("apple-group-nestedgroup");
        IGNORE_MAP.add("apple-group-memberguid");
        IGNORE_MAP.add("macaddress");
        IGNORE_MAP.add("memberuid");
        try {
            PARSE_INT_WITH_TAG_METHOD = BerDecoder.class.getDeclaredMethod("parseIntWithTag", Integer.TYPE);
            PARSE_INT_WITH_TAG_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_GET_PARSEINTWITHTAG", new Object[0]));
            throw new RuntimeException(e);
        }
        EMPTY_BYTE_ARRAY = new byte[0];
    }

    protected class SearchRunnable
    implements Runnable {
        private final int currentMessageId;
        private final String dn;
        private final int scope;
        private final int sizeLimit;
        private final int timelimit;
        private final LdapFilter ldapFilter;
        private final Set<String> returningAttributes;
        private boolean abandon;

        protected SearchRunnable(int currentMessageId, String dn, int scope, int sizeLimit, int timelimit, LdapFilter ldapFilter, Set<String> returningAttributes) {
            this.currentMessageId = currentMessageId;
            this.dn = dn;
            this.scope = scope;
            this.sizeLimit = sizeLimit;
            this.timelimit = timelimit;
            this.ldapFilter = ldapFilter;
            this.returningAttributes = returningAttributes;
        }

        protected void abandon() {
            this.abandon = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int size = 0;
                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH", this.currentMessageId, this.dn, this.scope, this.sizeLimit, this.timelimit, this.ldapFilter.toString(), this.returningAttributes));
                if (this.scope == 0) {
                    if (this.dn != null && this.dn.length() == 0) {
                        size = 1;
                        LdapConnection.this.sendRootDSE(this.currentMessageId);
                    } else if (LdapConnection.BASE_CONTEXT.equals(this.dn)) {
                        size = 1;
                        LdapConnection.this.sendBaseContext(this.currentMessageId);
                    } else if (this.dn != null && this.dn.startsWith("uid=") && this.dn.indexOf(44) > 0) {
                        if (LdapConnection.this.session != null) {
                            String uid = this.dn.substring("uid=".length(), this.dn.indexOf(44));
                            Map<String, ExchangeSession.Contact> persons = null;
                            try {
                                Integer.parseInt(uid);
                                persons = this.contactFind(LdapConnection.this.session.isEqualTo("imapUid", uid), this.returningAttributes, this.sizeLimit);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (persons == null || persons.isEmpty()) {
                                persons = LdapConnection.this.session.galFind(LdapConnection.this.session.isEqualTo("imapUid", uid), LdapConnection.this.convertLdapToContactReturningAttributes(this.returningAttributes), this.sizeLimit);
                                ExchangeSession.Contact person = persons.get(uid.toLowerCase());
                                if (persons.size() > 1 || person == null) {
                                    persons = new HashMap<String, ExchangeSession.Contact>();
                                    if (person != null) {
                                        persons.put(uid.toLowerCase(), person);
                                    }
                                }
                            }
                            size = persons.size();
                            this.sendPersons(this.currentMessageId, this.dn.substring(this.dn.indexOf(44)), persons, this.returningAttributes);
                        } else {
                            DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_ANONYMOUS_ACCESS_FORBIDDEN", this.currentMessageId, this.dn));
                        }
                    } else {
                        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_INVALID_DN", this.currentMessageId, this.dn));
                    }
                } else if (LdapConnection.COMPUTER_CONTEXT.equals(this.dn) || LdapConnection.COMPUTER_CONTEXT_LION.equals(this.dn)) {
                    size = 1;
                    LdapConnection.this.sendComputerContext(this.currentMessageId, this.returningAttributes);
                } else if (LdapConnection.BASE_CONTEXT.equalsIgnoreCase(this.dn) || LdapConnection.OD_USER_CONTEXT.equalsIgnoreCase(this.dn) || LdapConnection.OD_USER_CONTEXT_LION.equalsIgnoreCase(this.dn)) {
                    if (LdapConnection.this.session != null) {
                        HashMap<String, ExchangeSession.Contact> persons = new HashMap<String, ExchangeSession.Contact>();
                        if (this.ldapFilter.isFullSearch()) {
                            for (ExchangeSession.Contact person : this.contactFind(null, this.returningAttributes, this.sizeLimit).values()) {
                                persons.put((String)person.get("imapUid"), person);
                                if (persons.size() != this.sizeLimit) continue;
                                break;
                            }
                            for (char c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
                                if (!this.abandon && persons.size() < this.sizeLimit) {
                                    for (ExchangeSession.Contact person : LdapConnection.this.session.galFind(LdapConnection.this.session.startsWith("cn", String.valueOf(c)), LdapConnection.this.convertLdapToContactReturningAttributes(this.returningAttributes), this.sizeLimit).values()) {
                                        persons.put((String)person.get("uid"), person);
                                        if (persons.size() != this.sizeLimit) continue;
                                        break;
                                    }
                                }
                                if (persons.size() != this.sizeLimit) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            ExchangeSession.Condition filter = this.ldapFilter.getContactSearchFilter();
                            if (this.ldapFilter.isFullSearch() || filter != null) {
                                for (ExchangeSession.Contact person : this.contactFind(filter, this.returningAttributes, this.sizeLimit).values()) {
                                    persons.put((String)person.get("imapUid"), person);
                                    if (persons.size() != this.sizeLimit) continue;
                                    break;
                                }
                                if (!this.abandon && persons.size() < this.sizeLimit) {
                                    for (ExchangeSession.Contact person : this.ldapFilter.findInGAL(LdapConnection.this.session, this.returningAttributes, this.sizeLimit - persons.size()).values()) {
                                        if (persons.size() != this.sizeLimit) {
                                            persons.put((String)person.get("uid"), person);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        size = persons.size();
                        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_FOUND_RESULTS", this.currentMessageId, size));
                        this.sendPersons(this.currentMessageId, ", " + this.dn, persons, this.returningAttributes);
                        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_END", this.currentMessageId));
                    } else {
                        DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_ANONYMOUS_ACCESS_FORBIDDEN", this.currentMessageId, this.dn));
                    }
                } else if (this.dn != null && this.dn.length() > 0 && !LdapConnection.OD_CONFIG_CONTEXT.equals(this.dn) && !LdapConnection.OD_GROUP_CONTEXT.equals(this.dn)) {
                    DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_INVALID_DN", this.currentMessageId, this.dn));
                }
                if (size > 1 && size == this.sizeLimit) {
                    DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_SIZE_LIMIT_EXCEEDED", this.currentMessageId));
                    LdapConnection.this.sendClient(this.currentMessageId, 101, 4, "");
                } else {
                    DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_SUCCESS", this.currentMessageId));
                    LdapConnection.this.sendClient(this.currentMessageId, 101, 0, "");
                }
            }
            catch (SocketException e) {
                LOGGER.warn((Object)BundleMessage.formatLog("LOG_CLIENT_CLOSED_CONNECTION", new Object[0]));
            }
            catch (IOException e) {
                DavGatewayTray.log(e);
                try {
                    LdapConnection.this.sendErr(this.currentMessageId, 101, e);
                }
                catch (IOException e2) {
                    DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
                }
            }
            finally {
                HashMap<Integer, SearchRunnable> e = LdapConnection.this.searchThreadMap;
                synchronized (e) {
                    LdapConnection.this.searchThreadMap.remove(this.currentMessageId);
                }
            }
            DavGatewayTray.resetIcon();
        }

        public Map<String, ExchangeSession.Contact> contactFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int maxCount) throws IOException {
            HashMap<String, ExchangeSession.Contact> results = new HashMap<String, ExchangeSession.Contact>();
            Set<String> contactReturningAttributes = LdapConnection.this.convertLdapToContactReturningAttributes(returningAttributes);
            contactReturningAttributes.remove("apple-serviceslocator");
            List<ExchangeSession.Contact> contacts = LdapConnection.this.session.searchContacts("contacts", contactReturningAttributes, condition, maxCount);
            for (ExchangeSession.Contact contact : contacts) {
                String imapUid = (String)contact.get("imapUid");
                if (imapUid == null) continue;
                results.put(imapUid, contact);
            }
            return results;
        }

        protected void sendPersons(int currentMessageId, String baseContext, Map<String, ExchangeSession.Contact> persons, Set<String> returningAttributes) throws IOException {
            boolean needObjectClasses = returningAttributes.contains("objectclass") || returningAttributes.isEmpty();
            boolean returnAllAttributes = returningAttributes.isEmpty();
            for (ExchangeSession.Contact person : persons.values()) {
                String value;
                String ldapAttribute;
                if (this.abandon) break;
                HashMap<String, Object> ldapPerson = new HashMap<String, Object>();
                if (returnAllAttributes) {
                    for (Map.Entry entry : person.entrySet()) {
                        ldapAttribute = LdapConnection.getLdapAttributeName((String)entry.getKey());
                        value = (String)entry.getValue();
                        if (value == null) continue;
                        ldapPerson.put(ldapAttribute, value);
                    }
                } else {
                    ldapPerson.put("uid", person.get("imapUid"));
                    for (String string : returningAttributes) {
                        String contactAttribute = LdapConnection.getContactAttributeName(string);
                        value = (String)person.get(contactAttribute);
                        if (value == null) continue;
                        if (string.startsWith("birth")) {
                            SimpleDateFormat parser = ExchangeSession.getZuluDateFormat();
                            Calendar calendar = Calendar.getInstance();
                            try {
                                calendar.setTime(parser.parse(value));
                            }
                            catch (ParseException e) {
                                throw new IOException(e + " " + e.getMessage());
                            }
                            if ("birthday".equals(string)) {
                                value = String.valueOf(calendar.get(5));
                            } else if ("birthmonth".equals(string)) {
                                value = String.valueOf(calendar.get(2) + 1);
                            } else if ("birthyear".equals(string)) {
                                value = String.valueOf(calendar.get(1));
                            }
                        }
                        ldapPerson.put(string, value);
                    }
                }
                for (Map.Entry entry : STATIC_ATTRIBUTE_MAP.entrySet()) {
                    ldapAttribute = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if (value == null || !returnAllAttributes && !returningAttributes.contains(ldapAttribute)) continue;
                    ldapPerson.put(ldapAttribute, value);
                }
                if (needObjectClasses) {
                    ldapPerson.put("objectClass", PERSON_OBJECT_CLASSES);
                }
                if (returnAllAttributes || returningAttributes.contains("apple-generateduid")) {
                    String mail = (String)ldapPerson.get("mail");
                    if (mail != null) {
                        ldapPerson.put("apple-generateduid", mail.replaceAll("@", "__AT__"));
                    } else {
                        ldapPerson.put("apple-generateduid", ldapPerson.get("uid"));
                    }
                }
                if (LdapConnection.this.session.getAlias().equals(ldapPerson.get("uid")) && returningAttributes.contains("uidnumber")) {
                    ldapPerson.put("uidnumber", LdapConnection.this.userName);
                }
                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_REQ_SEARCH_SEND_PERSON", currentMessageId, ldapPerson.get("uid"), baseContext, ldapPerson));
                LdapConnection.this.sendEntry(currentMessageId, "uid=" + ldapPerson.get("uid") + baseContext, ldapPerson);
            }
        }
    }

    class SimpleFilter
    implements LdapFilter {
        static final String STAR = "*";
        final String attributeName;
        final String value;
        final int mode;
        final int operator;
        final boolean canIgnore;

        SimpleFilter(String attributeName) {
            this.attributeName = attributeName;
            this.value = STAR;
            this.operator = 164;
            this.mode = 0;
            this.canIgnore = this.checkIgnore();
        }

        SimpleFilter(String attributeName, String value, int ldapFilterOperator, int ldapFilterMode) {
            this.attributeName = attributeName;
            this.value = value;
            this.operator = ldapFilterOperator;
            this.mode = ldapFilterMode;
            this.canIgnore = this.checkIgnore();
        }

        private boolean checkIgnore() {
            if ("objectclass".equals(this.attributeName) && STAR.equals(this.value)) {
                return true;
            }
            if (IGNORE_MAP.contains(this.attributeName)) {
                return true;
            }
            if (CRITERIA_MAP.get(this.attributeName) == null && LdapConnection.getContactAttributeName(this.attributeName) == null) {
                DavGatewayTray.debug(new BundleMessage("LOG_LDAP_UNSUPPORTED_FILTER_ATTRIBUTE", this.attributeName, this.value));
                return true;
            }
            return false;
        }

        @Override
        public boolean isFullSearch() {
            return "objectclass".equals(this.attributeName) && STAR.equals(this.value);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            buffer.append(this.attributeName);
            buffer.append('=');
            if (STAR.equals(this.value)) {
                buffer.append(STAR);
            } else if (this.operator == 164) {
                if (this.mode == 130 || this.mode == 129) {
                    buffer.append(STAR);
                }
                buffer.append(this.value);
                if (this.mode == 128 || this.mode == 129) {
                    buffer.append(STAR);
                }
            } else {
                buffer.append(this.value);
            }
            buffer.append(')');
            return buffer.toString();
        }

        @Override
        public ExchangeSession.Condition getContactSearchFilter() {
            String contactAttributeName = LdapConnection.getContactAttributeName(this.attributeName);
            if (this.canIgnore || contactAttributeName == null) {
                return null;
            }
            ExchangeSession.Condition condition = null;
            if (this.operator == 163) {
                condition = LdapConnection.this.session.isEqualTo(contactAttributeName, this.value);
            } else if (STAR.equals(this.value)) {
                condition = LdapConnection.this.session.not(LdapConnection.this.session.isNull(contactAttributeName));
            } else if (!"imapUid".equals(contactAttributeName)) {
                condition = this.mode == 130 || this.mode == 129 ? LdapConnection.this.session.contains(contactAttributeName, this.value) : LdapConnection.this.session.startsWith(contactAttributeName, this.value);
            }
            return condition;
        }

        @Override
        public boolean isMatch(Map<String, String> person) {
            if (this.canIgnore) {
                return true;
            }
            String personAttributeValue = person.get(this.attributeName);
            if (personAttributeValue == null) {
                return false;
            }
            if (this.value == null) {
                return true;
            }
            if (this.operator == 163 && personAttributeValue.equalsIgnoreCase(this.value)) {
                return true;
            }
            return this.operator == 164 && personAttributeValue.toLowerCase().contains(this.value.toLowerCase());
        }

        @Override
        public Map<String, ExchangeSession.Contact> findInGAL(ExchangeSession session, Set<String> returningAttributes, int sizeLimit) throws IOException {
            if (this.canIgnore) {
                return null;
            }
            String contactAttributeName = LdapConnection.getContactAttributeName(this.attributeName);
            if (contactAttributeName != null) {
                Map<String, ExchangeSession.Contact> galPersons = session.galFind(session.startsWith(contactAttributeName, STAR.equals(this.value) ? "A" : this.value), LdapConnection.this.convertLdapToContactReturningAttributes(returningAttributes), sizeLimit);
                if (this.operator == 163) {
                    HashMap<String, ExchangeSession.Contact> results = new HashMap<String, ExchangeSession.Contact>();
                    for (ExchangeSession.Contact person : galPersons.values()) {
                        if (!this.isMatch(person)) continue;
                        results.put((String)person.get("uid"), person);
                    }
                    return results;
                }
                return galPersons;
            }
            return null;
        }

        @Override
        public void add(LdapFilter filter) {
            DavGatewayTray.error(new BundleMessage("LOG_LDAP_UNSUPPORTED_FILTER", "nested simple filters"));
        }
    }

    class CompoundFilter
    implements LdapFilter {
        final Set<LdapFilter> criteria = new HashSet<LdapFilter>();
        final int type;

        CompoundFilter(int filterType) {
            this.type = filterType;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.type == 161) {
                buffer.append("(|");
            } else if (this.type == 160) {
                buffer.append("(&");
            } else {
                buffer.append("(!");
            }
            for (LdapFilter child : this.criteria) {
                buffer.append(child.toString());
            }
            buffer.append(')');
            return buffer.toString();
        }

        @Override
        public void add(LdapFilter filter) {
            this.criteria.add(filter);
        }

        @Override
        public boolean isFullSearch() {
            for (LdapFilter child : this.criteria) {
                if (child.isFullSearch()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ExchangeSession.Condition getContactSearchFilter() {
            ExchangeSession.MultiCondition condition = this.type == 161 ? LdapConnection.this.session.or(new ExchangeSession.Condition[0]) : LdapConnection.this.session.and(new ExchangeSession.Condition[0]);
            for (LdapFilter child : this.criteria) {
                condition.add(child.getContactSearchFilter());
            }
            return condition;
        }

        @Override
        public boolean isMatch(Map<String, String> person) {
            if (this.type == 161) {
                for (LdapFilter child : this.criteria) {
                    if (child.isFullSearch() || !child.isMatch(person)) continue;
                    return true;
                }
                return false;
            }
            if (this.type == 160) {
                for (LdapFilter child : this.criteria) {
                    if (child.isFullSearch() || child.isMatch(person)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public Map<String, ExchangeSession.Contact> findInGAL(ExchangeSession session, Set<String> returningAttributes, int sizeLimit) throws IOException {
            Map<String, ExchangeSession.Contact> persons = null;
            for (LdapFilter child : this.criteria) {
                Map<String, ExchangeSession.Contact> childFind;
                int currentSizeLimit = sizeLimit;
                if (persons != null) {
                    currentSizeLimit -= persons.size();
                }
                if ((childFind = child.findInGAL(session, returningAttributes, currentSizeLimit)) == null) continue;
                if (persons == null) {
                    persons = childFind;
                    continue;
                }
                if (this.type == 161) {
                    persons.putAll(childFind);
                    continue;
                }
                if (this.type != 160) continue;
                for (ExchangeSession.Contact result : childFind.values()) {
                    if (!this.isMatch(result)) continue;
                    persons.put((String)result.get("uid"), result);
                }
            }
            if (persons == null && !this.isFullSearch()) {
                return new HashMap<String, ExchangeSession.Contact>();
            }
            return persons;
        }
    }

    static interface LdapFilter {
        public ExchangeSession.Condition getContactSearchFilter();

        public Map<String, ExchangeSession.Contact> findInGAL(ExchangeSession var1, Set<String> var2, int var3) throws IOException;

        public void add(LdapFilter var1);

        public boolean isFullSearch();

        public boolean isMatch(Map<String, String> var1);
    }
}

