/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.Settings;
import davmail.ui.CredentialPromptDialog;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosHelper {
    protected static final Logger LOGGER = Logger.getLogger(KerberosHelper.class);
    protected static final Object LOCK = new Object();
    protected static final KerberosCallbackHandler KERBEROS_CALLBACK_HANDLER;
    private static LoginContext clientLoginContext;

    private KerberosHelper() {
    }

    public static void setClientPrincipal(String principal) {
        KerberosHelper.KERBEROS_CALLBACK_HANDLER.principal = principal;
    }

    public static void setClientPassword(String password) {
        KerberosHelper.KERBEROS_CALLBACK_HANDLER.password = password;
    }

    public static byte[] initSecurityContext(String protocol, String host, byte[] token) throws GSSException, LoginException {
        return KerberosHelper.initSecurityContext(protocol, host, null, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] initSecurityContext(String protocol, String host, GSSCredential delegatedCredentials, byte[] token) throws GSSException, LoginException {
        LOGGER.debug((Object)("KerberosHelper.initSecurityContext " + protocol + '@' + host + ' ' + token.length + " bytes token"));
        Object object = LOCK;
        synchronized (object) {
            Object localLoginContext;
            KerberosTicket kerberosTicket;
            if (clientLoginContext != null) {
                for (KerberosTicket ticket : clientLoginContext.getSubject().getPrivateCredentials(KerberosTicket.class)) {
                    kerberosTicket = ticket;
                    if (!kerberosTicket.getServer().getName().startsWith("krbtgt") || kerberosTicket.isCurrent()) continue;
                    LOGGER.debug((Object)"KerberosHelper.clientLogin cached TGT expired, try to relogin");
                    clientLoginContext = null;
                }
            }
            if (clientLoginContext == null) {
                localLoginContext = new LoginContext("spnego-client", KERBEROS_CALLBACK_HANDLER);
                ((LoginContext)localLoginContext).login();
                clientLoginContext = localLoginContext;
            }
            localLoginContext = clientLoginContext.getSubject().getPrivateCredentials(KerberosTicket.class).iterator();
            while (localLoginContext.hasNext()) {
                KerberosTicket ticket;
                kerberosTicket = ticket = localLoginContext.next();
                LOGGER.debug((Object)("KerberosHelper.clientLogin ticket for " + kerberosTicket.getServer().getName() + " expires at " + kerberosTicket.getEndTime()));
                if (kerberosTicket.getEndTime().getTime() >= System.currentTimeMillis() + 10000L) continue;
                if (kerberosTicket.isRenewable()) {
                    try {
                        kerberosTicket.refresh();
                    }
                    catch (RefreshFailedException e) {
                        LOGGER.debug((Object)("KerberosHelper.clientLogin failed to renew ticket " + kerberosTicket.toString()));
                    }
                    continue;
                }
                LOGGER.debug((Object)"KerberosHelper.clientLogin ticket is not renewable");
            }
            Object result = KerberosHelper.internalInitSecContext(protocol, host, delegatedCredentials, token);
            if (result instanceof GSSException) {
                LOGGER.info((Object)("KerberosHelper.initSecurityContext exception code " + ((GSSException)result).getMajor() + " minor code " + ((GSSException)result).getMinor() + " message " + ((Throwable)result).getMessage()));
                throw (GSSException)result;
            }
            LOGGER.debug((Object)("KerberosHelper.initSecurityContext return " + ((byte[])result).length + " bytes token"));
            return (byte[])result;
        }
    }

    protected static Object internalInitSecContext(final String protocol, final String host, final GSSCredential delegatedCredentials, final byte[] token) {
        return Subject.doAs(clientLoginContext.getSubject(), new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object result;
                GSSContext context = null;
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSName serverName = manager.createName(protocol + '@' + host, GSSName.NT_HOSTBASED_SERVICE);
                    Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                    context = manager.createContext(serverName, krb5Oid, delegatedCredentials, 0);
                    context.requestCredDeleg(true);
                    result = context.initSecContext(token, 0, token.length);
                }
                catch (GSSException e) {
                    result = e;
                }
                finally {
                    if (context != null) {
                        try {
                            context.dispose();
                        }
                        catch (GSSException e) {
                            LOGGER.debug((Object)("KerberosHelper.internalInitSecContext " + e + ' ' + e.getMessage()));
                        }
                    }
                }
                return result;
            }
        });
    }

    public static LoginContext serverLogin(final String serverPrincipal, final String serverPassword) throws LoginException {
        LoginContext serverLoginContext = new LoginContext("spnego-server", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(serverPrincipal);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passCallback = (PasswordCallback)callback;
                        passCallback.setPassword(serverPassword.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        });
        serverLoginContext.login();
        return serverLoginContext;
    }

    public static SecurityContext acceptSecurityContext(LoginContext serverLoginContext, final byte[] token) throws GSSException {
        Object result = Subject.doAs(serverLoginContext.getSubject(), new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object innerResult;
                SecurityContext securityContext = new SecurityContext();
                GSSContext context = null;
                try {
                    GSSManager manager = GSSManager.getInstance();
                    Oid krb5oid = new Oid("1.2.840.113554.1.2.2");
                    GSSCredential serverCreds = manager.createCredential(null, 0, krb5oid, 2);
                    context = manager.createContext(serverCreds);
                    securityContext.token = context.acceptSecContext(token, 0, token.length);
                    if (context.isEstablished()) {
                        securityContext.principal = context.getSrcName().toString();
                        LOGGER.debug((Object)("Authenticated user: " + securityContext.principal));
                        if (!context.getCredDelegState()) {
                            LOGGER.debug((Object)"Credentials can not be delegated");
                        } else {
                            securityContext.clientCredential = context.getDelegCred();
                        }
                    }
                    innerResult = securityContext;
                }
                catch (GSSException e) {
                    innerResult = e;
                }
                finally {
                    if (context != null) {
                        try {
                            context.dispose();
                        }
                        catch (GSSException e) {
                            LOGGER.debug((Object)("KerberosHelper.acceptSecurityContext " + e + ' ' + e.getMessage()));
                        }
                    }
                }
                return innerResult;
            }
        });
        if (result instanceof GSSException) {
            LOGGER.info((Object)("KerberosHelper.acceptSecurityContext exception code " + ((GSSException)result).getMajor() + " minor code " + ((GSSException)result).getMinor() + " message " + ((Throwable)result).getMessage()));
            throw (GSSException)result;
        }
        return (SecurityContext)result;
    }

    static {
        Security.setProperty("login.configuration.provider", "davmail.http.KerberosLoginConfiguration");
        KERBEROS_CALLBACK_HANDLER = new KerberosCallbackHandler();
    }

    public static class SecurityContext {
        public byte[] token;
        public String principal;
        public GSSCredential clientCredential;
    }

    protected static class KerberosCallbackHandler
    implements CallbackHandler {
        String principal;
        String password;

        protected KerberosCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                BufferedReader inReader;
                if (callback instanceof NameCallback) {
                    if (this.principal == null) {
                        if (Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless()) {
                            System.out.print(((NameCallback)callback).getPrompt());
                            inReader = new BufferedReader(new InputStreamReader(System.in));
                            this.principal = inReader.readLine();
                        } else {
                            CredentialPromptDialog credentialPromptDialog = new CredentialPromptDialog(((NameCallback)callback).getPrompt());
                            this.principal = credentialPromptDialog.getPrincipal();
                            this.password = String.valueOf(credentialPromptDialog.getPassword());
                        }
                    }
                    if (this.principal == null) {
                        throw new IOException("KerberosCallbackHandler: failed to retrieve principal");
                    }
                    ((NameCallback)callback).setName(this.principal);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (this.password == null && (Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless())) {
                        System.out.print(((PasswordCallback)callback).getPrompt());
                        inReader = new BufferedReader(new InputStreamReader(System.in));
                        this.password = inReader.readLine();
                    }
                    if (this.password == null) {
                        throw new IOException("KerberosCallbackHandler: failed to retrieve password");
                    }
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

