/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.exchange.dav.ExchangeDavMethod;
import davmail.exchange.dav.PropertyValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExchangePropPatchMethod
extends ExchangeDavMethod {
    protected static final Logger LOGGER = Logger.getLogger(ExchangePropPatchMethod.class);
    static final String TYPE_NAMESPACE = "urn:schemas-microsoft-com:datatypes";
    final Set<PropertyValue> propertyValues;

    public ExchangePropPatchMethod(String path, Set<PropertyValue> propertyValues) {
        super(path);
        this.propertyValues = propertyValues;
    }

    @Override
    protected byte[] generateRequestContent() {
        try {
            int currentChar = 101;
            HashMap<String, Integer> nameSpaceMap = new HashMap<String, Integer>();
            HashSet<PropertyValue> setPropertyValues = new HashSet<PropertyValue>();
            HashSet<PropertyValue> deletePropertyValues = new HashSet<PropertyValue>();
            for (PropertyValue propertyValue : this.propertyValues) {
                String namespaceUri;
                if (!nameSpaceMap.containsKey(TYPE_NAMESPACE) && propertyValue.getTypeString() != null) {
                    nameSpaceMap.put(TYPE_NAMESPACE, currentChar++);
                }
                if (!nameSpaceMap.containsKey(namespaceUri = propertyValue.getNamespaceUri())) {
                    nameSpaceMap.put(namespaceUri, currentChar++);
                }
                if (propertyValue.getXmlEncodedValue() == null) {
                    deletePropertyValues.add(propertyValue);
                    continue;
                }
                setPropertyValues.add(propertyValue);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            writer.write("<D:propertyupdate xmlns:D=\"DAV:\"");
            for (Map.Entry mapEntry : nameSpaceMap.entrySet()) {
                writer.write(" xmlns:");
                writer.write((char)((Integer)mapEntry.getValue()).intValue());
                writer.write("=\"");
                writer.write((String)mapEntry.getKey());
                writer.write("\"");
            }
            writer.write(">");
            if (!setPropertyValues.isEmpty()) {
                writer.write("<D:set><D:prop>");
                for (PropertyValue propertyValue : setPropertyValues) {
                    String typeString = propertyValue.getTypeString();
                    char nameSpaceChar = (char)((Integer)nameSpaceMap.get(propertyValue.getNamespaceUri())).intValue();
                    writer.write(60);
                    writer.write(nameSpaceChar);
                    writer.write(58);
                    writer.write(propertyValue.getName());
                    if (typeString != null) {
                        writer.write(32);
                        writer.write((Integer)nameSpaceMap.get(TYPE_NAMESPACE));
                        writer.write(":dt=\"");
                        writer.write(typeString);
                        writer.write("\"");
                    }
                    writer.write(62);
                    writer.write(propertyValue.getXmlEncodedValue());
                    writer.write("</");
                    writer.write(nameSpaceChar);
                    writer.write(58);
                    writer.write(propertyValue.getName());
                    writer.write(62);
                }
                writer.write("</D:prop></D:set>");
            }
            if (!deletePropertyValues.isEmpty()) {
                writer.write("<D:remove><D:prop>");
                for (PropertyValue propertyValue : deletePropertyValues) {
                    char nameSpaceChar = (char)((Integer)nameSpaceMap.get(propertyValue.getNamespaceUri())).intValue();
                    writer.write(60);
                    writer.write(nameSpaceChar);
                    writer.write(58);
                    writer.write(propertyValue.getName());
                    writer.write("/>");
                }
                writer.write("</D:prop></D:remove>");
            }
            writer.write("</D:propertyupdate>");
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "PROPPATCH";
    }
}

