/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.exchange.XMLStreamUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.log4j.Logger;

public abstract class ExchangeDavMethod
extends PostMethod {
    protected static final Logger LOGGER = Logger.getLogger(ExchangeDavMethod.class);
    List<MultiStatusResponse> responses;

    public ExchangeDavMethod(String path) {
        super(path);
        this.setRequestEntity(new RequestEntity(){
            byte[] content;

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream outputStream) throws IOException {
                if (this.content == null) {
                    this.content = ExchangeDavMethod.this.generateRequestContent();
                }
                outputStream.write(this.content);
            }

            public long getContentLength() {
                if (this.content == null) {
                    this.content = ExchangeDavMethod.this.generateRequestContent();
                }
                return this.content.length;
            }

            public String getContentType() {
                return "text/xml;charset=UTF-8";
            }
        });
    }

    protected abstract byte[] generateRequestContent();

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        Header contentTypeHeader = this.getResponseHeader("Content-Type");
        if (contentTypeHeader != null && "text/xml".equals(contentTypeHeader.getValue())) {
            this.responses = new ArrayList<MultiStatusResponse>();
            try {
                XMLStreamReader reader = XMLStreamUtil.createXMLStreamReader(new FilterInputStream(this.getResponseBodyAsStream()){
                    final byte[] lastbytes;
                    {
                        this.lastbytes = new byte[3];
                    }

                    @Override
                    public int read(byte[] bytes, int off, int len) throws IOException {
                        int count = this.in.read(bytes, off, len);
                        for (int i = 0; i < count; ++i) {
                            byte currentByte = bytes[off + i];
                            if (this.lastbytes[0] == 60 && currentByte >= 48 && currentByte <= 57) {
                                bytes[off + i] = (byte)(currentByte + 49);
                            }
                            this.lastbytes[0] = this.lastbytes[1];
                            this.lastbytes[1] = this.lastbytes[2];
                            this.lastbytes[2] = currentByte;
                        }
                        return count;
                    }
                });
                while (reader.hasNext()) {
                    reader.next();
                    if (!XMLStreamUtil.isStartTag(reader, "response")) continue;
                    this.handleResponse(reader);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error while parsing soap response: " + e), (Throwable)e);
            }
            catch (XMLStreamException e) {
                LOGGER.error((Object)("Error while parsing soap response: " + e), (Throwable)e);
            }
        }
    }

    protected void handleResponse(XMLStreamReader reader) throws XMLStreamException {
        MultiStatusResponse multiStatusResponse = null;
        String href = null;
        String responseStatus = "";
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "response")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("href".equals(tagLocalName)) {
                href = reader.getElementText();
                continue;
            }
            if ("status".equals(tagLocalName)) {
                responseStatus = reader.getElementText();
                continue;
            }
            if (!"propstat".equals(tagLocalName)) continue;
            if (multiStatusResponse == null) {
                multiStatusResponse = new MultiStatusResponse(href, responseStatus);
            }
            this.handlePropstat(reader, multiStatusResponse);
        }
        if (multiStatusResponse != null) {
            this.responses.add(multiStatusResponse);
        }
    }

    protected void handlePropstat(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        int propstatStatus = 0;
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "propstat")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("status".equals(tagLocalName)) {
                if ("HTTP/1.1 200 OK".equals(reader.getElementText())) {
                    propstatStatus = 200;
                    continue;
                }
                propstatStatus = 0;
                continue;
            }
            if (!"prop".equals(tagLocalName) || propstatStatus != 200) continue;
            this.handleProperty(reader, multiStatusResponse);
        }
    }

    protected void handleProperty(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "prop")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            Namespace namespace = Namespace.getNamespace((String)reader.getNamespaceURI());
            String tagLocalName = reader.getLocalName();
            if (reader.getAttributeCount() > 0 && "mv.string".equals(reader.getAttributeValue(0))) {
                this.handleMultiValuedProperty(reader, multiStatusResponse);
                continue;
            }
            String tagContent = this.getTagContent(reader);
            if (tagContent == null) continue;
            multiStatusResponse.add((DavProperty)new DefaultDavProperty(tagLocalName, (Object)tagContent, namespace));
        }
    }

    protected void handleMultiValuedProperty(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        String tagLocalName = reader.getLocalName();
        Namespace namespace = Namespace.getNamespace((String)reader.getNamespaceURI());
        ArrayList<String> values = new ArrayList<String>();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, tagLocalName)) {
            String tagContent;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || (tagContent = this.getTagContent(reader)) == null) continue;
            values.add(tagContent);
        }
        multiStatusResponse.add((DavProperty)new DefaultDavProperty(tagLocalName, values, namespace));
    }

    protected String getTagContent(XMLStreamReader reader) throws XMLStreamException {
        String value = null;
        String tagLocalName = reader.getLocalName();
        while (reader.hasNext() && (reader.getEventType() != 2 || !tagLocalName.equals(reader.getLocalName()))) {
            reader.next();
            if (reader.getEventType() != 4) continue;
            value = reader.getText();
        }
        if (!reader.hasNext()) {
            throw new XMLStreamException("End element for " + tagLocalName + " not found");
        }
        return value;
    }

    public MultiStatusResponse[] getResponses() throws HttpException {
        if (this.responses == null) {
            throw new HttpException(this.getStatusLine().toString());
        }
        return this.responses.toArray(new MultiStatusResponse[this.responses.size()]);
    }

    public MultiStatusResponse getResponse() throws HttpException {
        if (this.responses == null || this.responses.size() != 1) {
            throw new HttpException(this.getStatusLine().toString());
        }
        return this.responses.get(0);
    }

    public int getResponseStatusCode() throws HttpException {
        String responseDescription = this.getResponse().getResponseDescription();
        if ("HTTP/1.1 201 Created".equals(responseDescription)) {
            return 201;
        }
        return 200;
    }
}

