/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.Settings;
import davmail.exchange.ExchangeSession;
import davmail.exchange.ICSBufferedReader;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class VCalendar
extends VObject {
    protected static final Logger LOGGER = Logger.getLogger(VCalendar.class);
    protected VObject firstVevent;
    protected VObject vTimezone;
    protected String email;

    public VCalendar(BufferedReader reader, String email, VObject vTimezone) throws IOException {
        super(reader);
        if (!"VCALENDAR".equals(this.type)) {
            throw new IOException("Invalid type: " + this.type);
        }
        this.email = email;
        if (this.vTimezone == null && vTimezone != null) {
            this.setTimezone(vTimezone);
        }
    }

    public VCalendar(String vCalendarBody, String email, VObject vTimezone) throws IOException {
        this(new ICSBufferedReader(new StringReader(vCalendarBody)), email, vTimezone);
    }

    public VCalendar(byte[] vCalendarContent, String email, VObject vTimezone) throws IOException {
        this(new ICSBufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(vCalendarContent), "UTF-8")), email, vTimezone);
    }

    public VCalendar() {
        this.type = "VCALENDAR";
    }

    public void setTimezone(VObject vTimezone) {
        if (this.vObjects == null) {
            this.addVObject(vTimezone);
        } else {
            this.vObjects.add(0, vTimezone);
        }
        this.vTimezone = vTimezone;
    }

    @Override
    public void addVObject(VObject vObject) {
        super.addVObject(vObject);
        if (this.firstVevent == null && ("VEVENT".equals(vObject.type) || "VTODO".equals(vObject.type))) {
            this.firstVevent = vObject;
        }
        if ("VTIMEZONE".equals(vObject.type)) {
            this.vTimezone = vObject;
        }
    }

    protected boolean isAllDay(VObject vObject) {
        VProperty dtstart = vObject.getProperty("DTSTART");
        return dtstart != null && dtstart.hasParam("VALUE", "DATE");
    }

    protected boolean isCdoAllDay(VObject vObject) {
        return "TRUE".equals(vObject.getPropertyValue("X-MICROSOFT-CDO-ALLDAYEVENT"));
    }

    public boolean isCdoAllDay() {
        return this.firstVevent != null && this.isCdoAllDay(this.firstVevent);
    }

    public String getEmailValue(VProperty property) {
        if (property == null) {
            return null;
        }
        String propertyValue = property.getValue();
        if (propertyValue != null && (propertyValue.startsWith("MAILTO:") || propertyValue.startsWith("mailto:"))) {
            return propertyValue.substring(7);
        }
        return propertyValue;
    }

    protected String getMethod() {
        return this.getPropertyValue("METHOD");
    }

    protected void fixVCalendar(boolean fromServer) {
        VObject vObject;
        if (fromServer) {
            this.setPropertyValue("X-CALENDARSERVER-ACCESS", this.getCalendarServerAccess());
        }
        String calendarServerAccess = this.getPropertyValue("X-CALENDARSERVER-ACCESS");
        String now = ExchangeSession.getZuluDateFormat().format(new Date());
        if (!fromServer && this.getPropertyValue("METHOD") == null) {
            this.setPropertyValue("METHOD", "PUBLISH");
        }
        String tzid = null;
        if (fromServer && (vObject = this.vTimezone) != null) {
            String currentTzid = vObject.getPropertyValue("TZID");
            if (currentTzid != null && currentTzid.endsWith("\n")) {
                currentTzid = currentTzid.substring(0, currentTzid.length() - 1);
                vObject.setPropertyValue("TZID", currentTzid);
            }
            if (currentTzid != null && currentTzid.indexOf(32) >= 0) {
                try {
                    tzid = ResourceBundle.getBundle("timezones").getString(currentTzid);
                    vObject.setPropertyValue("TZID", tzid);
                }
                catch (MissingResourceException e) {
                    LOGGER.debug((Object)("Timezone " + currentTzid + " not found in rename table"));
                }
            }
        }
        if (!fromServer) {
            this.fixTimezone();
        }
        for (VObject vObject2 : this.vObjects) {
            if (!"VEVENT".equals(vObject2.type)) continue;
            if (calendarServerAccess != null) {
                vObject2.setPropertyValue("CLASS", this.getEventClass(calendarServerAccess));
            } else if (vObject2.getPropertyValue("X-CALENDARSERVER-ACCESS") != null) {
                vObject2.setPropertyValue("CLASS", this.getEventClass(vObject2.getPropertyValue("X-CALENDARSERVER-ACCESS")));
            }
            if (fromServer) {
                String cdoBusyStatus;
                if (vObject2.getProperty("ATTENDEE") == null) {
                    vObject2.setPropertyValue("ORGANIZER", null);
                }
                if (this.isCdoAllDay(vObject2)) {
                    this.setClientAllday(vObject2.getProperty("DTSTART"));
                    this.setClientAllday(vObject2.getProperty("DTEND"));
                    this.setClientAllday(vObject2.getProperty("RECURRENCE-ID"));
                }
                if ((cdoBusyStatus = vObject2.getPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS")) != null) {
                    vObject2.setPropertyValue("TRANSP", !"FREE".equals(cdoBusyStatus) ? "OPAQUE" : "TRANSPARENT");
                }
                vObject2.removeProperty("X-ENTOURAGE_UUID");
                this.splitExDate(vObject2);
                if ("".equals(vObject2.getPropertyValue("LOCATION"))) {
                    vObject2.removeProperty("LOCATION");
                }
                if ("".equals(vObject2.getPropertyValue("DESCRIPTION"))) {
                    vObject2.removeProperty("DESCRIPTION");
                }
                if ("".equals(vObject2.getPropertyValue("CLASS"))) {
                    vObject2.removeProperty("CLASS");
                }
                if (tzid != null) {
                    VProperty reccurrenceId;
                    VProperty dtEnd;
                    VProperty dtStart = vObject2.getProperty("DTSTART");
                    if (dtStart != null && dtStart.getParam("TZID") != null) {
                        dtStart.setParam("TZID", tzid);
                    }
                    if ((dtEnd = vObject2.getProperty("DTEND")) != null && dtEnd.getParam("TZID") != null) {
                        dtEnd.setParam("TZID", tzid);
                    }
                    if ((reccurrenceId = vObject2.getProperty("RECURRENCE-ID")) != null && reccurrenceId.getParam("TZID") != null) {
                        reccurrenceId.setParam("TZID", tzid);
                    }
                }
                if (vObject2.getProperty("ATTACH") != null) {
                    ArrayList<String> toRemoveValues = null;
                    List<String> values = vObject2.getProperty("ATTACH").getValues();
                    for (String value : values) {
                        if (!value.contains("CID:")) continue;
                        if (toRemoveValues == null) {
                            toRemoveValues = new ArrayList<String>();
                        }
                        toRemoveValues.add(value);
                    }
                    if (toRemoveValues != null) {
                        values.removeAll(toRemoveValues);
                        if (values.size() == 0) {
                            vObject2.removeProperty("ATTACH");
                        }
                    }
                }
            } else {
                String organizer = this.getEmailValue(vObject2.getProperty("ORGANIZER"));
                if (organizer == null) {
                    vObject2.setPropertyValue("ORGANIZER", "MAILTO:" + this.email);
                } else if (!this.email.equalsIgnoreCase(organizer) && vObject2.getProperty("X-MICROSOFT-CDO-REPLYTIME") == null) {
                    vObject2.setPropertyValue("X-MICROSOFT-CDO-REPLYTIME", now);
                }
                vObject2.setPropertyValue("X-MICROSOFT-CDO-ALLDAYEVENT", this.isAllDay(vObject2) ? "TRUE" : "FALSE");
                if (vObject2.getPropertyValue("TRANSP") != null) {
                    vObject2.setPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS", !"TRANSPARENT".equals(vObject2.getPropertyValue("TRANSP")) ? "BUSY" : "FREE");
                }
                if (this.isAllDay(vObject2)) {
                    this.setServerAllday(vObject2.getProperty("DTSTART"));
                    this.setServerAllday(vObject2.getProperty("DTEND"));
                } else {
                    this.fixTzid(vObject2.getProperty("DTSTART"));
                    this.fixTzid(vObject2.getProperty("DTEND"));
                }
            }
            this.fixAttendees(vObject2, fromServer);
            this.fixAlarm(vObject2, fromServer);
        }
    }

    private void fixTimezone() {
        if (this.vTimezone != null && this.vTimezone.vObjects != null && this.vTimezone.vObjects.size() > 2) {
            VObject standard = null;
            VObject daylight = null;
            for (VObject vObject : this.vTimezone.vObjects) {
                if ("STANDARD".equals(vObject.type) && (standard == null || vObject.getPropertyValue("DTSTART").compareTo(standard.getPropertyValue("DTSTART")) > 0)) {
                    standard = vObject;
                }
                if (!"DAYLIGHT".equals(vObject.type) || daylight != null && vObject.getPropertyValue("DTSTART").compareTo(daylight.getPropertyValue("DTSTART")) <= 0) continue;
                daylight = vObject;
            }
            this.vTimezone.vObjects.clear();
            this.vTimezone.vObjects.add(standard);
            this.vTimezone.vObjects.add(daylight);
        }
        if (this.vTimezone != null && this.vTimezone.vObjects != null) {
            for (VObject vObject : this.vTimezone.vObjects) {
                VProperty rrule = vObject.getProperty("RRULE");
                if (rrule != null && rrule.getValues().size() == 3 && "BYDAY=-2SU".equals(rrule.getValues().get(1))) {
                    rrule.getValues().set(1, "BYDAY=4SU");
                }
                if (rrule == null || rrule.getValues().size() != 4 || !"BYDAY=FR".equals(rrule.getValues().get(1)) || !"BYMONTHDAY=23,24,25,26,27,28,29".equals(rrule.getValues().get(2))) continue;
                rrule.getValues().set(1, "BYDAY=-1FR");
                rrule.getValues().remove(2);
            }
        }
    }

    private void fixTzid(VProperty property) {
        if (property != null && !property.hasParam("TZID")) {
            property.addParam("TZID", this.vTimezone.getPropertyValue("TZID"));
        }
    }

    protected void splitExDate(VObject vObject) {
        List<VProperty> exDateProperties = vObject.getProperties("EXDATE");
        if (exDateProperties != null) {
            for (VProperty property : exDateProperties) {
                String value = property.getValue();
                if (value.indexOf(44) < 0) continue;
                vObject.removeProperty(property);
                for (String singleValue : value.split(",")) {
                    VProperty singleProperty = new VProperty("EXDATE", singleValue);
                    singleProperty.setParams(property.getParams());
                    vObject.addProperty(singleProperty);
                }
            }
        }
    }

    protected void setServerAllday(VProperty property) {
        if (this.vTimezone != null) {
            if (!property.hasParam("TZID")) {
                property.addParam("TZID", this.vTimezone.getPropertyValue("TZID"));
            }
            property.removeParam("VALUE");
            String value = property.getValue();
            if (value.length() != 8) {
                LOGGER.warn((Object)("Invalid date value in allday event: " + value));
            }
            property.setValue(property.getValue() + "T000000");
        }
    }

    protected void setClientAllday(VProperty property) {
        if (property != null) {
            if (!property.hasParam("VALUE")) {
                property.addParam("VALUE", "DATE");
            }
            property.removeParam("TZID");
            String value = property.getValue();
            if (value.length() != 8) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
                    calendar.setTime(dateParser.parse(value));
                    calendar.add(11, 12);
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
                    value = dateFormatter.format(calendar.getTime());
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Invalid date value in allday event: " + value));
                }
            }
            property.setValue(value);
        }
    }

    protected void fixAlarm(VObject vObject, boolean fromServer) {
        block5: {
            block6: {
                if (vObject.vObjects == null) break block5;
                if (!Settings.getBooleanProperty("davmail.caldavDisableReminders", false)) break block6;
                ArrayList<VObject> vAlarms = null;
                for (VObject vAlarm : vObject.vObjects) {
                    if (!"VALARM".equals(vAlarm.type)) continue;
                    if (vAlarms == null) {
                        vAlarms = new ArrayList<VObject>();
                    }
                    vAlarms.add(vAlarm);
                }
                if (vAlarms == null) break block5;
                for (VObject vAlarm : vAlarms) {
                    vObject.vObjects.remove(vAlarm);
                }
                break block5;
            }
            for (VObject vAlarm : vObject.vObjects) {
                if (!"VALARM".equals(vAlarm.type)) continue;
                String action = vAlarm.getPropertyValue("ACTION");
                if (fromServer && "DISPLAY".equals(action) && Settings.getProperty("davmail.caldavAlarmSound") != null) {
                    vAlarm.setPropertyValue("ACTION", "AUDIO");
                    if (vAlarm.getPropertyValue("ATTACH") != null) continue;
                    VProperty vProperty = new VProperty("ATTACH", Settings.getProperty("davmail.caldavAlarmSound"));
                    vProperty.addParam("VALUE", "URI");
                    vAlarm.addProperty(vProperty);
                    continue;
                }
                if (fromServer || !"AUDIO".equals(action)) continue;
                vAlarm.setPropertyValue("ACTION", "DISPLAY");
            }
        }
    }

    protected String replaceIcal4Principal(String value) {
        if (value.contains("/principals/__uuids__/")) {
            return value.replaceAll("/principals/__uuids__/([^/]*)__AT__([^/]*)/", "mailto:$1@$2");
        }
        return value;
    }

    private void fixAttendees(VObject vObject, boolean fromServer) {
        if (vObject.properties != null) {
            for (VProperty property : vObject.properties) {
                if (!"ATTENDEE".equalsIgnoreCase(property.getKey())) continue;
                if (fromServer) {
                    if (!this.isCurrentUser(property) || !property.hasParam("RSVP", "TRUE") || "NEEDS-ACTION".equals(property.getParamValue("PARTSTAT"))) continue;
                    property.removeParam("RSVP");
                    continue;
                }
                property.setValue(this.replaceIcal4Principal(property.getValue()));
            }
        }
    }

    private boolean isCurrentUser(VProperty property) {
        return property.getValue().equalsIgnoreCase("mailto:" + this.email);
    }

    public VObject getVTimezone() {
        return this.vTimezone;
    }

    protected String getEventClass(String calendarServerAccess) {
        if ("PRIVATE".equalsIgnoreCase(calendarServerAccess)) {
            return "CONFIDENTIAL";
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(calendarServerAccess) || "RESTRICTED".equalsIgnoreCase(calendarServerAccess)) {
            return "PRIVATE";
        }
        return null;
    }

    protected String getCalendarServerAccess() {
        String eventClass = this.getFirstVeventPropertyValue("CLASS");
        if ("PRIVATE".equalsIgnoreCase(eventClass)) {
            return "CONFIDENTIAL";
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(eventClass)) {
            return "PRIVATE";
        }
        return null;
    }

    public String getFirstVeventPropertyValue(String name) {
        if (this.firstVevent == null) {
            return null;
        }
        return this.firstVevent.getPropertyValue(name);
    }

    protected VProperty getFirstVeventProperty(String name) {
        if (this.firstVevent == null) {
            return null;
        }
        return this.firstVevent.getProperty(name);
    }

    public List<VProperty> getFirstVeventProperties(String name) {
        if (this.firstVevent == null) {
            return null;
        }
        return this.firstVevent.getProperties(name);
    }

    public void removeVAlarm() {
        if (this.vObjects != null) {
            for (VObject vObject : this.vObjects) {
                if (!"VEVENT".equals(vObject.type) || vObject.vObjects == null) continue;
                vObject.vObjects = null;
            }
        }
    }

    public boolean hasVAlarm() {
        if (this.vObjects != null) {
            for (VObject vObject : this.vObjects) {
                if (!"VEVENT".equals(vObject.type) || vObject.vObjects == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMeeting() {
        return this.getFirstVeventProperty("ATTENDEE") != null;
    }

    public boolean isMeetingOrganizer() {
        return this.email.equalsIgnoreCase(this.getEmailValue(this.getFirstVeventProperty("ORGANIZER")));
    }

    public void setFirstVeventPropertyValue(String propertyName, String propertyValue) {
        this.firstVevent.setPropertyValue(propertyName, propertyValue);
    }

    public void addFirstVeventProperty(VProperty vProperty) {
        this.firstVevent.addProperty(vProperty);
    }

    public boolean isTodo() {
        return "VTODO".equals(this.firstVevent.type);
    }

    public Recipients getRecipients(boolean isNotification) {
        HashSet<String> attendees = new HashSet<String>();
        HashSet<String> optionalAttendees = new HashSet<String>();
        List<VProperty> attendeeProperties = this.getFirstVeventProperties("ATTENDEE");
        if (attendeeProperties != null) {
            for (VProperty property : attendeeProperties) {
                String attendeeEmail = this.getEmailValue(property);
                if (this.email.equalsIgnoreCase(attendeeEmail) || attendeeEmail == null || attendeeEmail.indexOf(64) < 0 || isNotification && !property.hasParam("RSVP", "TRUE") && (property.hasParam("RSVP", "FALSE") || !property.hasParam("PARTSTAT", "NEEDS-ACTION") && !property.hasParam("PARTSTAT", "ACCEPTED") && !property.hasParam("PARTSTAT", "DECLINED") && !property.hasParam("PARTSTAT", "TENTATIVE"))) continue;
                if (property.hasParam("ROLE", "OPT-PARTICIPANT")) {
                    optionalAttendees.add(attendeeEmail);
                    continue;
                }
                attendees.add(attendeeEmail);
            }
        }
        Recipients recipients = new Recipients();
        recipients.organizer = this.getEmailValue(this.getFirstVeventProperty("ORGANIZER"));
        recipients.attendees = StringUtil.join(attendees, ", ");
        recipients.optionalAttendees = StringUtil.join(optionalAttendees, ", ");
        return recipients;
    }

    protected String getAttendeeStatus() {
        String status = null;
        List<VProperty> attendeeProperties = this.getFirstVeventProperties("ATTENDEE");
        if (attendeeProperties != null) {
            for (VProperty property : attendeeProperties) {
                String attendeeEmail = this.getEmailValue(property);
                if (!this.email.equalsIgnoreCase(attendeeEmail) || !property.hasParam("PARTSTAT")) continue;
                status = property.getParamValue("PARTSTAT");
                break;
            }
        }
        return status;
    }

    public VObject getFirstVevent() {
        return this.firstVevent;
    }

    public List<VObject> getModifiedOccurrences() {
        boolean first = true;
        ArrayList<VObject> results = new ArrayList<VObject>();
        for (VObject vObject : this.vObjects) {
            if (!"VEVENT".equals(vObject.type)) continue;
            if (first) {
                first = false;
                continue;
            }
            results.add(vObject);
        }
        return results;
    }

    public static class Recipients {
        public String attendees;
        public String optionalAttendees;
        public String organizer;
    }
}

