/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.BundleMessage;
import davmail.exception.DavMailException;
import davmail.exchange.ExchangeSession;
import davmail.ui.tray.DavGatewayTray;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;

public class AbstractConnection
extends Thread {
    protected final Socket client;
    protected LineReaderInputStream in;
    protected OutputStream os;
    protected String userName;
    protected String password;
    protected State state = State.INITIAL;
    protected ExchangeSession session;

    public AbstractConnection(String name, Socket clientSocket) {
        super(name + '-' + clientSocket.getPort());
        this.client = clientSocket;
        this.setDaemon(true);
    }

    public AbstractConnection(String name, Socket clientSocket, String encoding) {
        super(name + '-' + clientSocket.getPort());
        this.client = clientSocket;
        try {
            this.in = new LineReaderInputStream(this.client.getInputStream(), encoding);
            this.os = new BufferedOutputStream(this.client.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            DavGatewayTray.error(new BundleMessage("LOG_EXCEPTION_GETTING_SOCKET_STREAMS", new Object[0]), e);
        }
    }

    public void sendClient(String message) throws IOException {
        this.sendClient(null, message);
    }

    public void sendClient(String prefix, String message) throws IOException {
        if (prefix != null) {
            this.os.write(prefix.getBytes("UTF-8"));
            DavGatewayTray.debug(new BundleMessage("LOG_SEND_CLIENT_PREFIX_MESSAGE", prefix, message));
        } else {
            DavGatewayTray.debug(new BundleMessage("LOG_SEND_CLIENT_MESSAGE", message));
        }
        this.os.write(message.getBytes("UTF-8"));
        this.os.write(13);
        this.os.write(10);
        this.os.flush();
    }

    public void sendClient(byte[] messageBytes) throws IOException {
        this.sendClient(messageBytes, 0, messageBytes.length);
    }

    public void sendClient(byte[] messageBytes, int offset, int length) throws IOException {
        this.os.write(messageBytes, offset, length);
        this.os.flush();
    }

    public String readClient() throws IOException {
        String line = this.in.readLine();
        if (line != null) {
            if (line.startsWith("PASS")) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_PASS", new Object[0]));
            } else if (line.startsWith("AUTH LOGIN ")) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_AUTH_LOGIN", new Object[0]));
            } else if (this.state == State.INITIAL && line.indexOf(32) >= 0 && line.substring(line.indexOf(32) + 1).toUpperCase().startsWith("LOGIN")) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_LOGIN", new Object[0]));
            } else if (this.state == State.PASSWORD) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_PASSWORD", new Object[0]));
            } else if (line.startsWith("Authorization:")) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_AUTHORIZATION", new Object[0]));
            } else if (line.startsWith("AUTH PLAIN")) {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_AUTH_PLAIN", new Object[0]));
            } else {
                DavGatewayTray.debug(new BundleMessage("LOG_READ_CLIENT_LINE", line));
            }
        }
        DavGatewayTray.switchIcon();
        return line;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e2) {
                DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_INPUT_STREAM", new Object[0]), e2);
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e2) {
                DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_OUTPUT_STREAM", new Object[0]), e2);
            }
        }
        try {
            this.client.close();
        }
        catch (IOException e2) {
            DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_CLOSING_CLIENT_SOCKET", new Object[0]), e2);
        }
    }

    protected static class LineReaderInputStream
    extends PushbackInputStream {
        final String encoding;

        protected LineReaderInputStream(InputStream in, String encoding) {
            super(in);
            this.encoding = encoding == null ? "ASCII" : encoding;
        }

        public String readLine() throws IOException {
            int b;
            ByteArrayOutputStream baos = null;
            while ((b = this.read()) > -1) {
                if (b == 13) {
                    int next = this.read();
                    if (next == 10) break;
                    this.unread(next);
                    break;
                }
                if (b == 10) break;
                if (baos == null) {
                    baos = new ByteArrayOutputStream();
                }
                baos.write(b);
            }
            if (baos != null) {
                return new String(baos.toByteArray(), this.encoding);
            }
            return null;
        }

        public String readContentAsString(int byteSize) throws IOException {
            return new String(this.readContent(byteSize), this.encoding);
        }

        public byte[] readContent(int byteSize) throws IOException {
            int startIndex;
            byte[] buffer = new byte[byteSize];
            int count = 0;
            for (startIndex = 0; count >= 0 && startIndex < byteSize; startIndex += count) {
                count = this.read(buffer, startIndex, byteSize - startIndex);
            }
            if (startIndex < byteSize) {
                throw new DavMailException("EXCEPTION_END_OF_STREAM", new Object[0]);
            }
            return buffer;
        }
    }

    protected static enum State {
        INITIAL,
        LOGIN,
        USER,
        PASSWORD,
        AUTHENTICATED,
        STARTMAIL,
        RECIPIENT,
        MAILDATA;

    }
}

