/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.MergeCapable;
import org.rssowl.core.persist.Reparentable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeUtils {
    private static final Set<String> EXCLUDE_PROPERTIES = new HashSet<String>(Arrays.asList("org.rssowl.pref.GoogleMarkedRead", "org.rssowl.pref.GoogleMarkedUnRead", "org.rssowl.pref.GoogleLabels"));

    public static <T, U extends T> boolean equals(T o1, U o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static final <T extends MergeCapable<T>> ComplexMergeResult<T> merge(T destination, T origin) {
        if (destination == null) {
            ComplexMergeResult<Object> mergeResult = origin == null ? ComplexMergeResult.create(null) : ComplexMergeResult.create(origin, true);
            return mergeResult;
        }
        if (origin == null) {
            return ComplexMergeResult.create(null, true);
        }
        ComplexMergeResult<T> mergeResult = ComplexMergeResult.create(destination);
        mergeResult.addAll(destination.merge(origin));
        return mergeResult;
    }

    public static final <T extends MergeCapable<T>> ComplexMergeResult<List<T>> merge(List<T> existingList, List<T> newList, IPersistable newParent) {
        return MergeUtils.merge(existingList, newList, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null ? o2 == null : o1.equals(o2)) {
                    return 0;
                }
                return -1;
            }
        }, newParent);
    }

    public static final <T extends MergeCapable<T>> ComplexMergeResult<List<T>> merge(List<T> existingList, List<T> newList, Comparator<T> comparator, IPersistable newParent) {
        if (existingList == null && (newList == null || newList.isEmpty())) {
            return ComplexMergeResult.create(null);
        }
        if (newList == null && existingList != null) {
            existingList.clear();
            return ComplexMergeResult.create(existingList, true);
        }
        ArrayList<T> newListCopy = new ArrayList<T>(newList);
        if (existingList == null) {
            ComplexMergeResult<List<T>> mergeResult = ComplexMergeResult.create(newListCopy, true);
            for (MergeCapable item : newListCopy) {
                MergeUtils.reparent(item, newParent);
                mergeResult.addUpdatedObject(item);
            }
            return mergeResult;
        }
        ComplexMergeResult<List<T>> mergeResult = ComplexMergeResult.create(existingList);
        Iterator<T> existingIt = existingList.iterator();
        while (existingIt.hasNext()) {
            MergeCapable existingItem = (MergeCapable)existingIt.next();
            boolean matchFound = false;
            Iterator newItemsIt = newListCopy.iterator();
            while (newItemsIt.hasNext()) {
                MergeCapable newItem = (MergeCapable)newItemsIt.next();
                if (comparator.compare(newItem, existingItem) != 0) continue;
                newItemsIt.remove();
                mergeResult.addAll(existingItem.merge(newItem));
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            mergeResult.setStructuralChange(true);
            mergeResult.addRemovedObject(existingItem);
            existingIt.remove();
        }
        for (MergeCapable item : newListCopy) {
            MergeUtils.reparent(item, newParent);
            existingList.add(item);
            mergeResult.addUpdatedObject(item);
            mergeResult.setStructuralChange(true);
        }
        return mergeResult;
    }

    private static void reparent(Object object, IPersistable newParent) {
        if (newParent == null) {
            return;
        }
        if (!(object instanceof Reparentable)) {
            throw new IllegalArgumentException("if newParent is non-null, the elements of the list must implement the IReparentable interface.");
        }
        ((Reparentable)object).setParent(newParent);
    }

    public static final ComplexMergeResult<?> mergeProperties(IEntity existingType, IEntity newType) {
        ComplexMergeResult<Object> mergeResult = ComplexMergeResult.create(null);
        Map<String, Serializable> existingProperties = existingType.getProperties();
        Map<String, Serializable> newProperties = newType.getProperties();
        for (Map.Entry<String, Serializable> entry : newProperties.entrySet()) {
            Serializable existingValue;
            Serializable value;
            String key = entry.getKey();
            if (EXCLUDE_PROPERTIES.contains(key) || (value = entry.getValue()).equals(existingValue = existingProperties.get(key))) continue;
            if (existingValue != null) {
                mergeResult.addRemovedObject(existingValue);
            }
            existingType.setProperty(key, value);
            mergeResult.setStructuralChange(true);
        }
        ArrayList<Map.Entry<String, Serializable>> entries = new ArrayList<Map.Entry<String, Serializable>>(existingProperties.entrySet());
        for (Map.Entry entry : entries) {
            Serializable value;
            String key = (String)entry.getKey();
            if (EXCLUDE_PROPERTIES.contains(key) || (value = newProperties.get(key)) != null) continue;
            existingType.removeProperty(key);
            mergeResult.addRemovedObject(entry.getValue());
            mergeResult.setStructuralChange(true);
        }
        return mergeResult;
    }
}

