/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.internal.persist.migration.Migration2To3;
import org.rssowl.core.internal.persist.migration.Migration2To5;
import org.rssowl.core.internal.persist.migration.Migration3To4;
import org.rssowl.core.internal.persist.migration.Migration4To5;
import org.rssowl.core.internal.persist.migration.MigrationResult;
import org.rssowl.core.internal.persist.service.ConfigurationFactory;
import org.rssowl.core.internal.persist.service.Migration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Migrations {
    private final List<Migration> fMigrations;

    public Migrations() {
        this.fMigrations = Arrays.asList(new Migration2To3(), new Migration3To4(), new Migration4To5(), new Migration2To5());
    }

    public Migrations(Migration ... migrations) {
        this.fMigrations = Arrays.asList(migrations);
    }

    public List<Migration> getMigrations() {
        return Collections.unmodifiableList(this.fMigrations);
    }

    public final Migration getMigration(int originFormat, int destinationFormat) {
        Assert.isLegal((originFormat < destinationFormat ? 1 : 0) != 0, (String)("Only forward migrations supported currently, originFormat: " + originFormat + ", destinationFormat: " + destinationFormat));
        Migration migration = this.doGetMigration(originFormat, destinationFormat);
        if (migration != null) {
            return migration;
        }
        List<Migration> chainedMigrations = this.findChainedMigrations(originFormat, destinationFormat);
        if (chainedMigrations.isEmpty()) {
            return null;
        }
        return new ChainedMigration(originFormat, destinationFormat, chainedMigrations);
    }

    private Migration doGetMigration(int originFormat, int destinationFormat) {
        for (Migration migration : this.fMigrations) {
            if (migration.getOriginFormat() != originFormat || migration.getDestinationFormat() != destinationFormat) continue;
            return migration;
        }
        return null;
    }

    private List<Migration> findChainedMigrations(int originFormat, int destinationFormat) {
        LinkedList<LinkedList<Migration>> migrationsQueues = this.createMigrationsQueues(originFormat, destinationFormat);
        LinkedList smallestQueue = Collections.emptyList();
        for (LinkedList linkedList : migrationsQueues) {
            if (!smallestQueue.isEmpty() && linkedList.size() >= smallestQueue.size()) continue;
            smallestQueue = linkedList;
        }
        return smallestQueue;
    }

    private LinkedList<LinkedList<Migration>> createMigrationsQueues(int originFormat, int destinationFormat) {
        LinkedList<LinkedList<Migration>> migrationQueues = new LinkedList<LinkedList<Migration>>();
        for (Migration migration : this.fMigrations) {
            if (migration.getOriginFormat() != originFormat) continue;
            LinkedList<Migration> migrationQueue = new LinkedList<Migration>();
            migrationQueue.add(migration);
            migrationQueues.add(migrationQueue);
        }
        return this.findMigrationQueues(migrationQueues, destinationFormat);
    }

    private LinkedList<LinkedList<Migration>> findMigrationQueues(LinkedList<LinkedList<Migration>> migrationQueues, int destinationFormat) {
        boolean changed = false;
        LinkedList<LinkedList<Migration>> migrationQueuesCopy = new LinkedList<LinkedList<Migration>>(migrationQueues);
        ListIterator it = migrationQueuesCopy.listIterator();
        while (it.hasNext()) {
            LinkedList migrationQueue = (LinkedList)it.next();
            Migration migration = (Migration)migrationQueue.getLast();
            if (migration.getDestinationFormat() == destinationFormat) continue;
            it.remove();
            for (Migration innerMigration : this.fMigrations) {
                if (migration.equals(innerMigration) || migration.getDestinationFormat() != innerMigration.getOriginFormat()) continue;
                changed = true;
                LinkedList<Migration> newMigrationQueue = new LinkedList<Migration>(migrationQueue);
                newMigrationQueue.add(innerMigration);
                it.add(newMigrationQueue);
            }
        }
        if (changed) {
            return this.findMigrationQueues(migrationQueuesCopy, destinationFormat);
        }
        return migrationQueuesCopy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChainedMigration
    implements Migration {
        private final List<Migration> fMigrations;
        private final int fDestinationFormat;
        private final int fOriginFormat;

        public ChainedMigration(int originFormat, int destinationFormat, List<Migration> migrations) {
            this.fOriginFormat = originFormat;
            this.fDestinationFormat = destinationFormat;
            this.fMigrations = migrations;
        }

        @Override
        public int getDestinationFormat() {
            return this.fDestinationFormat;
        }

        @Override
        public int getOriginFormat() {
            return this.fOriginFormat;
        }

        public List<Migration> getMigrations() {
            return Collections.unmodifiableList(this.fMigrations);
        }

        @Override
        public MigrationResult migrate(ConfigurationFactory configFactory, String dbFileName, IProgressMonitor progressMonitor) {
            boolean reindex = false;
            boolean optimize = false;
            boolean defragment = false;
            for (Migration migration : this.fMigrations) {
                MigrationResult migrationResult = migration.migrate(configFactory, dbFileName, progressMonitor);
                reindex |= migrationResult.isReindex();
                optimize |= migrationResult.isOptimizeIndex();
                defragment |= migrationResult.isDefragmentDatabase();
            }
            return new MigrationResult(reindex, optimize, defragment);
        }
    }
}

