/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Folder;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.FolderListener;
import org.rssowl.core.persist.event.MarkEvent;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.ReparentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderDAOImpl
extends AbstractEntityDAO<IFolder, FolderListener, FolderEvent>
implements IFolderDAO {
    public FolderDAOImpl() {
        super(Folder.class, false);
    }

    @Override
    protected final FolderEvent createDeleteEventTemplate(IFolder entity) {
        return this.createSaveEventTemplate(entity);
    }

    @Override
    protected final FolderEvent createSaveEventTemplate(IFolder entity) {
        return new FolderEvent(entity, null, true);
    }

    @Override
    public Collection<IFolder> loadRoots() {
        try {
            Query query = this.fDb.query();
            query.constrain((Object)this.fEntityClass);
            query.descend("fParent").constrain(null);
            List folders = this.getList(query);
            this.activateAll(folders);
            return new ArrayList<IFolder>(folders);
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public final void reparent(List<ReparentInfo<IFolderChild, IFolder>> reparentInfos) {
        Assert.isNotNull(reparentInfos, (String)"reparentInfos");
        if (reparentInfos.isEmpty()) {
            return;
        }
        this.fWriteLock.lock();
        try {
            try {
                IFolder newParent;
                ArrayList<FolderEvent> folderEvents = new ArrayList<FolderEvent>(3);
                ArrayList<MarkEvent> markEvents = new ArrayList<MarkEvent>();
                this.fillFolderChildEvents(reparentInfos, folderEvents, markEvents);
                for (FolderEvent folderEvent : folderEvents) {
                    this.fDb.set((Object)folderEvent.getOldParent());
                    newParent = folderEvent.getEntity().getParent();
                    if (newParent == null) {
                        this.fDb.set((Object)folderEvent.getEntity());
                        continue;
                    }
                    this.fDb.set((Object)newParent);
                }
                for (MarkEvent markEvent : markEvents) {
                    this.fDb.set((Object)markEvent.getOldParent());
                    newParent = markEvent.getEntity().getParent();
                    this.fDb.set((Object)newParent);
                }
                this.fDb.commit();
            }
            catch (Db4oException e) {
                throw DBHelper.rollbackAndPE(this.fDb, (Exception)((Object)e));
            }
        }
        finally {
            this.fWriteLock.unlock();
        }
        DBHelper.cleanUpAndFireEvents();
    }

    private void addFolder(IFolder parent, IFolder child, IFolderChild position, Boolean after) {
        child.setParent(parent);
        if (parent != null) {
            parent.addFolder(child, position, after);
        }
    }

    private IFolder removeChildFromFolder(IFolderChild folderChild) {
        IFolder oldParent = folderChild.getParent();
        oldParent.removeChild(folderChild);
        return oldParent;
    }

    private void addMarkToFolder(IFolder parent, IMark child, IFolderChild position, Boolean after) {
        child.setParent(parent);
        parent.addMark(child, position, after);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFolderChildEvents(List<ReparentInfo<IFolderChild, IFolder>> reparentInfos, List<FolderEvent> folderEvents, List<MarkEvent> markEvents) {
        for (ReparentInfo<IFolderChild, IFolder> reparentInfo : reparentInfos) {
            IFolderChild child = reparentInfo.getObject();
            IFolder newParent = reparentInfo.getNewParent();
            IFolder oldParent = child.getParent();
            IFolderChild newPosition = reparentInfo.getNewPosition();
            if (child instanceof IFolder) {
                IFolder folder;
                IFolder iFolder = folder = (IFolder)child;
                synchronized (iFolder) {
                    this.removeChildFromFolder(folder);
                    this.addFolder(newParent, folder, newPosition, reparentInfo.isAfter());
                    if (newPosition != null) {
                        List<IFolder> folderList = Collections.singletonList(folder);
                        newParent.reorderChildren(folderList, newPosition, (boolean)reparentInfo.isAfter());
                    }
                }
                FolderEvent eventTemplate = new FolderEvent(folder, oldParent, true);
                folderEvents.add(eventTemplate);
                DBHelper.putEventTemplate(eventTemplate);
                continue;
            }
            if (child instanceof IMark) {
                MarkEvent markEvent;
                IMark mark;
                IMark iMark = mark = (IMark)child;
                synchronized (iMark) {
                    this.removeChildFromFolder(mark);
                    this.addMarkToFolder(newParent, mark, newPosition, reparentInfo.isAfter());
                    if (newPosition != null) {
                        List<IMark> markList = Collections.singletonList(mark);
                        newParent.reorderChildren(markList, newPosition, (boolean)reparentInfo.isAfter());
                    }
                }
                if (mark instanceof IBookMark) {
                    markEvent = new BookMarkEvent((IBookMark)mark, oldParent, true);
                } else if (mark instanceof ISearchMark) {
                    markEvent = new SearchMarkEvent((ISearchMark)mark, oldParent, true);
                } else if (mark instanceof INewsBin) {
                    markEvent = new NewsBinEvent((INewsBin)mark, oldParent, true);
                } else {
                    throw new IllegalArgumentException("Unknown IMark subclass found: " + child.getClass());
                }
                DBHelper.putEventTemplate(markEvent);
                markEvents.add(markEvent);
                continue;
            }
            throw new IllegalArgumentException("Unknown IFolderChild subclass found: " + child.getClass());
        }
    }
}

