/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import java.net.URI;
import java.util.Collection;
import org.rssowl.core.internal.persist.Feed;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.dao.IFeedDAO;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.FeedListener;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeedDAOImpl
extends AbstractEntityDAO<IFeed, FeedListener, FeedEvent>
implements IFeedDAO {
    public FeedDAOImpl() {
        super(Feed.class, false);
    }

    @Override
    protected final void doSave(IFeed entity) {
        DBHelper.saveFeed(this.fDb, entity);
    }

    @Override
    protected final FeedEvent createDeleteEventTemplate(IFeed entity) {
        return this.createSaveEventTemplate(entity);
    }

    @Override
    protected final FeedEvent createSaveEventTemplate(IFeed entity) {
        return new FeedEvent(entity, true);
    }

    @Override
    public final Feed load(URI link) {
        return DBHelper.loadFeed(this.fDb, link, Integer.MAX_VALUE);
    }

    @Override
    public final Collection<IFeed> loadAll() {
        try {
            return DBHelper.loadAllFeeds(this.fDb);
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public boolean exists(URI link) {
        return DBHelper.existsFeed(this.fDb, link);
    }
}

