/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.rssowl.core.internal.persist.dao.CachingDAO;
import org.rssowl.core.internal.persist.dao.FolderDAOImpl;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.FolderListener;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.ReparentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFolderDAO
extends CachingDAO<FolderDAOImpl, IFolder, FolderListener, FolderEvent>
implements IFolderDAO {
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<IFolder, Object> fRootFolders = new ConcurrentHashMap<IFolder, Object>(4, 0.75f, 1);

    public CachingFolderDAO() {
        super(new FolderDAOImpl());
    }

    @Override
    protected void onDatabaseClosed(DatabaseEvent event) {
        super.onDatabaseClosed(event);
        this.fRootFolders.clear();
    }

    @Override
    protected void onDatabaseOpened(DatabaseEvent event) {
        super.onDatabaseOpened(event);
        this.fRootFolders.clear();
        for (IFolder folder : ((FolderDAOImpl)this.getDAO()).loadRoots()) {
            this.fRootFolders.put(folder, PRESENT);
        }
    }

    @Override
    protected FolderListener createEntityListener() {
        return new FolderListener(){

            @Override
            public void entitiesAdded(Set<FolderEvent> events) {
                for (FolderEvent folderEvent : events) {
                    IFolder folder = folderEvent.getEntity();
                    CachingFolderDAO.this.getCache().put(folder.getId(), folder);
                    if (folder.getParent() != null) continue;
                    CachingFolderDAO.this.fRootFolders.put(folder, PRESENT);
                }
            }

            @Override
            public void entitiesDeleted(Set<FolderEvent> events) {
                for (FolderEvent folderEvent : events) {
                    IFolder folder = folderEvent.getEntity();
                    CachingFolderDAO.this.getCache().remove(folder.getId(), folder);
                    if (folder.getParent() != null) continue;
                    CachingFolderDAO.this.fRootFolders.remove(folder);
                }
            }

            @Override
            public void entitiesUpdated(Set<FolderEvent> events) {
                for (FolderEvent folderEvent : events) {
                    IFolder folder;
                    if (folderEvent.getOldParent() == null || (folder = folderEvent.getEntity()).getParent() != null) continue;
                    CachingFolderDAO.this.fRootFolders.put(folder, PRESENT);
                }
            }
        };
    }

    @Override
    public Collection<IFolder> loadRoots() throws PersistenceException {
        return Collections.unmodifiableSet(this.fRootFolders.keySet());
    }

    @Override
    public void reparent(List<ReparentInfo<IFolderChild, IFolder>> reparentInfos) throws PersistenceException {
        ((FolderDAOImpl)this.getDAO()).reparent(reparentInfos);
    }
}

