/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.dao.AbstractPersistableDAO;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.dao.IEntityDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingDAO<D extends AbstractEntityDAO<T, L, E>, T extends IEntity, L extends EntityListener<E, T>, E extends ModelEvent>
implements IEntityDAO<T, L, E> {
    protected static final boolean USE_LEGACY_CACHE_ACTIVATION = true;
    private final D fDAO;
    private final ConcurrentMap<Long, T> fCache;

    public CachingDAO(D dao) {
        this.fDAO = dao;
        ((AbstractEntityDAO)this.fDAO).addEntityListener(this.createEntityListener());
        this.fCache = new ConcurrentHashMap<Long, T>(16, 0.75f, 1);
        DBManager.getDefault().addEntityStoreListener(new DatabaseListener(){

            public void databaseClosed(DatabaseEvent event) {
                CachingDAO.this.onDatabaseClosed(event);
            }

            public void databaseOpened(DatabaseEvent event) {
                CachingDAO.this.onDatabaseOpened(event);
            }
        });
    }

    protected void putAll(Set<E> events) {
        for (ModelEvent event : events) {
            this.fCache.put(event.getEntity().getId(), (IEntity)((AbstractPersistableDAO)this.fDAO).getEntityClass().cast(event.getEntity()));
        }
    }

    protected void removeAll(Set<E> events) {
        for (ModelEvent event : events) {
            this.fCache.remove(event.getEntity().getId());
        }
    }

    protected void onDatabaseClosed(DatabaseEvent event) {
        this.fCache.clear();
    }

    protected void onDatabaseOpened(DatabaseEvent event) {
        this.fCache.clear();
        for (IEntity entity : ((AbstractPersistableDAO)this.fDAO).loadAll()) {
            this.fCache.put(entity.getId(), entity);
        }
    }

    protected abstract L createEntityListener();

    protected final D getDAO() {
        return this.fDAO;
    }

    protected final ConcurrentMap<Long, T> getCache() {
        return this.fCache;
    }

    @Override
    public final boolean exists(long id) throws PersistenceException {
        return this.fCache.containsKey(id);
    }

    @Override
    public final T load(long id) throws PersistenceException {
        return (T)((IEntity)this.fCache.get(id));
    }

    @Override
    public final Collection<T> loadAll() throws PersistenceException {
        return Collections.unmodifiableCollection(this.fCache.values());
    }

    @Override
    public final void fireEvents(Set<E> events, EventType eventType) {
        ((AbstractEntityDAO)this.fDAO).fireEvents(events, eventType);
    }

    @Override
    public final long countAll() throws PersistenceException {
        return this.fCache.size();
    }

    @Override
    public final void addEntityListener(L listener) {
        ((AbstractEntityDAO)this.fDAO).addEntityListener(listener);
    }

    @Override
    public final void removeEntityListener(L listener) {
        ((AbstractEntityDAO)this.fDAO).removeEntityListener(listener);
    }

    @Override
    public final void delete(T persistable) throws PersistenceException {
        ((AbstractPersistableDAO)this.fDAO).delete(persistable);
    }

    @Override
    public final void deleteAll(Collection<T> persistables) throws PersistenceException {
        ((AbstractPersistableDAO)this.fDAO).deleteAll(persistables);
    }

    @Override
    public final Class<? extends T> getEntityClass() {
        return ((AbstractPersistableDAO)this.fDAO).getEntityClass();
    }

    @Override
    public final T save(T persistable) throws PersistenceException {
        return (T)((IEntity)((AbstractPersistableDAO)this.fDAO).save(persistable));
    }

    @Override
    public final void saveAll(Collection<T> persistables) throws PersistenceException {
        ((AbstractPersistableDAO)this.fDAO).saveAll(persistables);
    }
}

