/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import com.db4o.query.Query;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.rssowl.core.internal.persist.dao.AbstractPersistableDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.dao.IEntityDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.LoggingSafeRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityDAO<T extends IEntity, L extends EntityListener<E, T>, E extends ModelEvent>
extends AbstractPersistableDAO<T>
implements IEntityDAO<T, L, E> {
    protected final List<L> fEntityListeners = new CopyOnWriteArrayList<L>();

    public AbstractEntityDAO(Class<? extends T> entityClass, boolean saveFully) {
        super(entityClass, saveFully);
    }

    protected abstract E createSaveEventTemplate(T var1);

    protected abstract E createDeleteEventTemplate(T var1);

    @Override
    public boolean exists(long id) {
        try {
            return !this.loadList(id).isEmpty();
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public T load(long id) {
        List<T> list;
        block5: {
            list = this.loadList(id);
            if (!list.isEmpty()) break block5;
            return null;
        }
        try {
            if (list.size() > 1) {
                String message = "There should only be a single entity for a given id, but there are: " + list.size() + ", id: " + id + ", entities:\n";
                for (IEntity entity : list) {
                    message = String.valueOf(message) + entity.toString() + "\n";
                }
                throw new IllegalStateException(message);
            }
            IEntity entity = (IEntity)list.get(0);
            this.fDb.activate((Object)entity, Integer.MAX_VALUE);
            return (T)entity;
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    private List<T> loadList(long id) throws Db4oException {
        Query query = this.fDb.query();
        query.constrain((Object)this.fEntityClass);
        query.descend("fId").constrain((Object)id);
        return this.getList(query);
    }

    @Override
    protected void preSave(T entity) {
        E event = this.createSaveEventTemplate(entity);
        if (event != null) {
            DBHelper.putEventTemplate(event);
        }
    }

    @Override
    protected void preDelete(T entity) {
        E event = this.createDeleteEventTemplate(entity);
        if (event != null) {
            DBHelper.putEventTemplate(event);
        }
    }

    @Override
    public final void fireEvents(final Set<E> events, final EventType eventType) {
        Assert.isNotNull((Object)((Object)eventType), (String)"eventType");
        for (final EntityListener listener : this.fEntityListeners) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    switch (eventType) {
                        case PERSIST: {
                            listener.entitiesAdded(events);
                            break;
                        }
                        case UPDATE: {
                            listener.entitiesUpdated(events);
                            break;
                        }
                        case REMOVE: {
                            listener.entitiesDeleted(events);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("eventType unknown: " + (Object)((Object)eventType));
                        }
                    }
                }
            });
        }
    }

    @Override
    public void addEntityListener(L listener) {
        this.fEntityListeners.add(listener);
    }

    @Override
    public void removeEntityListener(L listener) {
        this.fEntityListeners.remove(listener);
    }
}

