/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.newsaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.INewsAction;
import org.rssowl.core.internal.newsaction.DeleteNewsAction;
import org.rssowl.core.internal.newsaction.Messages;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelNewsAction
implements INewsAction {
    public static final String ID = "org.rssowl.core.LabelNewsAction";

    @Override
    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        news = CoreUtils.replace(news, replacements);
        ArrayList<IEntity> entitiesToSave = new ArrayList<IEntity>(news.size());
        Long labelId = (Long)data;
        ILabel label = DynamicDAO.load(ILabel.class, labelId);
        if (label != null) {
            for (INews newsitem : news) {
                if (newsitem.getLabels().contains(label)) continue;
                newsitem.addLabel(label);
                entitiesToSave.add(newsitem);
            }
        }
        return entitiesToSave;
    }

    @Override
    public boolean conflictsWith(INewsAction otherAction) {
        return otherAction instanceof DeleteNewsAction;
    }

    @Override
    public String getLabel(Object data) {
        Long labelId;
        ILabel label;
        if (data != null && data instanceof Long && (label = DynamicDAO.load(ILabel.class, labelId = (Long)data)) != null) {
            return NLS.bind((String)Messages.LabelNewsAction_LABEL_NEWS_N, (Object)label.getName());
        }
        return null;
    }
}

