/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.internal.interpreter.Messages;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.URIUtils;

public class BugzillaInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("Bugzilla");
        this.processFeed(root, feed);
    }

    private void processFeed(Element element, IFeed feed) {
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            URI uri;
            String name = attribute.getName();
            if (this.processAttributeExtern(attribute, feed)) continue;
            if ("version".equals(name)) {
                feed.setFormat(this.buildFormat("Bugzilla", attribute.getValue()));
                continue;
            }
            if (!"urlbase".equals(name) || (uri = URIUtils.createURI(attribute.getValue())) == null) continue;
            feed.setBase(uri);
        }
        List feedChildren = element.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed) || !"bug".equals(name)) continue;
            this.processBug(child, feed);
        }
    }

    private void processBug(Element element, IFeed feed) {
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("short_desc".equals(name)) {
                feed.setTitle(child.getText());
                continue;
            }
            if ("reporter".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri == null) continue;
                IPerson person = Owl.getModelFactory().createPerson(null, feed);
                person.setEmail(uri);
                continue;
            }
            if ("bug_id".equals(name)) {
                URI baseUri = feed.getBase();
                try {
                    feed.setHomepage(new URI(baseUri.getScheme(), baseUri.getAuthority(), "/show_bug.cgi", "id=" + child.getText(), baseUri.getFragment()));
                }
                catch (URISyntaxException uRISyntaxException) {}
                continue;
            }
            if (!"long_desc".equals(name)) continue;
            this.processDescription(child, feed);
        }
    }

    private void processDescription(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        this.processNamespaceAttributes(element, feed);
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            news.setLink(feed.getHomepage());
            if (this.processElementExtern(child, feed)) continue;
            if ("who".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    IPerson person = Owl.getModelFactory().createPerson(null, news);
                    person.setEmail(uri);
                }
                news.setTitle(NLS.bind((String)Messages.BugzillaInterpreter_COMMENT_FROM, (Object)child.getText()));
                continue;
            }
            if ("bug_when".equals(name)) {
                news.setModifiedDate(DateUtils.parseDate(child.getText()));
                continue;
            }
            if (!"thetext".equals(name)) continue;
            news.setDescription(child.getText());
        }
    }
}

