/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.slots.Slot;

public abstract class ObjectMarshaller {
    public MarshallerFamily _family;

    protected void traverseFields(ClassMetadata classMetadata, Buffer buffer, ObjectHeaderAttributes objectHeaderAttributes, TraverseFieldCommand traverseFieldCommand) {
        int n = 0;
        while (classMetadata != null && !traverseFieldCommand.cancelled()) {
            int n2 = traverseFieldCommand.fieldCount(classMetadata, buffer);
            for (int i = 0; i < n2 && !traverseFieldCommand.cancelled(); ++i) {
                traverseFieldCommand.processField(classMetadata.i_fields[i], this.isNull(objectHeaderAttributes, n), classMetadata);
                ++n;
            }
            classMetadata = classMetadata.i_ancestor;
        }
    }

    protected abstract boolean isNull(ObjectHeaderAttributes var1, int var2);

    public abstract void addFieldIndices(ClassMetadata var1, ObjectHeaderAttributes var2, StatefulBuffer var3, Slot var4);

    public abstract TreeInt collectFieldIDs(TreeInt var1, ClassMetadata var2, ObjectHeaderAttributes var3, StatefulBuffer var4, String var5);

    protected StatefulBuffer createWriterForNew(Transaction transaction, ObjectReference objectReference, int n, int n2) {
        int n3 = objectReference.getID();
        int n4 = -1;
        if (!transaction.stream().isClient()) {
            n4 = transaction.i_file.getSlot(n2);
            transaction.slotFreeOnRollback(n3, n4, n2);
        }
        transaction.setPointer(n3, n4, n2);
        return this.createWriterForUpdate(transaction, n, n3, n4, n2);
    }

    protected StatefulBuffer createWriterForUpdate(Transaction transaction, int n, int n2, int n3, int n4) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, n4);
        statefulBuffer.useSlot(n2, n3, n4);
        statefulBuffer.setUpdateDepth(n);
        return statefulBuffer;
    }

    public abstract void deleteMembers(ClassMetadata var1, ObjectHeaderAttributes var2, StatefulBuffer var3, int var4, boolean var5);

    public abstract boolean findOffset(ClassMetadata var1, ObjectHeaderAttributes var2, Buffer var3, FieldMetadata var4);

    public abstract void instantiateFields(ClassMetadata var1, ObjectHeaderAttributes var2, ObjectReference var3, Object var4, StatefulBuffer var5);

    public abstract StatefulBuffer marshallNew(Transaction var1, ObjectReference var2, int var3);

    public abstract void marshallUpdate(Transaction var1, int var2, ObjectReference var3, Object var4);

    protected void marshallUpdateWrite(Transaction transaction, ObjectReference objectReference, Object object, StatefulBuffer statefulBuffer) {
        ClassMetadata classMetadata = objectReference.getYapClass();
        ObjectContainerBase objectContainerBase = transaction.stream();
        objectContainerBase.writeUpdate(classMetadata, statefulBuffer);
        if (objectReference.isActive()) {
            objectReference.setStateClean();
        }
        objectReference.endProcessing();
        this.objectOnUpdate(classMetadata, objectContainerBase, object);
    }

    private void objectOnUpdate(ClassMetadata classMetadata, ObjectContainerBase objectContainerBase, Object object) {
        objectContainerBase.callbacks().objectOnUpdate(object);
        classMetadata.dispatchEvent(objectContainerBase, object, 5);
    }

    public abstract Object readIndexEntry(ClassMetadata var1, ObjectHeaderAttributes var2, FieldMetadata var3, StatefulBuffer var4);

    public abstract ObjectHeaderAttributes readHeaderAttributes(Buffer var1);

    public abstract void readVirtualAttributes(Transaction var1, ClassMetadata var2, ObjectReference var3, ObjectHeaderAttributes var4, Buffer var5);

    public abstract void defragFields(ClassMetadata var1, ObjectHeader var2, ReaderPair var3);

    public abstract void writeObjectClassID(Buffer var1, int var2);

    public abstract void skipMarshallerInfo(Buffer var1);

    protected static abstract class TraverseFieldCommand {
        private boolean _cancelled = false;

        protected TraverseFieldCommand() {
        }

        public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
            return classMetadata.readFieldCount(buffer);
        }

        public boolean cancelled() {
            return this._cancelled;
        }

        protected void cancel() {
            this._cancelled = true;
        }

        public abstract void processField(FieldMetadata var1, boolean var2, ClassMetadata var3);
    }
}

