/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.BitMap4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.ObjectHeaderAttributes;

public class ObjectHeaderAttributes1
extends ObjectHeaderAttributes {
    private static final byte VERSION = 1;
    private final int _fieldCount;
    private final BitMap4 _nullBitMap;
    private int _baseLength;
    private int _payLoadLength;

    public ObjectHeaderAttributes1(ObjectReference objectReference) {
        this._fieldCount = objectReference.getYapClass().fieldCount();
        this._nullBitMap = new BitMap4(this._fieldCount);
        this.calculateLengths(objectReference);
    }

    public ObjectHeaderAttributes1(Buffer buffer) {
        this._fieldCount = buffer.readInt();
        this._nullBitMap = buffer.readBitMap(this._fieldCount);
    }

    public void addBaseLength(int n) {
        this._baseLength += n;
    }

    public void addPayLoadLength(int n) {
        this._payLoadLength += n;
    }

    private void calculateLengths(ObjectReference objectReference) {
        this._baseLength = this.headerLength() + this.nullBitMapLength();
        this._payLoadLength = 0;
        ClassMetadata classMetadata = objectReference.getYapClass();
        Transaction transaction = objectReference.getTrans();
        Object object = objectReference.getObject();
        this.calculateLengths(transaction, classMetadata, object, 0);
        this._baseLength = objectReference.getStream().alignToBlockSize(this._baseLength);
    }

    private void calculateLengths(Transaction transaction, ClassMetadata classMetadata, Object object, int n) {
        this._baseLength += 4;
        if (classMetadata.i_fields != null) {
            for (int i = 0; i < classMetadata.i_fields.length; ++i) {
                FieldMetadata fieldMetadata = classMetadata.i_fields[i];
                Object object2 = fieldMetadata.getOrCreate(transaction, object);
                if (object2 == null && fieldMetadata.canUseNullBitmap()) {
                    this._nullBitMap.setTrue(n);
                } else {
                    fieldMetadata.calculateLengths(transaction, this, object2);
                }
                ++n;
            }
        }
        if (classMetadata.i_ancestor == null) {
            return;
        }
        this.calculateLengths(transaction, classMetadata.i_ancestor, object, n);
    }

    private int headerLength() {
        return 5;
    }

    public boolean isNull(int n) {
        return this._nullBitMap.isTrue(n);
    }

    private int nullBitMapLength() {
        return 4 + this._nullBitMap.marshalledLength();
    }

    public int objectLength() {
        return this._baseLength + this._payLoadLength;
    }

    public void prepareIndexedPayLoadEntry(Transaction transaction) {
        this._payLoadLength = transaction.stream().alignToBlockSize(this._payLoadLength);
    }

    public void write(StatefulBuffer statefulBuffer) {
        statefulBuffer.append((byte)1);
        statefulBuffer.writeInt(this._fieldCount);
        statefulBuffer.writeBitMap(this._nullBitMap);
        statefulBuffer._payloadOffset = this._baseLength;
    }
}

