/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.util.AudioUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class PlaySoundActionPresentation
implements INewsActionPresentation {
    private static boolean fgMediaDirectorySet = false;
    private Link fSoundPathLink;
    private Composite fContainer;

    public void create(Composite parent, Object data) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        ((GridLayout)this.fContainer.getLayout()).marginLeft = 5;
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fSoundPathLink = new Link(this.fContainer, 64);
        this.fSoundPathLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)this.fSoundPathLink.getLayoutData()).widthHint = 100;
        this.updateLink(data);
        this.fSoundPathLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("play".equals(e.text) && AudioUtils.isSupported()) {
                    AudioUtils.play(PlaySoundActionPresentation.this.fSoundPathLink.getData().toString());
                } else {
                    PlaySoundActionPresentation.this.onSelect();
                }
            }
        });
    }

    private void onSelect() {
        String fileName;
        File file;
        FileDialog dialog = new FileDialog(this.fSoundPathLink.getShell(), 4096);
        dialog.setText(Messages.PlaySoundActionPresentation_SELECT_SOUND);
        dialog.setFilterExtensions(new String[]{"*.wav"});
        if (this.fSoundPathLink.getData() != null && (file = new File(this.fSoundPathLink.getData().toString())).exists()) {
            dialog.setFileName(file.toString());
        }
        if (!StringUtils.isSet((String)dialog.getFileName()) && Application.IS_WINDOWS && !fgMediaDirectorySet) {
            File mediaDir;
            fgMediaDirectorySet = true;
            String winDir = System.getenv("WinDir");
            if (StringUtils.isSet((String)winDir) && (mediaDir = new File(String.valueOf(winDir) + "\\Media")).exists()) {
                dialog.setFilterPath(mediaDir.toString());
            }
        }
        if ((fileName = dialog.open()) != null) {
            this.updateLink(fileName);
            this.fSoundPathLink.getShell().layout(true, true);
        }
    }

    private void updateLink(Object data) {
        if (data == null) {
            this.resetLink();
        } else {
            File file = new File(data.toString());
            if (file.exists()) {
                this.fSoundPathLink.setText(NLS.bind((String)Messages.PlaySoundActionPresentation_SOUND_LINK, (Object)file.getName()));
                this.fSoundPathLink.setToolTipText(data.toString());
                this.fSoundPathLink.setData(data);
            } else {
                this.resetLink();
            }
        }
    }

    private void resetLink() {
        this.fSoundPathLink.setText("<a>" + Messages.PlaySoundActionPresentation_SELECT_SOUND_TO_PLAY + "</a>");
        this.fSoundPathLink.setData(null);
        this.fSoundPathLink.setToolTipText(null);
    }

    public void dispose() {
        this.fContainer.dispose();
    }

    public Object getData() {
        return this.fSoundPathLink.getData();
    }
}

