/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rssowl.core.INewsAction;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.ui.internal.util.AudioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaySoundAction
implements INewsAction {
    private static final Map<String, Long> fgLastPlayedSoundsMap = Collections.synchronizedMap(new HashMap());
    private static final long BLOCK_SOUND_REPEAT_VALUE = 5000L;

    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        Long lastPlayed;
        if (AudioUtils.isSupported() && data != null && data instanceof String && ((lastPlayed = fgLastPlayedSoundsMap.get(data)) == null || System.currentTimeMillis() - lastPlayed > 5000L)) {
            AudioUtils.play((String)data);
            fgLastPlayedSoundsMap.put((String)data, System.currentTimeMillis());
        }
        return Collections.emptyList();
    }

    public boolean conflictsWith(INewsAction otherAction) {
        return false;
    }

    public String getLabel(Object data) {
        return null;
    }
}

