/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.rssowl.core.INewsAction;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.JobQueue;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.TaskAdapter;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenNewsAction
implements INewsAction {
    private static final int OPEN_BROWSER_DELAY = 1000;
    private final JobQueue fOpenInBrowserQueue = new JobQueue(Messages.OpenNewsAction_OPEN_BROWSER_QUEUE, 1, Integer.MAX_VALUE, false, 0);

    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        if (Controller.getDefault().isShuttingDown()) {
            this.fOpenInBrowserQueue.cancel(false, true);
            return Collections.emptyList();
        }
        news = CoreUtils.replace(news, replacements);
        ArrayList<OpenInBrowserTask> tasks = new ArrayList<OpenInBrowserTask>(news.size());
        for (INews item : news) {
            String link = CoreUtils.getLink((INews)item);
            if (!StringUtils.isSet((String)link)) continue;
            tasks.add(new OpenInBrowserTask(link));
        }
        this.fOpenInBrowserQueue.schedule(tasks);
        if (Controller.getDefault().isShuttingDown()) {
            this.fOpenInBrowserQueue.cancel(false, true);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean conflictsWith(INewsAction otherAction) {
        return false;
    }

    public String getLabel(Object data) {
        return null;
    }

    private static class OpenInBrowserTask
    extends TaskAdapter {
        private final String fLink;

        OpenInBrowserTask(String link) {
            this.fLink = link;
        }

        public IStatus run(final IProgressMonitor monitor) {
            JobRunner.runInUIThread(null, new Runnable(){

                public void run() {
                    if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                        OpenInBrowserAction openAction = new OpenInBrowserAction();
                        openAction.setForceOpenInBackground(true);
                        openAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)OpenInBrowserTask.this.fLink));
                        openAction.run();
                    }
                }
            });
            if (OwlUI.useExternalBrowser() && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return Status.OK_STATUS;
        }
    }
}

