/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsComparator
extends ViewerComparator
implements Comparator<INews> {
    private NewsColumn fSortBy;
    private boolean fAscending;
    private Map<Long, String> fMapBinIdToLocation = new HashMap<Long, String>();
    private Map<String, String> fMapFeedLinkToLocation = new HashMap<String, String>();

    public boolean isAscending() {
        return this.fAscending;
    }

    public void setAscending(boolean ascending) {
        this.fAscending = ascending;
    }

    public NewsColumn getSortBy() {
        return this.fSortBy;
    }

    public void setSortBy(NewsColumn sortBy) {
        this.fSortBy = sortBy;
    }

    public boolean needsRefresh(Collection<NewsEvent> events) {
        if (this.fSortBy != null) {
            switch (this.fSortBy) {
                case AUTHOR: {
                    return CoreUtils.isAuthorChange(events);
                }
                case CATEGORY: {
                    return CoreUtils.isCategoryChange(events);
                }
                case DATE: {
                    return CoreUtils.isDateChange(events);
                }
                case MODIFIED: {
                    return CoreUtils.isModifiedDateChange(events);
                }
                case PUBLISHED: {
                    return CoreUtils.isPublishedDateChange(events);
                }
                case TITLE: {
                    return CoreUtils.isTitleChange(events);
                }
            }
        }
        return false;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof EntityGroup && e2 instanceof EntityGroup) {
            return this.compare((EntityGroup)e1, (EntityGroup)e2);
        }
        if (e1 instanceof INews && e2 instanceof INews) {
            return this.compare((INews)e1, (INews)e2);
        }
        return 0;
    }

    @Override
    private int compare(EntityGroup e1, EntityGroup e2) {
        long id;
        if (!(this.fSortBy == null || this.fSortBy != NewsColumn.DATE && this.fSortBy != NewsColumn.PUBLISHED && this.fSortBy != NewsColumn.MODIFIED && this.fSortBy != NewsColumn.RECEIVED || !this.fAscending || (id = e1.getId()) != (long)NewsGrouping.Group.TODAY.ordinal() && id != (long)NewsGrouping.Group.YESTERDAY.ordinal() && id != (long)NewsGrouping.Group.EARLIER_THIS_WEEK.ordinal() && id != (long)NewsGrouping.Group.LAST_WEEK.ordinal() && id != (long)NewsGrouping.Group.OLDER.ordinal())) {
            return this.fAscending ? 1 : -1;
        }
        return 0;
    }

    @Override
    public int compare(INews news1, INews news2) {
        int result = 0;
        if (this.fSortBy != null) {
            switch (this.fSortBy) {
                case DATE: {
                    return this.compareByDate(news1, news2, false);
                }
                case PUBLISHED: {
                    return this.compareByDate(news1.getPublishDate(), news2.getPublishDate(), false);
                }
                case MODIFIED: {
                    return this.compareByDate(news1.getModifiedDate(), news2.getModifiedDate(), false);
                }
                case RECEIVED: {
                    return this.compareByDate(news1.getReceiveDate(), news2.getReceiveDate(), false);
                }
                case TITLE: {
                    result = this.compareByTitle(CoreUtils.getHeadline((INews)news1, (boolean)true), CoreUtils.getHeadline((INews)news2, (boolean)true));
                    break;
                }
                case AUTHOR: {
                    result = this.compareByAuthor(news1.getAuthor(), news2.getAuthor());
                    break;
                }
                case CATEGORY: {
                    result = this.compareByCategory(news1.getCategories(), news2.getCategories());
                    break;
                }
                case STICKY: {
                    result = this.compareByStickyness(news1.isFlagged(), news2.isFlagged());
                    break;
                }
                case FEED: {
                    result = this.compareByFeed(news1.getFeedLinkAsText(), news2.getFeedLinkAsText());
                    break;
                }
                case ATTACHMENTS: {
                    result = this.compareByHasAttachments(!news1.getAttachments().isEmpty(), !news2.getAttachments().isEmpty());
                    break;
                }
                case LABELS: {
                    result = this.compareByLabels(CoreUtils.getSortedLabels((INews)news1), CoreUtils.getSortedLabels((INews)news2));
                    break;
                }
                case STATUS: {
                    result = this.compareByStatus(news1.getState(), news2.getState());
                    break;
                }
                case LOCATION: {
                    result = this.compareByLocation(news1, news2);
                    break;
                }
                case LINK: {
                    result = this.compareByLink(news1, news2);
                }
            }
        }
        if (result == 0) {
            result = this.compareByDate(news1, news2, true);
        }
        return result;
    }

    private int compareByFeed(String feedLink1, String feedLink2) {
        int result = feedLink1.compareTo(feedLink2);
        return this.fAscending ? result : result * -1;
    }

    private int compareByDate(INews news1, INews news2, boolean forceDescending) {
        Date date1 = DateUtils.getRecentDate((INews)news1);
        Date date2 = DateUtils.getRecentDate((INews)news2);
        return this.compareByDate(date1, date2, forceDescending);
    }

    private int compareByDate(Date date1, Date date2, boolean forceDescending) {
        if (date1 == null) {
            return this.fAscending && !forceDescending ? -1 : 1;
        }
        if (date2 == null) {
            return this.fAscending && !forceDescending ? 1 : -1;
        }
        int result = date1.compareTo(date2);
        return this.fAscending && !forceDescending ? result : result * -1;
    }

    private int compareByTitle(String title1, String title2) {
        int result = this.compareByString(title1, title2);
        return this.fAscending ? result : result * -1;
    }

    private int compareByStatus(INews.State s1, INews.State s2) {
        int result = 0;
        if (s1 != s2) {
            result = s1 == INews.State.NEW ? -1 : (s2 == INews.State.NEW ? 1 : (s1 == INews.State.UPDATED ? -1 : (s2 == INews.State.UPDATED ? 1 : (s1 == INews.State.UNREAD ? -1 : (s2 == INews.State.UNREAD ? 1 : s1.compareTo((Enum)s2))))));
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByLocation(INews n1, INews n2) {
        int result = this.compareByString(this.getLocation(n1), this.getLocation(n2));
        return this.fAscending ? result : result * -1;
    }

    private int compareByLink(INews n1, INews n2) {
        int result = this.compareByString(CoreUtils.getLink((INews)n1), CoreUtils.getLink((INews)n2));
        return this.fAscending ? result : result * -1;
    }

    private String getLocation(INews news) {
        IBookMark bookmark;
        if (news.getParentId() > 0L) {
            String location = this.fMapBinIdToLocation.get(news.getParentId());
            if (location == null) {
                NewsBinReference ref = new NewsBinReference(news.getParentId());
                INewsBin bin = ref.resolve();
                location = bin.getName();
                this.fMapBinIdToLocation.put(news.getParentId(), location);
            }
            return location;
        }
        String location = this.fMapFeedLinkToLocation.get(news.getFeedLinkAsText());
        if (location == null && (bookmark = CoreUtils.getBookMark((String)news.getFeedLinkAsText())) != null) {
            location = bookmark.getName();
            this.fMapFeedLinkToLocation.put(news.getFeedLinkAsText(), location);
        }
        return location;
    }

    private int compareByHasAttachments(boolean hasAttachments1, boolean hasAttachments2) {
        int result = 0;
        if (hasAttachments1 && !hasAttachments2) {
            result = 1;
        } else if (!hasAttachments1 && hasAttachments2) {
            result = -1;
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByLabels(Set<ILabel> labels1, Set<ILabel> labels2) {
        if (labels1.isEmpty() && labels2.isEmpty()) {
            return 0;
        }
        if (labels1.isEmpty()) {
            return this.fAscending ? 1 : -1;
        }
        if (labels2.isEmpty()) {
            return this.fAscending ? -1 : 1;
        }
        int result = 0;
        Iterator<ILabel> labels1Iterator = labels1.iterator();
        Iterator<ILabel> labels2Iterator = labels2.iterator();
        while (labels1Iterator.hasNext() && labels2Iterator.hasNext()) {
            ILabel label1 = labels1Iterator.next();
            ILabel label2 = labels2Iterator.next();
            if (label1.getOrder() == label2.getOrder()) {
                if (labels1Iterator.hasNext() && labels2Iterator.hasNext()) continue;
                if (labels1Iterator.hasNext()) {
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            result = label1.getOrder() < label2.getOrder() ? -1 : 1;
            break;
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByAuthor(IPerson author1, IPerson author2) {
        int result = 0;
        if (author1 != null && author2 != null) {
            String value1 = author1.getName();
            if (value1 == null && author1.getEmail() != null) {
                value1 = author1.getEmail().toString();
            } else if (value1 == null && author1.getUri() != null) {
                value1 = author1.getUri().toString();
            }
            String value2 = author2.getName();
            if (value2 == null && author2.getEmail() != null) {
                value2 = author2.getEmail().toString();
            } else if (value2 == null && author2.getUri() != null) {
                value2 = author2.getUri().toString();
            }
            result = this.compareByString(value1, value2);
        } else if (author1 != null) {
            result = -1;
        } else if (author2 != null) {
            result = 1;
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByCategory(List<ICategory> categories1, List<ICategory> categories2) {
        int result = 0;
        if (categories1 != null && categories1.size() > 0 && categories2 != null && categories2.size() > 0) {
            String value2;
            ICategory category1 = categories1.get(0);
            ICategory category2 = categories2.get(0);
            String value1 = category1.getName();
            if (value1 == null) {
                value1 = category1.getDomain();
            }
            if ((value2 = category2.getName()) == null) {
                value2 = category2.getName();
            }
            result = this.compareByString(value1, value2);
        } else if (categories1 != null && categories1.size() > 0) {
            result = -1;
        } else if (categories2 != null && categories2.size() > 0) {
            result = 1;
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByStickyness(boolean sticky1, boolean sticky2) {
        int result = 0;
        if (sticky1 && !sticky2) {
            result = 1;
        } else if (!sticky1 && sticky2) {
            result = -1;
        }
        return this.fAscending ? result : result * -1;
    }

    private int compareByString(String str1, String str2) {
        if (str1 != null && str2 != null) {
            return str1.compareToIgnoreCase(str2);
        }
        if (str1 != null) {
            return -1;
        }
        return 1;
    }
}

