/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.SendLinkAction;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.LayoutUtils;

public class BrowserBar {
    private static final String BACK_ACTION = "org.rssowl.ui.internal.editors.feed.BackAction";
    private static final String FORWARD_ACTION = "org.rssowl.ui.internal.editors.feed.ForwardAction";
    private static final String SHARE_ACTION = "org.rssowl.ui.internal.editors.feed.ShareLinkAction";
    private Composite fParent;
    private Composite fContainer;
    private CBrowser fBrowser;
    private ToolBarManager fNavigationToolBarManager;
    private Text fLocationInput;
    private FeedView fFeedView;
    private boolean fLocationSelectAllOnce = true;
    private final Font fItalicFont;

    public BrowserBar(FeedView feedView, Composite parent) {
        this.fFeedView = feedView;
        this.fParent = parent;
        this.fItalicFont = OwlUI.getItalic("org.eclipse.jface.defaultfont");
        this.createControl();
    }

    boolean isVisible() {
        IPreferenceScope globalScope = Owl.getPreferenceService().getGlobalScope();
        boolean useExternalBrowser = OwlUI.useExternalBrowser();
        boolean hideBrowserBar = globalScope.getBoolean(DefaultPreferences.FV_BROWSER_TOOLBAR_HIDDEN);
        return !useExternalBrowser && !hideBrowserBar;
    }

    public void init(CBrowser browser) {
        this.fBrowser = browser;
        this.registerListeners();
    }

    private void registerListeners() {
        LocationAdapter locationListener = new LocationAdapter(){

            public void changed(LocationEvent event) {
                BrowserBar.this.fNavigationToolBarManager.find(BrowserBar.BACK_ACTION).update("enabled");
                BrowserBar.this.fNavigationToolBarManager.find(BrowserBar.FORWARD_ACTION).update("enabled");
                BrowserBar.this.setBusy(false);
            }

            public void changing(LocationEvent event) {
                BrowserBar.this.setBusy(true);
            }
        };
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (!BrowserBar.this.fLocationInput.isDisposed()) {
                    String url = ((Browser)event.widget).getUrl();
                    if (ApplicationServer.getDefault().isNewsServerUrl(url)) {
                        if (ApplicationServer.getDefault().isNewsServerUrl(BrowserBar.this.fLocationInput.getText())) {
                            BrowserBar.this.fLocationInput.setText("");
                        }
                    } else if (!StringUtils.isSet((String)BrowserBar.this.fLocationInput.getText())) {
                        BrowserBar.this.fLocationInput.setText("about:blank".equals(url) ? "" : url);
                    }
                }
            }

            public void completed(ProgressEvent event) {
                if (!BrowserBar.this.fLocationInput.isDisposed()) {
                    String url = ((Browser)event.widget).getUrl();
                    if (ApplicationServer.getDefault().isNewsServerUrl(url)) {
                        BrowserBar.this.fLocationInput.setText("");
                    } else if (StringUtils.isSet((String)url)) {
                        if ("about:blank".equals(url)) {
                            BrowserBar.this.fLocationInput.setText("");
                        } else if (!BrowserBar.this.fLocationInput.isFocusControl()) {
                            BrowserBar.this.fLocationInput.setText(url);
                        }
                    }
                }
            }
        };
        this.fBrowser.getControl().addLocationListener((LocationListener)locationListener);
        this.fBrowser.getControl().addProgressListener(progressListener);
    }

    private void createControl() {
        this.fContainer = new Composite(this.fParent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 3, 0, 0, 2, false));
        ((GridLayout)this.fContainer.getLayout()).marginBottom = 2;
        this.fContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateVisibility();
        this.createNavigationToolBar(this.fContainer);
        this.createLocationInput(this.fContainer);
    }

    void updateVisibility() {
        boolean isVisible = this.isVisible();
        ((GridData)this.fContainer.getLayoutData()).exclude = !isVisible;
        this.fContainer.setVisible(isVisible);
    }

    private void createNavigationToolBar(Composite parent) {
        this.fNavigationToolBarManager = new ToolBarManager(0x800000);
        Action newBrowserTab = new Action(Messages.BrowserBar_NEW_TAB){

            public void run() {
                BrowserUtils.openLinkInternal("about:blank", null);
            }
        };
        newBrowserTab.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/new_browser_tab.gif"));
        this.fNavigationToolBarManager.add((IAction)newBrowserTab);
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action navBackward = new Action(Messages.BrowserBar_BACK){

            public void run() {
                BrowserBar.this.fBrowser.back();
            }

            public boolean isEnabled() {
                return BrowserBar.this.fBrowser != null && BrowserBar.this.fBrowser.getControl().isBackEnabled();
            }
        };
        navBackward.setId(BACK_ACTION);
        navBackward.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/backward.gif"));
        navBackward.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/backward.gif"));
        this.fNavigationToolBarManager.add((IAction)navBackward);
        Action navForward = new Action(Messages.BrowserBar_FORWARD){

            public void run() {
                BrowserBar.this.fBrowser.forward();
            }

            public boolean isEnabled() {
                return BrowserBar.this.fBrowser != null && BrowserBar.this.fBrowser.getControl().isForwardEnabled();
            }
        };
        navForward.setId(FORWARD_ACTION);
        navForward.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/forward.gif"));
        navForward.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/forward.gif"));
        this.fNavigationToolBarManager.add((IAction)navForward);
        Action stopNav = new Action(Messages.BrowserBar_STOP){

            public void run() {
                BrowserBar.this.fBrowser.getControl().stop();
                BrowserBar.this.setBusy(false);
            }
        };
        stopNav.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/cancel.gif"));
        this.fNavigationToolBarManager.add((IAction)stopNav);
        Action reload = new Action(Messages.BrowserBar_RELOAD){

            public void run() {
                BrowserBar.this.fBrowser.refresh();
                BrowserBar.this.setBusy(true);
            }
        };
        reload.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/reload.gif"));
        this.fNavigationToolBarManager.add((IAction)reload);
        Action navHome = new Action(Messages.BrowserBar_HOME){

            public void run() {
                BrowserBar.this.fFeedView.getNewsBrowserControl().getViewer().home();
            }
        };
        navHome.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/home.gif"));
        this.fNavigationToolBarManager.add((IAction)navHome);
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action openLinkInExternalBrowser = new Action(Messages.BrowserBar_OPEN_IN_EXTERNAL_BROWSER){

            public void run() {
                String url = BrowserBar.this.getUrlFromBrowser();
                if (StringUtils.isSet((String)url)) {
                    BrowserUtils.openLinkExternal(url);
                }
            }
        };
        openLinkInExternalBrowser.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/browser.gif"));
        this.fNavigationToolBarManager.add((IAction)openLinkInExternalBrowser);
        Action shareLink = new Action(Messages.BrowserBar_SHARE_LINK, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, BrowserBar.this.fNavigationToolBarManager);
            }

            public String getId() {
                return BrowserBar.SHARE_ACTION;
            }
        };
        this.fNavigationToolBarManager.add((IAction)shareLink);
        shareLink.setImageDescriptor(OwlUI.SHARE);
        shareLink.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                MenuManager shareMenu = new MenuManager();
                final IStructuredSelection selection = BrowserBar.this.getSelectionFromBrowser();
                List<ShareProvider> providers = Controller.getDefault().getShareProviders();
                for (final ShareProvider provider : providers) {
                    if (!provider.isEnabled()) continue;
                    shareMenu.add((IAction)new Action(provider.getName()){

                        public void run() {
                            if ("org.rssowl.ui.SendLinkAction".equals(provider.getId())) {
                                SendLinkAction action = new SendLinkAction();
                                action.selectionChanged(null, (ISelection)selection);
                                action.run(null);
                            } else {
                                Object obj = selection.getFirstElement();
                                if (StringUtils.isSet((String)((String)obj)) && !"about:blank".equals(obj)) {
                                    String shareLink = provider.toShareUrl((String)obj, null);
                                    new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)shareLink)).run();
                                }
                            }
                        }

                        public ImageDescriptor getImageDescriptor() {
                            if (StringUtils.isSet((String)provider.getIconPath())) {
                                return OwlUI.getImageDescriptor(provider.getPluginId(), provider.getIconPath());
                            }
                            return super.getImageDescriptor();
                        }

                        public boolean isEnabled() {
                            return !selection.isEmpty();
                        }

                        public String getActionDefinitionId() {
                            return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getActionDefinitionId();
                        }

                        public String getId() {
                            return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getId();
                        }
                    });
                }
                shareMenu.add((IContributionItem)new Separator());
                shareMenu.add((IAction)new Action(Messages.BrowserBar_CONFIGURE){

                    public void run() {
                        PreferencesUtil.createPreferenceDialogOn((Shell)BrowserBar.this.fBrowser.getControl().getShell(), (String)"org.rssowl.ui.SharingPreferencesPage", null, null).open();
                    }
                });
                return shareMenu.createContextMenu(parent);
            }
        });
        this.fNavigationToolBarManager.add((IContributionItem)new Separator());
        Action discoverFeeds = new Action(Messages.BrowserBar_FIND_FEEDS){

            public void run() {
                String url = BrowserBar.this.getUrlFromBrowser();
                if (StringUtils.isSet((String)url)) {
                    new ImportAction().openWizardForFeedSearch(BrowserBar.this.fBrowser.getControl().getShell(), url);
                } else {
                    new ImportAction().openWizardForKeywordSearch(BrowserBar.this.fBrowser.getControl().getShell());
                }
            }
        };
        this.fNavigationToolBarManager.add((IAction)discoverFeeds);
        discoverFeeds.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/new_bkmrk.gif"));
        this.fNavigationToolBarManager.createControl(parent);
    }

    private IStructuredSelection getSelectionFromBrowser() {
        String url = this.getUrlFromBrowser();
        if (url != null) {
            return new StructuredSelection((Object)url);
        }
        return StructuredSelection.EMPTY;
    }

    private String getUrlFromBrowser() {
        INews news;
        String newsLink;
        Object input;
        String url = this.fBrowser.getControl().getUrl();
        if (StringUtils.isSet((String)url) && !ApplicationServer.getDefault().isNewsServerUrl(url) && !"about:blank".equals(url)) {
            return url;
        }
        if (ApplicationServer.getDefault().isNewsServerUrl(url) && (input = this.fFeedView.getNewsBrowserControl().getViewer().getInput()) instanceof INews && StringUtils.isSet((String)(newsLink = CoreUtils.getLink((INews)(news = (INews)input))))) {
            return newsLink;
        }
        return null;
    }

    private void createLocationInput(Composite parent) {
        this.fLocationInput = Application.IS_WINDOWS || Application.IS_LINUX ? new Text(parent, 2180) : new Text(parent, 2052);
        OwlUI.makeAccessible((Control)this.fLocationInput, Messages.BrowserBar_ENTER_WEBSITE_PHRASE);
        this.fLocationInput.setMessage(Messages.BrowserBar_ENTER_WEBSITE_PHRASE);
        this.fLocationInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fLocationInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (StringUtils.isSet((String)BrowserBar.this.fLocationInput.getText())) {
                    BrowserBar.this.fBrowser.setUrl(URIUtils.getLink((String)BrowserBar.this.fLocationInput.getText()));
                    BrowserBar.this.fBrowser.getControl().setFocus();
                }
            }
        });
        this.fLocationInput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BrowserBar.this.fLocationSelectAllOnce && BrowserBar.this.fLocationInput.getSelectionCount() == 0) {
                    BrowserBar.this.fLocationInput.selectAll();
                }
                BrowserBar.this.fLocationSelectAllOnce = false;
            }
        });
        Controller.getDefault().getContextService().registerInputField((Control)this.fLocationInput);
        this.fLocationInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(true);
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(true);
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
                BrowserBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
                BrowserBar.this.fLocationSelectAllOnce = true;
            }
        });
    }

    private void setBusy(boolean busy) {
        if (this.fLocationInput.isDisposed()) {
            return;
        }
        String url = this.fLocationInput.getText();
        if (busy && StringUtils.isSet((String)url) && !ApplicationServer.getDefault().isNewsServerUrl(url) && !"about:blank".equals(url)) {
            this.fLocationInput.setFont(this.fItalicFont);
        } else {
            this.fLocationInput.setFont(null);
        }
    }
}

