/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.exporter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.interpreter.ITypeExporter;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.exporter.ExportElementsPage;
import org.rssowl.ui.internal.dialogs.exporter.ExportOptionsPage;
import org.rssowl.ui.internal.dialogs.exporter.Messages;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportWizard
extends Wizard
implements IExportWizard {
    private ExportElementsPage fExportElementsPage;
    private ExportOptionsPage fExportOptionsPage;

    public void addPages() {
        this.setWindowTitle(Messages.ExportWizard_EXPORT);
        this.fExportElementsPage = new ExportElementsPage(Messages.ExportWizard_CHOOSE_ELEMENTS);
        this.addPage((IWizardPage)this.fExportElementsPage);
        this.fExportOptionsPage = new ExportOptionsPage(Messages.ExportWizard_EXPORT_OPTIONS);
        this.addPage((IWizardPage)this.fExportOptionsPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.ExportWizard_EXPORT_FILE);
        ArrayList<String> filterExtensions = new ArrayList<String>();
        filterExtensions.add("*.opml");
        filterExtensions.add("*.xml");
        Collection exportFormats = Owl.getInterpreter().getExportFormats();
        for (String exportFormat : exportFormats) {
            String format = "*." + exportFormat.toLowerCase();
            if (filterExtensions.contains(format)) continue;
            filterExtensions.add(format);
        }
        if (!filterExtensions.contains("*.*")) {
            filterExtensions.add("*.*");
        }
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
        dialog.setFileName("rssowl.opml");
        dialog.setOverwrite(true);
        String string = dialog.open();
        if (string != null) {
            BookMarkExplorer explorer;
            if (this.fExportOptionsPage.getExportOptions() != null && this.fExportOptionsPage.getExportOptions().contains(ITypeExporter.Options.EXPORT_PREFERENCES) && (explorer = OwlUI.getOpenedBookMarkExplorer()) != null) {
                explorer.saveState();
            }
            File file = new File(string);
            try {
                Owl.getInterpreter().exportTo(file, this.getElementsToExport(), this.fExportOptionsPage.getExportOptions());
                return true;
            }
            catch (InterpreterException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return false;
    }

    private List<IFolderChild> getElementsToExport() {
        List<IFolderChild> selectedElements = this.fExportElementsPage.getElementsToExport();
        Set<ITypeExporter.Options> options = this.fExportOptionsPage.getExportOptions();
        Collection rootFolders = ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).loadRoots();
        if (!selectedElements.containsAll(rootFolders)) {
            HashSet<ISearchMark> savedSearches = new HashSet<ISearchMark>();
            HashSet<IFolder> folders = new HashSet<IFolder>();
            for (IFolderChild child : selectedElements) {
                if (child instanceof IFolder) {
                    folders.add((IFolder)child);
                    continue;
                }
                if (!(child instanceof ISearchMark)) continue;
                savedSearches.add((ISearchMark)child);
            }
            for (IFolder folder : folders) {
                this.findSavedSearches(savedSearches, folder);
            }
            for (ISearchMark savedSearch : savedSearches) {
                this.collectLocations(selectedElements, (ISearch)savedSearch);
            }
            if (options != null && options.contains(ITypeExporter.Options.EXPORT_FILTERS)) {
                Collection filters = DynamicDAO.loadAll(ISearchFilter.class);
                for (ISearchFilter filter : filters) {
                    this.collectLocations(selectedElements, filter);
                }
            }
        }
        CoreUtils.normalize(selectedElements);
        return selectedElements;
    }

    private void collectLocations(List<IFolderChild> selectedElements, ISearch search) {
        if (search != null) {
            List conditions = search.getSearchConditions();
            for (ISearchCondition condition : conditions) {
                Object value;
                if (condition.getField().getId() != 19 || !((value = condition.getValue()) instanceof Long[][])) continue;
                List locations = CoreUtils.toEntities((Long[][])((Long[][])value));
                for (IFolderChild location : locations) {
                    if (selectedElements.contains(location)) continue;
                    selectedElements.add(location);
                }
            }
        }
    }

    private void collectLocations(List<IFolderChild> selectedElements, ISearchFilter filter) {
        this.collectLocations(selectedElements, filter.getSearch());
        List actions = filter.getActions();
        for (IFilterAction action : actions) {
            Long[] binIds;
            Object value;
            if (!"org.rssowl.core.MoveNewsAction".equals(action.getActionId()) && !"org.rssowl.core.CopyNewsAction".equals(action.getActionId()) || !((value = action.getData()) instanceof Long[])) continue;
            Long[] longArray = binIds = (Long[])value;
            int n = binIds.length;
            int n2 = 0;
            while (n2 < n) {
                Long binId = longArray[n2];
                INewsBin bin = new NewsBinReference(binId.longValue()).resolve();
                if (bin != null && !selectedElements.contains(bin)) {
                    selectedElements.add((IFolderChild)bin);
                }
                ++n2;
            }
        }
    }

    private void findSavedSearches(Set<ISearchMark> savedSearches, IFolder folder) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                this.findSavedSearches(savedSearches, (IFolder)child);
                continue;
            }
            if (!(child instanceof ISearchMark)) continue;
            savedSearches.add((ISearchMark)child);
        }
    }

    public boolean needsProgressMonitor() {
        return false;
    }
}

