/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.bookmark;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.bookmark.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordSubscriptionPage
extends WizardPage {
    private static final String URL_INPUT_TOKEN = "[:]";
    private static final String KEYWORD_FEED_EXTENSION_POINT = "org.rssowl.ui.KeywordFeed";
    private static final List<SearchEngine> fgSearchEngines = KeywordSubscriptionPage.loadSearchEngines();
    private SearchEngine fSelectedEngine;

    protected KeywordSubscriptionPage(String pageName) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/bkmrk_wiz.gif"));
        this.setMessage(Messages.KeywordSubscriptionPage_CREATE_BOOKMARK);
    }

    private static List<SearchEngine> loadSearchEngines() {
        IConfigurationElement[] elements;
        ArrayList<SearchEngine> engines = new ArrayList<SearchEngine>(5);
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(KEYWORD_FEED_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String iconPath = element.getAttribute("icon");
            String url = element.getAttribute("url");
            engines.add(new SearchEngine(id, element.getNamespaceIdentifier(), name, iconPath, url));
            ++n2;
        }
        return engines;
    }

    public SearchEngine getSelectedEngine() {
        return this.fSelectedEngine;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        infoLabel.setText(Messages.KeywordSubscriptionPage_SELECT_SEARCH_ENGINE);
        Composite contentMargin = new Composite(container, 0);
        contentMargin.setLayoutData((Object)new GridData(4, 1, true, false));
        contentMargin.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)contentMargin.getLayout()).marginTop = 10;
        ((GridLayout)contentMargin.getLayout()).verticalSpacing = 20;
        String lastKeywordFeedId = Owl.getPreferenceService().getGlobalScope().getString(DefaultPreferences.LAST_KEYWORD_FEED);
        if (!StringUtils.isSet((String)lastKeywordFeedId)) {
            lastKeywordFeedId = fgSearchEngines.get(0).getId();
        }
        for (final SearchEngine engine : fgSearchEngines) {
            Button button = new Button(contentMargin, 16);
            button.setText(engine.getName());
            if (StringUtils.isSet((String)engine.getIconPath())) {
                LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)button);
                button.setImage(OwlUI.getImage((ResourceManager)resources, OwlUI.getImageDescriptor(engine.getPluginId(), engine.getIconPath())));
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeywordSubscriptionPage.this.fSelectedEngine = engine;
                }
            });
            if (!lastKeywordFeedId.equals(engine.getId())) continue;
            button.setSelection(true);
            button.setFocus();
            this.fSelectedEngine = engine;
        }
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    static class SearchEngine {
        private final String fId;
        private final String fPluginId;
        private final String fName;
        private final String fIconPath;
        private final String fUrl;

        SearchEngine(String id, String pluginId, String name, String iconPath, String url) {
            this.fId = id;
            this.fPluginId = pluginId;
            this.fName = name;
            this.fIconPath = iconPath;
            this.fUrl = url;
        }

        String getId() {
            return this.fId;
        }

        String getPluginId() {
            return this.fPluginId;
        }

        String getName() {
            return this.fName;
        }

        String getLabel(String keywords) {
            return NLS.bind((String)Messages.KeywordSubscriptionPage_N_ON_M, (Object)StringUtils.replaceAll((String)this.fName, (String)"&", (String)""), (Object)keywords);
        }

        String getIconPath() {
            return this.fIconPath;
        }

        String toUrl(String keywords) {
            keywords = URIUtils.urlEncode((String)keywords);
            return StringUtils.replaceAll((String)this.fUrl, (String)KeywordSubscriptionPage.URL_INPUT_TOKEN, (String)keywords);
        }
    }
}

