/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class UpdateDialog
extends TitleAreaDialog {
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private final IInstallFeatureOperation[] fUpdates;
    private StyledText fUpdateInfoTextRight;
    private StyledText fUpdateInfoTextLeft;
    private StyledText fUpdateInfoTextBottom;
    private Button fUpdateOnStartupCheck;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private final boolean fCanUpdate;

    public UpdateDialog(Shell parentShell, IInstallFeatureOperation[] updates) {
        super(parentShell);
        this.fUpdates = updates;
        this.fCanUpdate = this.canUpdate();
    }

    public boolean close() {
        if (!this.fUpdateOnStartupCheck.isDisposed()) {
            this.fPreferences.putBoolean(DefaultPreferences.UPDATE_ON_STARTUP, this.fUpdateOnStartupCheck.getSelection());
        }
        this.fResources.dispose();
        return super.close();
    }

    protected void okPressed() {
        MessageDialog dialog;
        if (!this.fCanUpdate && (dialog = new MessageDialog(this.getShell(), Messages.UpdateDialog_WARNING, null, Messages.UpdateDialog_MISSING_PERMISSIONS_WARNING, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() != 0) {
            return;
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.UpdateDialog_UPDATE_AVAILABLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.UpdateDialog_UPDATE_AVAILABLE);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/update_wiz.png"));
        this.setMessage(Messages.UpdateDialog_NEW_VERSION_MSG);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 5));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite updateInfoContainer = new Composite(composite, 2048);
        updateInfoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5, 0, 5, false));
        updateInfoContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        updateInfoContainer.setBackground(composite.getDisplay().getSystemColor(25));
        this.fUpdateInfoTextLeft = new StyledText(updateInfoContainer, 74);
        this.fUpdateInfoTextLeft.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fUpdateInfoTextLeft.setLineSpacing(5);
        this.fUpdateInfoTextLeft.setEnabled(false);
        this.fUpdateInfoTextLeft.setBackground(composite.getDisplay().getSystemColor(25));
        this.fUpdateInfoTextRight = new StyledText(updateInfoContainer, 74);
        this.fUpdateInfoTextRight.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fUpdateInfoTextRight.setLineSpacing(5);
        this.fUpdateInfoTextRight.setEnabled(false);
        this.fUpdateInfoTextRight.setBackground(composite.getDisplay().getSystemColor(25));
        this.fUpdateInfoTextBottom = new StyledText(updateInfoContainer, 74);
        this.fUpdateInfoTextBottom.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.fUpdateInfoTextBottom.getLayoutData()).widthHint = 300;
        this.fUpdateInfoTextBottom.setLineSpacing(5);
        this.fUpdateInfoTextBottom.setEnabled(false);
        this.fUpdateInfoTextBottom.setBackground(composite.getDisplay().getSystemColor(25));
        this.showUpdateDescription();
        Link link = new Link(updateInfoContainer, 0);
        link.setBackground(updateInfoContainer.getBackground());
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        link.setText(Messages.UpdateDialog_VISIT_HP);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtils.openLinkExternal("http://www.rssowl.org");
            }
        });
        this.fUpdateOnStartupCheck = new Button(composite, 32);
        this.fUpdateOnStartupCheck.setText(Messages.UpdateDialog_UPDATE_ON_STARTUP);
        this.fUpdateOnStartupCheck.setSelection(this.fPreferences.getBoolean(DefaultPreferences.UPDATE_ON_STARTUP));
        if (!this.fCanUpdate) {
            this.setErrorMessage(Messages.UpdateDialog_MISSING_PERMISSIONS_ERROR);
        }
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        UpdateDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean canUpdate() {
        final AtomicBoolean canUpdate = new AtomicBoolean(true);
        SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                File installDirectory;
                Location installLocation = Platform.getInstallLocation();
                if (installLocation != null && installLocation.getURL() != null && !(installDirectory = UpdateDialog.toFile(installLocation.getURL())).isFile()) {
                    File pluginsDir = new File(installDirectory, UpdateDialog.PLUGINS);
                    File featuresDir = new File(installDirectory, UpdateDialog.FEATURES);
                    if (pluginsDir.isDirectory() && featuresDir.isDirectory()) {
                        try {
                            this.writeTempFile(canUpdate, pluginsDir);
                            if (canUpdate.get()) {
                                this.writeTempFile(canUpdate, featuresDir);
                            }
                        }
                        catch (IOException iOException) {
                            canUpdate.set(false);
                        }
                        catch (SecurityException securityException) {
                            canUpdate.set(false);
                        }
                    }
                }
            }

            private void writeTempFile(AtomicBoolean canUpdate2, File dir) throws IOException {
                File tmpFile = File.createTempFile("permcheck", ".tmp", dir);
                tmpFile.deleteOnExit();
                canUpdate2.set(tmpFile.exists() && tmpFile.canWrite());
                tmpFile.delete();
            }
        });
        return canUpdate.get();
    }

    private static File toFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(url.getPath());
        }
    }

    private void showUpdateDescription() {
        String oldVer = null;
        String newVer = null;
        long dlSize = 0L;
        String provider = null;
        String description = null;
        if (this.fUpdates != null && this.fUpdates.length > 0) {
            IURLEntry descriptionEntry;
            IFeature oldFeature = this.fUpdates[0].getOldFeature();
            IFeature newFeature = this.fUpdates[0].getFeature();
            PluginVersionIdentifier oldVersion = oldFeature != null ? oldFeature.getVersionedIdentifier().getVersion() : null;
            PluginVersionIdentifier newVersion = newFeature.getVersionedIdentifier().getVersion();
            if (oldVersion != null) {
                oldVer = String.valueOf(oldVersion.getMajorComponent()) + "." + oldVersion.getMinorComponent() + "." + oldVersion.getServiceComponent();
            }
            if ((newVer = String.valueOf(newVersion.getMajorComponent()) + "." + newVersion.getMinorComponent() + "." + newVersion.getServiceComponent()).equals(oldVer) && oldVersion != null) {
                String newQualifierComponent = newVersion.getQualifierComponent();
                String oldQualifierComponent = oldVersion.getQualifierComponent();
                if (newQualifierComponent.length() == 12 && oldQualifierComponent.length() == 12) {
                    newVer = String.valueOf(newVer) + " (" + this.formatQualifier(newQualifierComponent) + ")";
                    oldVer = String.valueOf(oldVer) + " (" + this.formatQualifier(oldQualifierComponent) + ")";
                } else {
                    newVer = String.valueOf(newVer) + "." + newQualifierComponent;
                    oldVer = String.valueOf(oldVer) + "." + oldQualifierComponent;
                }
            }
            dlSize = newFeature.getDownloadSize() * 1000L;
            provider = newFeature.getProvider();
            ICategory[] categories = newFeature.getSite().getCategories();
            if (categories.length > 0 && (descriptionEntry = categories[0].getDescription()) != null) {
                description = descriptionEntry.getAnnotation();
            }
            if (!StringUtils.isSet(description)) {
                description = Messages.UpdateDialog_QUALIFIER_UPDATE_DESCRIPTION;
            }
            this.showUpdateDescription(oldVer, newVer, dlSize, provider, description);
        }
    }

    private String formatQualifier(String qualifier) {
        if (qualifier.length() == 12) {
            return String.valueOf(qualifier.substring(0, 4)) + "-" + qualifier.substring(4, 6) + "-" + qualifier.substring(6, 8);
        }
        return qualifier;
    }

    private void showUpdateDescription(String oldVer, String newVer, long dlSize, String provider, String description) {
        int offset;
        if (StringUtils.isSet((String)oldVer)) {
            offset = this.fUpdateInfoTextLeft.getText().length();
            this.fUpdateInfoTextLeft.append(Messages.UpdateDialog_CURRENT_VERSION);
            this.fUpdateInfoTextLeft.setStyleRange(new StyleRange(offset, this.fUpdateInfoTextLeft.getText().length() - offset, null, null, 1));
            this.fUpdateInfoTextRight.append(oldVer);
            this.fUpdateInfoTextLeft.append("\n");
            this.fUpdateInfoTextRight.append("\n");
        }
        if (StringUtils.isSet((String)newVer)) {
            offset = this.fUpdateInfoTextLeft.getText().length();
            this.fUpdateInfoTextLeft.append(Messages.UpdateDialog_NEW_VERSION);
            this.fUpdateInfoTextLeft.setStyleRange(new StyleRange(offset, this.fUpdateInfoTextLeft.getText().length() - offset, null, null, 1));
            this.fUpdateInfoTextRight.append(newVer);
            this.fUpdateInfoTextLeft.append("\n");
            this.fUpdateInfoTextRight.append("\n");
        }
        if (StringUtils.isSet((String)provider)) {
            offset = this.fUpdateInfoTextLeft.getText().length();
            this.fUpdateInfoTextLeft.append(Messages.UpdateDialog_UPDATE_PROVIDER);
            this.fUpdateInfoTextLeft.setStyleRange(new StyleRange(offset, this.fUpdateInfoTextLeft.getText().length() - offset, null, null, 1));
            this.fUpdateInfoTextRight.append(provider);
            this.fUpdateInfoTextLeft.append("\n");
            this.fUpdateInfoTextRight.append("\n");
        }
        if (dlSize > 0L) {
            offset = this.fUpdateInfoTextLeft.getText().length();
            this.fUpdateInfoTextLeft.append(Messages.UpdateDialog_DL_SIZE);
            this.fUpdateInfoTextLeft.setStyleRange(new StyleRange(offset, this.fUpdateInfoTextLeft.getText().length() - offset, null, null, 1));
            this.fUpdateInfoTextRight.append(OwlUI.getSize((int)dlSize));
            this.fUpdateInfoTextLeft.append("\n");
            this.fUpdateInfoTextRight.append("\n");
        }
        if (StringUtils.isSet((String)description)) {
            offset = this.fUpdateInfoTextBottom.getText().length();
            this.fUpdateInfoTextBottom.append(Messages.UpdateDialog_DESCRIPTION);
            this.fUpdateInfoTextBottom.append("\n");
            this.fUpdateInfoTextBottom.setStyleRange(new StyleRange(offset, this.fUpdateInfoTextBottom.getText().length() - offset, null, null, 1));
            this.fUpdateInfoTextBottom.append(description);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.UpdateDialog_DOWNLOAD_INSTALL, true).setFocus();
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected int getShellStyle() {
        int style = 0x10870 | UpdateDialog.getDefaultOrientation();
        return style;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

