/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ICategoryDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.ColorPicker;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class LabelDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private final DialogMode fMode;
    private final ILabel fExistingLabel;
    private Text fNameInput;
    private String fName;
    private Collection<ILabel> fAllLabels;
    private ColorPicker fColorPicker;
    private Label fInfoImg;
    private Label fInfoText;
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public LabelDialog(Shell parentShell, DialogMode mode, ILabel label) {
        super(parentShell);
        this.fMode = mode;
        this.fExistingLabel = label;
        this.fAllLabels = CoreUtils.loadSortedLabels();
    }

    public String getName() {
        return this.fName != null ? this.fName.trim() : null;
    }

    public RGB getColor() {
        return this.fColorPicker.getColor();
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Label nameLabel;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10, 5, 6, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.fMode == DialogMode.ADD || this.fMode == DialogMode.EDIT) {
            nameLabel = new Label(composite, 0);
            nameLabel.setText(Messages.LabelDialog_NAME);
            this.fNameInput = new Text(composite, 2052);
            this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
            if (this.fExistingLabel != null) {
                this.fNameInput.setText(this.fExistingLabel.getName());
                this.fNameInput.selectAll();
                this.fNameInput.setFocus();
            }
            this.fNameInput.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LabelDialog.this.onModifyName();
                }
            });
            final Pair<SimpleContentProposalProvider, ContentProposalAdapter> pair = OwlUI.hookAutoComplete(this.fNameInput, null, true, false);
            JobRunner.runInBackgroundThread(100, new Runnable(){

                public void run() {
                    if (!LabelDialog.this.fNameInput.isDisposed()) {
                        TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.compareToIgnoreCase(o2);
                            }
                        });
                        Set categoryNames = ((ICategoryDAO)DynamicDAO.getDAO(ICategoryDAO.class)).loadAllNames();
                        categoryNames = StringUtils.replaceAll((Set)categoryNames, (String)",", (String)" ");
                        values.addAll(categoryNames);
                        if (!LabelDialog.this.fNameInput.isDisposed()) {
                            OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)pair.getFirst(), (ContentProposalAdapter)pair.getSecond(), false);
                        }
                    }
                }
            });
        }
        if (this.fMode == DialogMode.ADD || this.fMode == DialogMode.EDIT) {
            nameLabel = new Label(composite, 0);
            nameLabel.setText(Messages.LabelDialog_COLOR);
            this.fColorPicker = new ColorPicker(composite, 0x800000);
            if (this.fExistingLabel != null) {
                this.fColorPicker.setColor(OwlUI.getRGB(this.fExistingLabel));
            }
        }
        Composite infoContainer = new Composite(composite, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 15;
        this.fInfoImg = new Label(infoContainer, 0);
        this.fInfoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fInfoText = new Label(infoContainer, 64);
        this.fInfoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showInfo();
        LabelDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void showInfo() {
        switch (this.fMode) {
            case ADD: {
                this.fInfoText.setText(Messages.LabelDialog_ENTER_NEW_LABEL);
                break;
            }
            case EDIT: {
                this.fInfoText.setText(Messages.LabelDialog_EDIT_LABEL_INFO);
            }
        }
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/info.gif"));
        this.fInfoImg.getParent().layout();
    }

    private void showError(String msg) {
        this.fInfoText.setText(msg);
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/error.gif"));
        this.fInfoImg.getParent().layout();
    }

    private void onModifyName() {
        boolean labelExists = false;
        String inputValue = this.fNameInput.getText().trim().toLowerCase();
        if (inputValue.contains(",")) {
            this.getButton(0).setEnabled(false);
            this.showError(Messages.LabelDialog_ERROR_COMMA);
            return;
        }
        for (ILabel label : this.fAllLabels) {
            if (!label.getName().toLowerCase().equals(inputValue) || label == this.fExistingLabel) continue;
            labelExists = true;
            break;
        }
        this.getButton(0).setEnabled(!labelExists && this.fNameInput.getText().length() > 0);
        if (labelExists) {
            this.showError(Messages.LabelDialog_LABEL_EXISTS);
        } else {
            this.showInfo();
        }
    }

    protected Control createButtonBar(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.fNameInput.getText().length() > 0);
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        switch (this.fMode) {
            case ADD: {
                newShell.setText(Messages.LabelDialog_NEW_LABEL);
                break;
            }
            case EDIT: {
                newShell.setText(Messages.LabelDialog_EDIT_LABEL);
            }
        }
    }

    protected void okPressed() {
        if (this.fNameInput != null) {
            this.fName = this.fNameInput.getText();
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialogMode {
        ADD,
        EDIT;

    }
}

