/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class AggregateNewsDialog
extends TitleAreaDialog {
    private Button fRememberDecisionCheck;
    private LocalResourceManager fResources;
    private IPreferenceScope fPreferences;
    private final String fFolderName;

    public AggregateNewsDialog(Shell parentShell, String folderName) {
        super(parentShell);
        this.fFolderName = folderName;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 2: {
                this.fPreferences.putBoolean(DefaultPreferences.REMEMBER_AGGREGATE_NEWS_OPTION, this.fRememberDecisionCheck.getSelection());
                if (this.fRememberDecisionCheck.getSelection()) {
                    this.fPreferences.putBoolean(DefaultPreferences.AGGREGATE_NEWS_AS_SEARCH, true);
                }
                this.setReturnCode(buttonId);
                this.close();
                break;
            }
            case 3: {
                this.fPreferences.putBoolean(DefaultPreferences.REMEMBER_AGGREGATE_NEWS_OPTION, this.fRememberDecisionCheck.getSelection());
                if (this.fRememberDecisionCheck.getSelection()) {
                    this.fPreferences.putBoolean(DefaultPreferences.AGGREGATE_NEWS_AS_SEARCH, false);
                }
                this.setReturnCode(buttonId);
                this.close();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AggregateNewsDialog_AGGREGATE_NEWS);
    }

    protected String getTitleImage() {
        return "/icons/wizban/aggfolder_wiz.png";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.AggregateNewsDialog_AGGREGATE_NEWS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, this.getTitleImage()));
        this.setMessage(NLS.bind((String)Messages.AggregateNewsDialog_AGGREGATE_NEWS_OF_N, (Object)this.fFolderName));
        Label dialogMessageLabel = new Label(composite, 64);
        dialogMessageLabel.setText(Messages.AggregateNewsDialog_AGGREGATION_RECOMMENDATION);
        dialogMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(composite, 0);
        this.fRememberDecisionCheck = new Button(composite, 32);
        this.fRememberDecisionCheck.setText(Messages.AggregateNewsDialog_REMEMBER_DECISION);
        Composite sepHolder = new Composite(parent, 0);
        sepHolder.setLayoutData((Object)new GridData(4, 1, true, false));
        sepHolder.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        Label separator = new Label(sepHolder, 258);
        separator.setLayoutData((Object)new GridData(768));
        AggregateNewsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        this.getButton(2).setFocus();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(320), -1);
        Point location = this.getInitialLocation(bestSize);
        this.getShell().setBounds(location.x, location.y, bestSize.x, bestSize.y);
    }
}

