/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ActivityDialog
extends TitleAreaDialog {
    private static ActivityDialog fgVisibleInstance;
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.ActivityDialog";
    private static final int MIN_DIALOG_HEIGHT_DLU = 160;
    private DetailedProgressViewer fViewer;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private IDialogSettings fDialogSettings = Activator.getDefault().getDialogSettings();
    private boolean fFirstTimeOpen = this.fDialogSettings.getSection("org.rssowl.ui.internal.dialogs.ActivityDialog") == null;
    private Button fHideCompletedCheck;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();

    public ActivityDialog(Shell parentShell) {
        super(parentShell);
    }

    public static ActivityDialog getVisibleInstance() {
        return fgVisibleInstance;
    }

    public int open() {
        fgVisibleInstance = this;
        return super.open();
    }

    public boolean close() {
        fgVisibleInstance = null;
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ActivityDialog_DOWNLOADS_ACTIVITY);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fgVisibleInstance = null;
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.getButton(0).setFocus();
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ActivityDialog_DOWNLOADS_AND_ACTIVITY);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/activity_wiz.png"));
        this.setMessage(Messages.ActivityDialog_ACTIVITY_INFO);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer = new DetailedProgressViewer(composite, 0);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        boolean hideCompleted = this.fPreferences.getBoolean(DefaultPreferences.HIDE_COMPLETED_DOWNLOADS);
        this.fViewer.setContentProvider((IContentProvider)new ProgressViewerContentProvider((AbstractProgressViewer)this.fViewer, false, !hideCompleted));
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object obj1, Object obj2) {
                if (obj1 instanceof Comparable && obj2 instanceof Comparable) {
                    return ((Comparable)obj1).compareTo(obj2);
                }
                return super.compare(viewer, obj1, obj2);
            }
        });
        this.fViewer.setInput((Object)ProgressManager.getInstance());
        this.updateViewerSize();
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        ActivityDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateViewerSize() {
        Point size = this.fViewer.getControl().computeSize(-1, -1);
        size.x += 4;
        size.y += 4;
        ((ScrolledComposite)this.fViewer.getControl()).setMinSize(size);
    }

    protected int getShellStyle() {
        int style = 0x8F0 | ActivityDialog.getDefaultOrientation();
        return style;
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        this.fHideCompletedCheck = new Button(buttonBar, 32);
        this.fHideCompletedCheck.setText(Messages.ActivityDialog_REMOVE_COMPLETED);
        this.fHideCompletedCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fHideCompletedCheck.setSelection(this.fPreferences.getBoolean(DefaultPreferences.HIDE_COMPLETED_DOWNLOADS));
        this.fHideCompletedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final boolean hideCompleted = ActivityDialog.this.fHideCompletedCheck.getSelection();
                ActivityDialog.this.refreshProgressViewer(hideCompleted);
                JobRunner.runInBackgroundThread(new Runnable(){

                    public void run() {
                        ActivityDialog.this.fPreferences.putBoolean(DefaultPreferences.HIDE_COMPLETED_DOWNLOADS, hideCompleted);
                    }
                });
            }
        });
        this.createButton(buttonBar, 0, IDialogConstants.OK_LABEL, true);
        return buttonBar;
    }

    private void refreshProgressViewer(boolean hideCompleted) {
        this.fViewer.setContentProvider((IContentProvider)new ProgressViewerContentProvider((AbstractProgressViewer)this.fViewer, false, !hideCompleted));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings section = this.fDialogSettings.getSection(SETTINGS_SECTION);
        if (section != null) {
            return section;
        }
        return this.fDialogSettings.addNewSection(SETTINGS_SECTION);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.fFirstTimeOpen) {
            Shell shell = this.getShell();
            int minWidth = this.convertHorizontalDLUsToPixels(320);
            int minHeight = this.convertVerticalDLUsToPixels(160);
            Point requiredSize = shell.computeSize(-1, -1);
            shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
            LayoutUtils.positionShell(shell);
        }
    }
}

