/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
#ifndef GENERAL_H
#define GENERAL_H

#include <iconv.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <pthread.h>

#include "support.h"
#include "struct.h"
#include "files.h"
#include "interface.h"
#include "gui-general.h"

#define GITM_VERSION "0.5"

char * create_string (const char *str);
char * get_file_name (char *fullpath);
char * gitm_strcat (char *str1, char *str2);
char * gitm_stradd (char *str1, char *str2);
struct loaded_file * encode_file (char *filepath);
char * charsetconvert (char *str);
char * charsetconvert_back (char *s);
unsigned char * base64_encode(const unsigned char *src, size_t len, size_t *out_len);
int elt_size (char *start, int max);
char * convertion (char *text);
void * gitm_malloc (size_t size);
void * gitm_realloc (void *oldptr, size_t size);
void server_error (char *text);

#endif
