/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.common.wizards.EditEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.Messages;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EntryValueEditor
extends CellEditor
implements IValueEditor {
    private Object value;
    private Composite parent;
    private String name;
    private ImageDescriptor imageDescriptor;
    protected ValueEditorManager valueEditorManager;

    public EntryValueEditor(Composite parent, ValueEditorManager valueEditorManager) {
        super(parent);
        this.parent = parent;
        this.valueEditorManager = valueEditorManager;
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected final Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        this.value = value;
    }

    public void activate() {
        IEntry entry;
        if (this.getValue() != null && this.getValue() instanceof IEntry && (entry = (IEntry)this.getValue()) != null) {
            EditEntryWizard wizard = new EditEntryWizard(entry);
            WizardDialog dialog = new WizardDialog(this.parent.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
        }
        this.fireCancelEditor();
    }

    @Override
    public CellEditor getCellEditor() {
        return this;
    }

    @Override
    public String getDisplayValue(AttributeHierarchy attributeHierarchy) {
        ArrayList<IValue> valueList = new ArrayList<IValue>();
        for (IAttribute attribute : attributeHierarchy) {
            valueList.addAll(Arrays.asList(attribute.getValues()));
        }
        StringBuffer sb = new StringBuffer();
        if (valueList.size() > 1) {
            sb.append(NLS.bind((String)Messages.getString("EntryValueEditor.n_values"), (Object)valueList.size()));
        }
        Iterator it = valueList.iterator();
        while (it.hasNext()) {
            IValue value = (IValue)it.next();
            IValueEditor vp = this.getValueEditor(value);
            sb.append(vp.getDisplayValue(value));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getDisplayValue(IValue value) {
        IValueEditor vp = this.getValueEditor(value);
        return vp.getDisplayValue(value);
    }

    private IValueEditor getValueEditor(IValue value) {
        IValueEditor vp = this.valueEditorManager.getCurrentValueEditor(value.getAttribute().getEntry(), value.getAttribute().getDescription());
        if (vp instanceof EntryValueEditor) {
            IValueEditor userSelectedValueEditor = this.valueEditorManager.getUserSelectedValueEditor();
            this.valueEditorManager.setUserSelectedValueEditor(null);
            vp = this.valueEditorManager.getCurrentValueEditor(value.getAttribute().getEntry(), value.getAttribute().getDescription());
            this.valueEditorManager.setUserSelectedValueEditor(userSelectedValueEditor);
        }
        return vp;
    }

    @Override
    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        return attributeHierarchy.getEntry();
    }

    @Override
    public Object getRawValue(IValue value) {
        return value.getAttribute().getEntry();
    }

    @Override
    public Object getStringOrBinaryValue(Object rawValue) {
        return null;
    }

    @Override
    public void setValueEditorName(String name) {
        this.name = name;
    }

    @Override
    public String getValueEditorName() {
        return this.name;
    }

    @Override
    public void setValueEditorImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public ImageDescriptor getValueEditorImageDescriptor() {
        return this.imageDescriptor;
    }
}

